package volumeviz.sample.fenceSlice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JCheckBox;

import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.SoLDMGlobalResourceParameters;
import com.openinventor.volumeviz.nodes.SoFenceSlice;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  Vector<SoFenceSlice> fenceSlices;
  static final String DATA_FILE = "$OIVJHOME/data/volumeviz/scene_fenceSlice.iv";

  private IViewerExaminer myViewer;

  public void start()
  {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    SoLDMGlobalResourceParameters.setViewCulling(false);
    SoLDMGlobalResourceParameters.setViewpointRefinement(false);
    SoLDMGlobalResourceParameters.setScreenResolutionCulling(false);

    // Open the input file
    SoSeparator scene = readSceneGraph(DATA_FILE);

    SoSeparator root = new SoSeparator();
    root.addChild(scene);

    fenceSlices = searchFenceSlices(scene);

    // Set up viewer:
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    buildUI();
  }

  // search all occurrences of SoFenceSlice in the given scene graph
  Vector<SoFenceSlice> searchFenceSlices(SoNode scene)
  {
    SoSearchAction sa = new SoSearchAction();
    sa.setNodeClass(SoFenceSlice.class);
    sa.setInterest(SoSearchAction.Interests.ALL);

    sa.apply(scene);

    Vector<SoPath> paths = sa.getPaths();
    if ( paths.size() == 0 )
    {
      System.err.println("SoFenceSlice not found");
    }

    Vector<SoFenceSlice> ret = new Vector<SoFenceSlice>();
    for ( SoPath element : paths )
      ret.add((SoFenceSlice)element.regular.getTail());

    return ret;
  }

  private void enableBumpMapping(boolean onoff)
  {
    // enable bump mapping for each slice
    for ( SoFenceSlice fenceSlice : fenceSlices )
      fenceSlice.enableBumpMapping.setValue(onoff);
  }

  void buildUI()
  {
    // add a check box to enable BumpMapping
    final JCheckBox checkBump = new JCheckBox("Bump mapping: ");
    checkBump.setHorizontalTextPosition(JCheckBox.LEFT);
    checkBump.addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent arg0)
      {
        enableBumpMapping(checkBump.isSelected());
      }
    });

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
    add(checkBump, BorderLayout.SOUTH);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

  private static SoSeparator readSceneGraph(String fileName)
  {
    SoInput input = new SoInput();

    if ( !input.openFile(fileName) )
    {
      System.err.println("Cannot open file " + fileName);
      return null;
    }

    SoSeparator node = SoDB.readAll(input);
    if ( node == null )
    {
      System.err.println("Problem reading file");
      input.closeFile();
      return null;
    }

    input.closeFile();
    return node;
  }

  public static void main(String argv[])
  {
    Main example = new Main();
    example.demoMain("Fence Slice");
  }
}
