//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizfnc_frag.h>
//!oiv_include <VolumeViz/vvizStructure.h>

uniform VVizDataSetId hfGeom;
uniform VVizDataSetId volData;

VVIZ_DATATYPE VVizCombineData(vec3 tcoord)
{
  // First get HeighField value
  // We are doing HeighField rendering, so the input coordinates correspond to HeightField coordinates
  VVIZ_DATATYPE heightFieldValue = VVizGetData(hfGeom, tcoord);

  // Convert HeighField 3D texture coordinates (with height value as Z) to VolumeData texture coordinates
  // This transformation is based on the Model Matrix and extent of each data set
  vec3 volumeTexCoords = VVizTextureToTextureVec(hfGeom, volData, vec3(tcoord.xy, heightFieldValue));

  // Finally get VolumeData value using converted coordinates after checking the out-of-bounds case
  if (VVizIsOutsideTexture(volumeTexCoords))
    return VVIZ_DATATYPE(0.0);
  else
    return VVizGetData(volData, volumeTexCoords);
}
