//!oiv_include <VolumeViz/vvizVertexShift_tess.h>

uniform float heightScale;
uniform vec3 spherePosition;

vec3
VVizTessVertexShift( in vec3 position, in vec2 texCoord )
{
  vec2 XYorientation = position.xy - spherePosition.xy;
  float angle = length(XYorientation) / spherePosition.z;
  vec3 projectedFloor = spherePosition.z * vec3(sin(angle) * normalize(XYorientation), 1.0 - cos(angle));
  return spherePosition + (abs(spherePosition.z) + heightScale * position.z) * normalize(projectedFloor - spherePosition);
}
