package volumeviz.sample.multiVolumes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingConstants;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoRotation;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSphere;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.awt.tools.SliderPanel;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeGroup;
import com.openinventor.volumeviz.nodes.SoVolumeRender;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  SoVolumeData m_volumeData1;
  SoVolumeData m_volumeData2;
  SoVolumeGroup m_volumeGroup;
  SoMaterial m_material1;
  SoMaterial m_material2;
  SoTranslation m_translation;
  SoRotation m_rotation;
  SoVolumeRender m_volumeRender1;
  SoVolumeRender m_volumeRender2;

  private IViewerExaminer m_viewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("Multi Volumes");
   }

   @Override
  public void start() {
     m_viewer = ViewerComponentsFactory.createViewerExaminer();

     String fileName = "$OIVJHOME/data/volumeviz/agipAVS.fld";
     m_volumeData1 = new SoVolumeData();
     m_volumeData1.fileName.setValue(fileName);
     float transparency = 0.98f;

     m_volumeData2 = new SoVolumeData();
     m_volumeData2.fileName.setValue(fileName);

     //use of a predefined colorMap with the SoTransferFunction
     SoTransferFunction transferFunction1 = new SoTransferFunction();
     transferFunction1.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.STANDARD);
     //pTransFunc1.reMap(1,255);
     SoTransferFunction transferFunction2 = new SoTransferFunction();
     transferFunction2.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.TEMPERATURE);
     transferFunction2.minValue.setValue(15);
     transferFunction2.maxValue.setValue(255);

     SoSphere sphere = new SoSphere();
     sphere.radius.setValue(0.5f);

     SoSeparator volumeSep = new SoSeparator();

     // VolumeViz Scene Graph
     m_material1 = new SoMaterial();
     m_material1.transparency.setValue(transparency);
     m_material2 = new SoMaterial();
     m_material2.transparency.setValue(transparency);

     m_volumeGroup = new SoVolumeGroup();
     m_volumeGroup.multiVolumes.setValue(false);

     m_translation = new SoTranslation();
     m_translation.translation.setValue(new SbVec3f(3,0,0));

     m_rotation = new SoRotation();

     m_volumeRender1 = new SoVolumeRender();
     m_volumeRender1.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.VIEW_ALIGNED);
     m_volumeRender2 = new SoVolumeRender();
     m_volumeRender2.samplingAlignment.connectFrom( m_volumeRender1.samplingAlignment );

     SoSeparator root = new SoSeparator();
     { // Assemble scene graph
       // Volume group
       m_volumeGroup.addChild(m_volumeData1);
       m_volumeGroup.addChild(transferFunction1);
       m_volumeGroup.addChild(m_material1);
       m_volumeGroup.addChild(m_volumeRender1);
       m_volumeGroup.addChild(m_translation);
       m_volumeGroup.addChild(m_rotation);
       m_volumeGroup.addChild(m_volumeData2);
       m_volumeGroup.addChild(transferFunction2);
       m_volumeGroup.addChild(m_material2);
       m_volumeGroup.addChild(m_volumeRender2);
       volumeSep.addChild(m_volumeGroup);
       // Top Scene Graph
       root.addChild(sphere);
       root.addChild(volumeSep);
     }

     m_viewer.getRenderArea().setTransparencyType(SoGLRenderAction.TransparencyTypes.NO_SORT);
     m_viewer.setSceneGraph(root);
     m_viewer.viewAll();

     jbInit();
   }

  @Override
  public void stop()
  {
    m_viewer.dispose();
  }

   private void jbInit() {
     // checkBox panel
     JPanel box_panel = new JPanel();
     final JCheckBox multi_volumes_box = new JCheckBox("Multi Volumes Deactivated");
     multi_volumes_box.addItemListener(new ItemListener() {
       @Override
      public void itemStateChanged(ItemEvent e) {
         boolean selected = (e.getStateChange() == ItemEvent.SELECTED);
         m_volumeGroup.multiVolumes.setValue(selected);
         if (selected)
           multi_volumes_box.setText("Multi Volumes Activated");
         else
           multi_volumes_box.setText("Multi Volumes Deactivated");
       }
     });
     JCheckBox view_box = new JCheckBox("View Aligned Slices", true);
     view_box.addItemListener(new ItemListener() {
       @Override
      public void itemStateChanged(ItemEvent e) {
         boolean selected = e.getStateChange() == ItemEvent.SELECTED;
         if ( selected )
           m_volumeRender1.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.VIEW_ALIGNED);
         else
           m_volumeRender1.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.DATA_ALIGNED);
       }
     });
     box_panel.add(multi_volumes_box, SwingConstants.CENTER);
     box_panel.add(view_box);

     // X translation slider
     float initial_Xtrans = m_translation.translation.getValue().getX();
     SliderPanel Xtranslation_slider_panel = new SliderPanel(-3, 3, initial_Xtrans, 3);
     Xtranslation_slider_panel.setSliderSize(new Dimension(300, 20));
     Xtranslation_slider_panel.setBorder(new TitledBorder(new EtchedBorder(),
         "Object Spacing"));
     Xtranslation_slider_panel.addSliderPanelListener(new SliderPanel.Listener() {
       @Override
      public void stateChanged(float value) {
         m_translation.translation.setValue(new SbVec3f(value, 0, 0));
       }
     });

     // rotation slider
     SliderPanel rotation_slider_panel = new SliderPanel(-90, 90, 0);
     rotation_slider_panel.setSliderSize(new Dimension(300, 20));
     rotation_slider_panel.setBorder(new TitledBorder(new EtchedBorder(),
         "Object Rotation"));
     rotation_slider_panel.setTextFieldColumns
         (Xtranslation_slider_panel.getTextFieldColumns());
     rotation_slider_panel.addSliderPanelListener(new SliderPanel.Listener() {
       @Override
      public void stateChanged(float value) {
         m_rotation.rotation.setValue(new SbRotation(new SbVec3f(1, 0, 0),
                                                     3.14f / 180 * value));
       }
     });

     // transparency slider 1
     float initial_transp1 = m_material1.transparency.getValueAt(0);
     SliderPanel transp_slider1_panel = new SliderPanel(0, 1, initial_transp1, 3);
     transp_slider1_panel.setSliderSize(new Dimension(300, 20));
     transp_slider1_panel.setBorder(new TitledBorder(new EtchedBorder(),
                                                     "Transparency Object 1"));
     transp_slider1_panel.addSliderPanelListener(new SliderPanel.Listener() {
       @Override
      public void stateChanged(float value) {
         m_material1.transparency.setValue(value);
       }
     });

     // transparency slider 2
     float initial_transp2 = m_material2.transparency.getValueAt(0);
     SliderPanel transp_slider2_panel = new SliderPanel(0, 1, initial_transp2, 3);
     transp_slider2_panel.setSliderSize(new Dimension(300, 20));
     transp_slider2_panel.setBorder(new TitledBorder(new EtchedBorder(),
                                                     "Transparency Object 2"));
     transp_slider2_panel.addSliderPanelListener(new SliderPanel.Listener() {
       @Override
      public void stateChanged(float value) {
         m_material2.transparency.setValue(value);
       }
     });

     // main panel
     JPanel main_panel = new JPanel(new GridLayout(5, 1));
     main_panel.setBorder(BorderFactory.createRaisedBevelBorder());
     main_panel.add(box_panel);
     main_panel.add(Xtranslation_slider_panel);
     main_panel.add(rotation_slider_panel);
     main_panel.add(transp_slider1_panel);
     main_panel.add(transp_slider2_panel);

     // ScrollPane
     JScrollPane scroll_pane = new JScrollPane(main_panel);

     // SplitPane
     JPanel iPanel = new JPanel(new BorderLayout());
     final Component component = m_viewer.getComponent();
     component.setPreferredSize(new java.awt.Dimension(600, 500));
     iPanel.add(component,BorderLayout.CENTER);
     iPanel.setMinimumSize(new Dimension(1,1));

     JSplitPane split_pane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true, iPanel,
                                     scroll_pane);
     split_pane.setOneTouchExpandable(true);
     split_pane.setResizeWeight(0.6);

    setLayout(new BorderLayout());
    add(split_pane);
   }
}
