package volumeviz.sample.renderModes;

import java.awt.BorderLayout;
import java.awt.Dimension;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoSceneManager.AntialiasingModes;
import com.openinventor.inventor.actions.SoGLRenderAction.TransparencyTypes;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.misc.callbacks.SoEventCallbackCB;
import com.openinventor.inventor.nodes.SoBBox;
import com.openinventor.inventor.nodes.SoBaseColor;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoCube;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoEventCallback;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoGradientBackground;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoText2;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.nodes.SceneOrbiter;
import com.openinventor.inventor.viewercomponents.nodes.SoViewingCube;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;
import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IRenderAreaInteractive m_viewer;
  private SoVolumeRender m_volumeRender;
  int m_volumeRenderMode = 0;
  SoText2 m_helpText;
  
  class KeyEventHandler extends SoEventCallbackCB
  {
    public void invoke( SoEventCallback sender )
    {
      SoKeyboardEvent kevent = (SoKeyboardEvent)sender.getEvent();
  
      if (SoKeyboardEvent.isKeyPressEvent(kevent, SoKeyboardEvent.Keys.UP_ARROW))
        m_volumeRenderMode++;
      else if (SoKeyboardEvent.isKeyPressEvent(kevent, SoKeyboardEvent.Keys.DOWN_ARROW))
        m_volumeRenderMode--;
      else
        return;
  
      m_volumeRenderMode = (m_volumeRenderMode < 0) ? 4 : m_volumeRenderMode % 5;
  
      if (m_volumeRenderMode == 0)
      {
        m_volumeRender.renderMode.setValue(SoVolumeRender.RenderModes.MAX_INTENSITY_DIFFERENCE_ACCUMULATION);
      }
      else if (m_volumeRenderMode == 1)
      {
        m_volumeRender.renderMode.setValue(SoVolumeRender.RenderModes.INTENSITY_DIFFERENCE_ACCUMULATION);
      }
      else if (m_volumeRenderMode == 2)
      {
        m_volumeRender.renderMode.setValue(SoVolumeRender.RenderModes.MAX_GRADIENT_DIFFERENCE_ACCUMULATION);
      }
      else if (m_volumeRenderMode == 3)
      {
        m_volumeRender.renderMode.setValue(SoVolumeRender.RenderModes.GRADIENT_DIFFERENCE_ACCUMULATION);
      }
      else if (m_volumeRenderMode == 4)
      {
        m_volumeRender.renderMode.setValue(SoVolumeRender.RenderModes.VOLUME_RENDERING);
      }
      m_helpText.string.set1Value(0,m_volumeRender.renderMode.getValue(SoVolumeRender.RenderModes.class).toString());
    }
  }
  
  @Override
  public void start()
  {

    ////////////////////////////////////////////////////////
    /// Scene Graph
    var root = new SoSeparator();
    
    final SbColor bgColor = new SbColor(.0f, .1f, .1f);
    SoGradientBackground gradientBackground = new SoGradientBackground();
    gradientBackground.color0.setValue(bgColor);
    gradientBackground.color1.setValue(bgColor);
    root.addChild(gradientBackground);
    
    var myEventCB = new SoEventCallback();
    myEventCB.addEventCallback( SoKeyboardEvent.class, new KeyEventHandler() );
    root.addChild(myEventCB);

    var volRendSep = new SoSeparator();
    root.addChild(volRendSep);

    var volData = new SoVolumeData();
    volData.fileName.setValue("$OIVJHOME/data/VolumeViz/ENGINE.VOL");

    var transFunction = new SoTransferFunction();
    transFunction.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.INTENSITY);
    transFunction.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.NONE);
    var ramp = new float[256*4];
    for (int i = 0; i < 256; ++i)
    {
      float val = (float)i / (float)255.0;
      ramp[3 * i + 0] = val;
      ramp[3 * i + 1] = val;
      ramp[3 * i + 2] = val;
      ramp[3 * i + 5] = val;
    }
    transFunction.colorMap.setValues(0, ramp);
    
    
    var volumeQuality = new SoVolumeRenderingQuality();
    volumeQuality.interpolateOnMove.setValue(true);
    volumeQuality.deferredLighting.setValue(false);
    
    m_volumeRender = new SoVolumeRender();
    m_volumeRender.renderMode.setValue(SoVolumeRender.RenderModes.MAX_INTENSITY_DIFFERENCE_ACCUMULATION);
    m_volumeRender.samplingAlignment.setValue(SoVolumeRender.SamplingAlignments.VIEW_ALIGNED);

    volRendSep.addChild(volumeQuality);
    volRendSep.addChild(volData);
    volRendSep.addChild(transFunction);
    volRendSep.addChild(m_volumeRender);
    
    // Add Bbox
    root.addChild(createBBox(volData.extent.getValue()));
    
    var helpSep = new SoSeparator();
    root.addChild(helpSep);
    {
      var bboxNode = new SoBBox();
      bboxNode.mode.setValue(SoBBox.Modes.NO_BOUNDING_BOX);
      helpSep.addChild(bboxNode);

      var orthoCam = new SoOrthographicCamera();
      helpSep.addChild(orthoCam);
      orthoCam.viewportMapping.setValue(SoCamera.ViewportMappings.LEAVE_ALONE);

      var helpColor = new SoBaseColor();
      helpSep.addChild(helpColor);
      helpColor.rgb.set1Value(0, new SbColor(0, 0.9f, 0));

      var helpTrans = new SoTranslation();
      helpSep.addChild(helpTrans);
      helpTrans.translation.setValue(new SbVec3f(0, -.88f, 0));

      var helpFont = new SoFont();
      helpSep.addChild(helpFont);
      helpFont.size.setValue(15);
      helpFont.name.setValue("Arial:Bold");
      helpFont.renderStyle.setValue(SoFont.RenderStyles.TEXTURE);
      
      m_helpText = new SoText2();
      m_helpText.justification.setValue(SoText2.Justifications.CENTER);
      helpSep.addChild(m_helpText);
      m_helpText.string.setNum(2);
      m_helpText.string.set1Value(0,m_volumeRender.renderMode.getValue(SoVolumeRender.RenderModes.class).toString());
      m_helpText.string.set1Value(1, "Use Up or Down Arrow to switch the renderMode");
    }

    ////////////////////////////////////////////////////////
    /// Viewer
    m_viewer = ViewerComponentsFactory.createRenderAreaOrbiter();
    setLayout(new BorderLayout());
    add(m_viewer.getComponent(), BorderLayout.CENTER);

    m_viewer.setSceneGraph(root);

    SoViewingCube vCube = ((SceneOrbiter) m_viewer.getSceneInteractor()).getViewingCube();
    vCube.edgeStyle.setValue(SoViewingCube.EdgeStyles.CORNER);

    m_viewer.getComponent().setPreferredSize(new Dimension(800, 600));
    m_viewer.setTransparencyType(TransparencyTypes.OPAQUE_FIRST);
    m_viewer.setAntialiasingMode(AntialiasingModes.AUTO);
    m_viewer.setAntialiasingQuality(1);
    var camRotation = new SbRotation(new SbVec3f(-1.0f, 0.0f, 0.0f), 0.5f);
    camRotation.multiply(new SbRotation(new SbVec3f(0.0f, 1.0f, 0.0f), -2.4f));
    m_viewer.getSceneInteractor().getCamera().orientation.setValue(camRotation);
    m_viewer.viewAll(new SbViewportRegion());
  }

  @Override
  public void stop()
  {
    m_viewer.dispose();
  }

  public static void main(String[] argv)
  {
    Main example = new Main();
    example.demoMain("RenderModes");
  }

  ////////////////////////////////////////////////////////////////////////
  // Helper for Bbox creation
  private SoSeparator createBBox(SbBox3f bbox)
  {
    var bboxSep = new SoSeparator();

    SoPickStyle pickStyle = new SoPickStyle();
    bboxSep.addChild(pickStyle);
    pickStyle.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    var drawStyle = new SoDrawStyle();
    bboxSep.addChild(drawStyle);
    drawStyle.style.setValue(SoDrawStyle.Styles.LINES);
    drawStyle.lineWidth.setValue(2.0f);

    var bboxMat = new SoBaseColor();
    bboxMat.rgb.setValue(new SbVec3f(1, 0, 0));
    bboxSep.addChild(bboxMat);

    var lightModel = new SoLightModel();
    bboxSep.addChild(lightModel);
    lightModel.model.setValue(SoLightModel.Models.BASE_COLOR);

    var translation = new SoTranslation();
    bboxSep.addChild(translation);
    translation.translation.setValue(bbox.getCenter());

    var cube = new SoCube();
    SbVec3f bboxSize = bbox.getSize();
    cube.width.setValue(bboxSize.getValueAt(0));
    cube.height.setValue(bboxSize.getValueAt(1));
    cube.depth.setValue(bboxSize.getValueAt(2));
    bboxSep.addChild(cube);

    return bboxSep;
  }
}
