package volumeviz.sample.simpleIsosurface;

import java.awt.BorderLayout;
import java.awt.Component;

import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.nodes.SoDirectionalLight;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeIsosurface;
import com.openinventor.volumeviz.nodes.SoVolumeRender;
import com.openinventor.volumeviz.nodes.SoVolumeRenderingQuality;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  static final boolean HighRenderingQuality = true;

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("VolumeIsosurface");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    // Node to hold the volume data
    SoVolumeData pVolData = new SoVolumeData();
    pVolData.fileName.setValue("$OIVJHOME/data/volumeviz/3DHEAD.ldm");

    // Enhance lighting
    SoVolumeRenderingQuality pVolRenderQuality = new SoVolumeRenderingQuality();
    pVolRenderQuality.lighting.setValue(true);
    pVolRenderQuality.deferredLighting.setValue(false);

    // Property node which allow SoVolumeRender to draw isosurface for
    // the isovalue 34
    SoVolumeIsosurface pVRIsosurface = new SoVolumeIsosurface();
    pVRIsosurface.isovalues.set1Value(0, 34);

    // Node in charge of drawing the volume
    SoVolumeRender pVolRender = new SoVolumeRender();
    pVolRender.numSlicesControl.setValue(SoVolumeRender.NumSlicesControls.ALL);

    //Material which defines the isosurface diffuse color, transparency,
    //specular color and shininess
    SoMaterial matVolRend = new SoMaterial();
    matVolRend.diffuseColor.setValue(1,1,1);
    matVolRend.transparency.setValue( 0.0f );
    matVolRend.specularColor.setValue(1,1,1);
    matVolRend.shininess.setValue(0.5f);

    // Assemble the scene graph
    // Note: SoVolumeRender must appear after the SoVolumeData node.
    SoSeparator root = new SoSeparator();
    { //Assemble scene graph
      root.addChild(new SoDirectionalLight());
      root.addChild( matVolRend );
      root.addChild( pVolData );
      root.addChild(pVolRenderQuality);
      root.addChild( pVRIsosurface );
      root.addChild( pVolRender );
    }

    myViewer.getRenderArea().setTransparencyType(SoGLRenderAction.TransparencyTypes.NO_SORT);
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }

}
