#ifndef OIV_INSTANCING_H
#define OIV_INSTANCING_H

/**
 * @ingroup InventorInstancing
 * @file
 * This file contains fonction to access instancing parameters.
 */

/**
 * Initialize instancing.
 * Must be called when doing instancing.
 */
void OivInstancingInit();

/**
 * Get the current instance ID when using multiple instance.
 * @return the shape instance ID.
 */
int OivInstanceID();

/**
 * Get the translation vector to apply to the current geometry instance.
 * @return the shape instance translation.
 */
vec3 OivInstanceTranslation();

/**
 * Get the scale vector to apply to the current geometry instance.
 * @return the shape instance scale.
 */
vec3 OivInstanceScale();

/**
 * Get the rotation (i.e. a quaternion) to apply to the current geometry instance.
 * @return the shape instance rotation
 */
vec4 OivInstanceRotation();

/**
 * Get the transformation matrix to apply to the current geometry instance, i.e.,
 * the combination of instance rotation, scale and translation.
 * @return the shape instance transformation matrix.
 */
mat4 OivInstanceMatrix();

/**
 * Get the model matrix without instancing transformations i.e., the model matrix
 * at the SoMultipleInstance node level.
 */
mat4 OivInstancingGlobalModelMatrix();

#endif /* OIV_INSTANCING_H */
