/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef VVIZ_VOLUMEMASK_H
#define VVIZ_VOLUMEMASK_H

uniform int VVizGlobalDataDrawStyleId;

/**
 * This method is used to apply a volume mask to the volume and should be called in a custom fragment shader 
 * in order to support the SoVolumeMask node.
 */
vec4 VVizApplyBoundary(vec4 fragColor, int maskFront, int maskBack, VVizVoxelInfo voxelFront, VVizVoxelInfo voxelBack);
vec4 VVizApplyBoundary(vec4 fragColor, int maskFront, VVizVoxelInfo voxelFront, VVizVoxelInfo voxelBack);

/**
 * This method is used to apply a volume mask to the volume and should be called in a custom fragment shader
 * in order to support the SoVolumeMask node.
 */
vec4 VVizApplyBoundary(in VVizDataSetId dataset, vec4 fragColor, int maskFront, int maskBack, VVizVoxelInfo voxelFront, VVizVoxelInfo voxelBack);
vec4 VVizApplyBoundary(in VVizDataSetId dataset, vec4 fragColor, int maskFront, VVizVoxelInfo voxelFront, VVizVoxelInfo voxelBack);

#endif


