/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef VVIZ_COMPUTE_FRAGMENT_COLOR_FRAG_H
#define VVIZ_COMPUTE_FRAGMENT_COLOR_FRAG_H

/**
 * @ingroup VolumeVizFragmentShaders
 * SoVolumeShader::FRAGMENT_COMPUTE_COLOR function. 
 *
 * Applications can replace this method to customize the SoVolumeShader::FRAGMENT_COMPUTE_COLOR shader stage. @BR
 * Note: This version of the method is only used by the SoVolumeRender node.
 *
 * @param dataset Dataset id
 * @param rayDir ray Direction in the volume space of dataset.
 * @param voxelInfoFront Voxel info of front slice.
 * @param voxelInfoBack Voxel info of back slice
 * @param mask Current mask Id
 */
#if VVIZ_SHAPE_TYPE == VVIZ_VRENDER
vec4 VVizComputeFragmentColor(in VVizDataSetId dataset, in vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, in int mask);
#endif

/**
 * @ingroup VolumeVizFragmentShaders
 * SoVolumeShader::FRAGMENT_COMPUTE_COLOR function. 
 *
 * Applications can replace this method to customize the SoVolumeShader::FRAGMENT_COMPUTE_COLOR shader stage. @BR
 * Note: This version method is used by all VolumeViz shapes @I other than@i SoVolumeRender.
 *
 * @param vox Voxel value 
 * @param dataCoord Position of voxel in the virtual volume space of the default DataSet.
 */
 #if VVIZ_SHAPE_TYPE != VVIZ_VRENDER
vec4 VVizComputeFragmentColor(in VVIZ_DATATYPE vox, in vec3 dataCoord);
#endif

#endif


