/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef VVIZ_VERTEX_SHIFT_TESS_H
#define VVIZ_VERTEX_SHIFT_TESS_H

/**
 * @ingroup VolumeVizTessellationShaders
 * SoVolumeShader::TESS_VERTEX_SHIFT function.
 *
 * This function can be redefined by the application to modify each vertex
 * position during HeightField rendering. It is associated with the
 * SoVolumeShader::TESS_VERTEX_SHIFT shader stage. By default, the input
 * position is returned.
 *
 * The SoVolumeShader::TESS_VERTEX_SHIFT shader stage must be set with an
 * SoTessellationEvaluationShader, but this function will also be called by the
 * tessellation control stage and the fragment stage, so the shader code must
 * only use the GLSL API that is common to those 3 stages.
 *
 * @param position Vertex position on the HeightField surface in model space:
 *                 XY in [-1, 1] and Z is the data set value, normalized for
 *                 integer types (see SoHeightFieldRender).
 * @param texCoord 2D Texture coordinate assiciated with the 3D position.
 * @return The new vertex position in model space.
 */
vec3 VVizTessVertexShift( in vec3 position, in vec2 texCoord );

#endif /* VVIZ_VERTEX_SHIFT_TESS_H */
