package com.openinventor.inventor.viewercomponents.awt;

import java.awt.Component;

import com.openinventor.inventor.nodes.SoNode;

/**
 * Interface for viewers with an examiner area.
 *
 */
public interface IViewerExaminer
{

  /**
   * Gets the parent component of this viewer.
   *
   * @return the parent component
   */
  public Component getComponent();

  /**
   * Sets the scene graph. This is the Open Inventor scene which will be
   * traversed for rendering and event processing.
   *
   * @param sceneGraph
   *          the scene graph
   */
  public void setSceneGraph(SoNode sceneGraph);

  /**
   * Set the camera to view all the scene.
   */
  public void viewAll();

  /**
   * Gets the examiner area.
   *
   * @return the examiner area
   */
  public IRenderAreaExaminer getRenderArea();

  /**
   * Dispose viewer resources.
   */
  public void dispose();

}
