package com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas;

import org.eclipse.swt.widgets.Composite;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.openinventor.inventor.viewercomponents.nodes.SceneOrbiter;

/**
 * <strong>(Preview Feature) </strong>Class to render an OpenInventor scene
 * graph in a SWT GLCanvas.
 * <p style="background-color: #c7c7c7;">
 * Preview Feature means this class is fully supported and can be used in Open
 * Inventor applications. Being tagged as a Preview Feature just means that the
 * implementation is still subject to API changes and adjustments based on
 * feedback from early adopters. Please be also aware that source compatibility
 * might be broken regardless of the Open Inventor compatibility changes policy
 * due to our commitment to bring needed changes to make sure that the specifications
 * of this Preview Feature match the expectations of our customers.
 * </p>
 * This class extends RenderAreaInteractive to add scene orbiter viewer
 * behaviors. Unlike the RenderAreaExaminer, the scene orbiter is a "mode-less"
 * viewer.
 * <p>
 * Note: When using this component, the automatic interactive mode
 * is disabled, see
 * {@link com.openinventor.inventor.SoSceneManager#setAutoInteractiveMode(boolean)}
 * for more details. The interactive mode is managed by the SceneOrbiter node.
 *
 * @see SceneOrbiter
 */
public class RenderAreaOrbiter extends RenderAreaInteractive
{

  private SceneOrbiter m_sceneOrbiter;

  public RenderAreaOrbiter(Composite parent, int style)
  {
    super(parent, style, false);

    init();
  }

  public RenderAreaOrbiter(Composite parent, int style, GLCapabilities caps)
  {
    super(parent, style, false, caps);

    init();
  }

  private void init()
  {
    m_rootSceneGraph = m_sceneOrbiter = new SceneOrbiter();

    buildSceneGraph();
  }

  @Override
  public void init(GLAutoDrawable drawable)
  {
    super.init(drawable);

    // Deactivate auto interactive mode,
    // interactive mode is managed by the SceneOrbiter.
    m_renderAreaCore.getSceneManager().setAutoInteractiveMode(false);
  }

  @Override
  public SceneOrbiter getSceneInteractor()
  {
    return m_sceneOrbiter;
  }

}
