/**
 * Provides some nodes and helper classes specifically created to facilitate
 * implementation of medical applications.
 * <p>
 * The medical utility classes are provided as a jar named
 * com.openinventor.medical.jar that can be used directly in an Open Inventor
 * application. The classes in this jar are documented and supported by Thermo Fisher Scientific.
 * These classes are also provided as source code.
 * <p>
 * The medical utility library provides useful solutions for some specific
 * requirements of Open Inventor-based medical visualization applications.
 * Compared to typical core Open Inventor classes, medical utility library
 * classes may have some limitations. However application developers can use the
 * source code to examine, modify or extend these classes according to the terms
 * below.
 * <p>
 * Thermo Fisher Scientific may implement similar classes in core Open Inventor in the future, but
 * Thermo Fisher Scientific will continue to support the medical utility version of the class.
 * <p>
 * Open Inventor customers may use the provided source code to help debug their
 * Open Inventor-based application's use of the medical utility library.
 * <p>
 * Open Inventor customers may use the source code to create new classes,
 * derived from the library classes, for use in an Open Inventor application.
 * Thermo Fisher Scientific considers such classes to be application code
 * and not supported by Thermo Fisher Scientific.
 * <p>
 * Open Inventor customers may modify the source code to create customized
 * versions of library classes for use in an Open Inventor application. Thermo Fisher Scientific
 * considers such classes to be application code and not supported by Thermo Fisher Scientific.
 *
 */
package com.openinventor.medical.nodes;
