/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.remoteviz.clients.nodes;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbEventArg;
import com.openinventor.inventor.SbEventHandler;
import com.openinventor.inventor.SbVec2s;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.fields.SoMFEnum;
import com.openinventor.inventor.fields.SoMFVec2String;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.fields.SoSFUShort;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.touch.events.SoTouchEvent;
import com.openinventor.remoteviz.clients.internal.JarInitializer;
import com.openinventor.remoteviz.clients.internal.JniInitializer;

public class SoRemoteVizClient
extends SoNode {
    public final SoSFBool connect;
    public final SoSFString ipAddress;
    public final SoSFUShort port;
    public final SoSFString renderAreaName;
    public final SoMFEnum<VideoDecoderType> videoDecoders;
    public final SoMFVec2String connectionParameters;
    public final SoSFEnum<DisplayModes> displayMode;
    public final SbEventHandler<ServiceMessageEventArg> onServiceMessage;
    public final SbEventHandler<MessageEventArg> onReceivedMessage;
    public final SbEventHandler<BinaryMessageEventArg> onReceivedBinaryMessage;
    public final SbEventHandler<RenderAreaSizeEventArg> onRenderAreaResize;
    public final SbEventHandler<FrameEventArg> onReceivedFrame;
    public final SbEventHandler<FrameEventArg> onDecodedFrame;
    public final SbEventHandler<MouseLocationEventArg> onMouseLocationEvent;
    public final SbEventHandler<MouseButtonEventArg> onMouseButtonEvent;
    public final SbEventHandler<MouseWheelEventArg> onMouseWheelEvent;
    public final SbEventHandler<KeyboardEventArg> onKeyboardEvent;
    public final SbEventHandler<TouchEventArg> onTouchEvent;

    private static native boolean isImageStreamingSupportedImpl(long var0);

    private static native boolean isVideoStreamingSupportedImpl(long var0);

    private static native int getStreamingModeImpl(long var0);

    private static native boolean removeOnTouchEventEventHandler(long var0, long var2);

    private static native long addOnTouchEventEventHandler(long var0, OnTouchEventEventHandler var2, String var3);

    private static native boolean removeOnKeyboardEventEventHandler(long var0, long var2);

    private static native long addOnKeyboardEventEventHandler(long var0, OnKeyboardEventEventHandler var2, String var3);

    private static native boolean removeOnMouseWheelEventEventHandler(long var0, long var2);

    private static native void getContainerSizeImpl(long var0, short[] var2);

    private static native void enableSecureConnectionImpl(long var0, String var2, String var3, int var4, String var5);

    private static native int getEnabledSecurityProtocolsImpl(long var0);

    private static native void sendMessageImpl1(long var0, long var2);

    private static native void sendMessageImpl(long var0, String var2);

    private static native boolean isSecureConnectionImpl(long var0);

    private static native void requestRenderAreaSizeImpl(long var0, short[] var2);

    private static native long ctorImpl();

    private static native void getRenderAreaSizeImpl(long var0, short[] var2);

    private static native long addOnMouseWheelEventEventHandler(long var0, OnMouseWheelEventEventHandler var2, String var3);

    private static native long addOnRenderAreaResizeEventHandler(long var0, OnRenderAreaResizeEventHandler var2, String var3);

    private static native boolean removeOnReceivedBinaryMessageEventHandler(long var0, long var2);

    private static native long addOnReceivedBinaryMessageEventHandler(long var0, OnReceivedBinaryMessageEventHandler var2, String var3);

    private static native boolean removeOnReceivedMessageEventHandler(long var0, long var2);

    private static native long addOnReceivedMessageEventHandler(long var0, OnReceivedMessageEventHandler var2, String var3);

    private static native boolean removeOnServiceMessageEventHandler(long var0, long var2);

    private static native long addOnServiceMessageEventHandler(long var0, OnServiceMessageEventHandler var2, String var3);

    private static native int getVideoDecoderImpl(long var0);

    private static native boolean removeOnRenderAreaResizeEventHandler(long var0, long var2);

    private static native boolean removeOnMouseButtonEventEventHandler(long var0, long var2);

    private static native long addOnMouseButtonEventEventHandler(long var0, OnMouseButtonEventEventHandler var2, String var3);

    private static native boolean removeOnMouseLocationEventEventHandler(long var0, long var2);

    private static native long addOnMouseLocationEventEventHandler(long var0, OnMouseLocationEventEventHandler var2, String var3);

    private static native boolean removeOnDecodedFrameEventHandler(long var0, long var2);

    private static native long addOnDecodedFrameEventHandler(long var0, OnDecodedFrameEventHandler var2, String var3);

    private static native boolean removeOnReceivedFrameEventHandler(long var0, long var2);

    private static native long addOnReceivedFrameEventHandler(long var0, OnReceivedFrameEventHandler var2, String var3);

    protected SoRemoteVizClient(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.connect = (SoSFBool)ObjectManager.getManagedObjectFor(SoSFBool.class, (Long)SoRemoteVizClient.getFieldHandle((long)this.getNativeResourceHandle(), (String)"connect"));
        this.ipAddress = (SoSFString)ObjectManager.getManagedObjectFor(SoSFString.class, (Long)SoRemoteVizClient.getFieldHandle((long)this.getNativeResourceHandle(), (String)"ipAddress"));
        this.port = (SoSFUShort)ObjectManager.getManagedObjectFor(SoSFUShort.class, (Long)SoRemoteVizClient.getFieldHandle((long)this.getNativeResourceHandle(), (String)"port"));
        this.renderAreaName = (SoSFString)ObjectManager.getManagedObjectFor(SoSFString.class, (Long)SoRemoteVizClient.getFieldHandle((long)this.getNativeResourceHandle(), (String)"renderAreaName"));
        this.videoDecoders = (SoMFEnum)ObjectManager.getManagedObjectFor(SoMFEnum.class, (Long)SoRemoteVizClient.getFieldHandle((long)this.getNativeResourceHandle(), (String)"videoDecoders"), (Class[])new Class[]{VideoDecoderType.class});
        this.connectionParameters = (SoMFVec2String)ObjectManager.getManagedObjectFor(SoMFVec2String.class, (Long)SoRemoteVizClient.getFieldHandle((long)this.getNativeResourceHandle(), (String)"connectionParameters"));
        this.displayMode = (SoSFEnum)ObjectManager.getManagedObjectFor(SoSFEnum.class, (Long)SoRemoteVizClient.getFieldHandle((long)this.getNativeResourceHandle(), (String)"displayMode"), (Class[])new Class[]{DisplayModes.class});
        this.onServiceMessage = new OnServiceMessageEventHandler();
        this.onReceivedMessage = new OnReceivedMessageEventHandler();
        this.onReceivedBinaryMessage = new OnReceivedBinaryMessageEventHandler();
        this.onRenderAreaResize = new OnRenderAreaResizeEventHandler();
        this.onReceivedFrame = new OnReceivedFrameEventHandler();
        this.onDecodedFrame = new OnDecodedFrameEventHandler();
        this.onMouseLocationEvent = new OnMouseLocationEventEventHandler();
        this.onMouseButtonEvent = new OnMouseButtonEventEventHandler();
        this.onMouseWheelEvent = new OnMouseWheelEventEventHandler();
        this.onKeyboardEvent = new OnKeyboardEventEventHandler();
        this.onTouchEvent = new OnTouchEventEventHandler();
    }

    static native String getClassTypeId();

    public void enableSecureConnection(String string, String string2) {
        this.enableSecureConnection(string, string2, SecurityProtocols.valueOf(SecurityProtocols.TLSv1_1.getValue() | SecurityProtocols.TLSv1_2.getValue() | SecurityProtocols.TLSv1_3.getValue()), "");
    }

    public void enableSecureConnection(String string, String string2, SecurityProtocols securityProtocols) {
        this.enableSecureConnection(string, string2, securityProtocols, "");
    }

    public SoRemoteVizClient() {
        this(Inventor.ConstructorCommand.CreateInstance, SoRemoteVizClient.ctorImpl());
    }

    public void sendMessage(String string) {
        SoRemoteVizClient.sendMessageImpl(this.getNativeResourceHandle(), string);
    }

    public void sendMessage(SoCpuBufferObject soCpuBufferObject) {
        SoRemoteVizClient.sendMessageImpl1(this.getNativeResourceHandle(), soCpuBufferObject != null ? soCpuBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public StreamingModes getStreamingMode() {
        return (StreamingModes)IntegerValuedEnumHelper.fromIntValue(StreamingModes.class, (int)SoRemoteVizClient.getStreamingModeImpl(this.getNativeResourceHandle()));
    }

    public VideoDecoderType getVideoDecoder() {
        return (VideoDecoderType)IntegerValuedEnumHelper.fromIntValue(VideoDecoderType.class, (int)SoRemoteVizClient.getVideoDecoderImpl(this.getNativeResourceHandle()));
    }

    public boolean isVideoStreamingSupported() {
        return SoRemoteVizClient.isVideoStreamingSupportedImpl(this.getNativeResourceHandle());
    }

    public boolean isImageStreamingSupported() {
        return SoRemoteVizClient.isImageStreamingSupportedImpl(this.getNativeResourceHandle());
    }

    public SbVec2s getContainerSize() {
        SbVec2s sbVec2s = new SbVec2s();
        SoRemoteVizClient.getContainerSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        return sbVec2s;
    }

    public SbVec2s getRenderAreaSize() {
        SbVec2s sbVec2s = new SbVec2s();
        SoRemoteVizClient.getRenderAreaSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
        return sbVec2s;
    }

    public void requestRenderAreaSize(SbVec2s sbVec2s) {
        SoRemoteVizClient.requestRenderAreaSizeImpl(this.getNativeResourceHandle(), sbVec2s != null ? sbVec2s.array : null);
    }

    public boolean isSecureConnection() {
        return SoRemoteVizClient.isSecureConnectionImpl(this.getNativeResourceHandle());
    }

    public SecurityProtocols getEnabledSecurityProtocols() {
        return (SecurityProtocols)IntegerValuedEnumHelper.fromIntValue(SecurityProtocols.class, (int)SoRemoteVizClient.getEnabledSecurityProtocolsImpl(this.getNativeResourceHandle()));
    }

    public void enableSecureConnection(String string, String string2, SecurityProtocols securityProtocols, String string3) {
        SoRemoteVizClient.enableSecureConnectionImpl(this.getNativeResourceHandle(), string, string2, securityProtocols.getValue(), string3);
    }

    static {
        JarInitializer.checkInit();
    }

    public static enum VideoDecoderType implements IntegerValuedEnum
    {
        NONE(VideoDecoderType.getNONE()),
        OPENH264(VideoDecoderType.getOPENH264()),
        INTEL_QUICKSYNC(VideoDecoderType.getINTELQUICKSYNC()),
        NVDECODE(VideoDecoderType.getNVDECODE()),
        VPX(VideoDecoderType.getVPX());

        private int value;

        private static native int getNONENative();

        private VideoDecoderType(int n2) {
            this.value = n2;
        }

        private static int getVPX() {
            JniInitializer.checkInit();
            return VideoDecoderType.getVPXNative();
        }

        private static native int getVPXNative();

        private static int getNVDECODE() {
            JniInitializer.checkInit();
            return VideoDecoderType.getNVDECODENative();
        }

        private static native int getNVDECODENative();

        private static int getNONE() {
            JniInitializer.checkInit();
            return VideoDecoderType.getNONENative();
        }

        private static native int getOPENH264Native();

        private static int getOPENH264() {
            JniInitializer.checkInit();
            return VideoDecoderType.getOPENH264Native();
        }

        private static native int getINTELQUICKSYNCNative();

        private static int getINTELQUICKSYNC() {
            JniInitializer.checkInit();
            return VideoDecoderType.getINTELQUICKSYNCNative();
        }

        public int getValue() {
            return this.value;
        }

        public static VideoDecoderType valueOf(int n) {
            return (VideoDecoderType)IntegerValuedEnumHelper.fromIntValue(VideoDecoderType.class, (int)n);
        }
    }

    public static enum DisplayModes implements IntegerValuedEnum
    {
        STRETCH(DisplayModes.getSTRETCH()),
        CROP(DisplayModes.getCROP()),
        FIT(DisplayModes.getFIT());

        private int value;

        private static native int getSTRETCHNative();

        private DisplayModes(int n2) {
            this.value = n2;
        }

        private static int getFIT() {
            JniInitializer.checkInit();
            return DisplayModes.getFITNative();
        }

        private static native int getFITNative();

        private static int getCROP() {
            JniInitializer.checkInit();
            return DisplayModes.getCROPNative();
        }

        private static native int getCROPNative();

        private static int getSTRETCH() {
            JniInitializer.checkInit();
            return DisplayModes.getSTRETCHNative();
        }

        public int getValue() {
            return this.value;
        }

        public static DisplayModes valueOf(int n) {
            return (DisplayModes)IntegerValuedEnumHelper.fromIntValue(DisplayModes.class, (int)n);
        }
    }

    private class OnServiceMessageEventHandler
    extends SbEventHandler<ServiceMessageEventArg> {
        private OnServiceMessageEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = ServiceMessageEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnServiceMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnServiceMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnReceivedMessageEventHandler
    extends SbEventHandler<MessageEventArg> {
        private OnReceivedMessageEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = MessageEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnReceivedMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnReceivedMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnReceivedBinaryMessageEventHandler
    extends SbEventHandler<BinaryMessageEventArg> {
        private OnReceivedBinaryMessageEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = BinaryMessageEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnReceivedBinaryMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnReceivedBinaryMessageEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnRenderAreaResizeEventHandler
    extends SbEventHandler<RenderAreaSizeEventArg> {
        private OnRenderAreaResizeEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = RenderAreaSizeEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnRenderAreaResizeEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnRenderAreaResizeEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnReceivedFrameEventHandler
    extends SbEventHandler<FrameEventArg> {
        private OnReceivedFrameEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = FrameEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnReceivedFrameEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnReceivedFrameEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnDecodedFrameEventHandler
    extends SbEventHandler<FrameEventArg> {
        private OnDecodedFrameEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = FrameEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnDecodedFrameEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnDecodedFrameEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnMouseLocationEventEventHandler
    extends SbEventHandler<MouseLocationEventArg> {
        private OnMouseLocationEventEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = MouseLocationEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnMouseLocationEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnMouseLocationEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnMouseButtonEventEventHandler
    extends SbEventHandler<MouseButtonEventArg> {
        private OnMouseButtonEventEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = MouseButtonEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnMouseButtonEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnMouseButtonEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnMouseWheelEventEventHandler
    extends SbEventHandler<MouseWheelEventArg> {
        private OnMouseWheelEventEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = MouseWheelEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnMouseWheelEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnMouseWheelEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnKeyboardEventEventHandler
    extends SbEventHandler<KeyboardEventArg> {
        private OnKeyboardEventEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = KeyboardEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnKeyboardEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnKeyboardEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    private class OnTouchEventEventHandler
    extends SbEventHandler<TouchEventArg> {
        private OnTouchEventEventHandler() {
        }

        protected void addNativeEventHandler() {
            String string = TouchEventArg.class.getName();
            this.m_nativeEventHandler = SoRemoteVizClient.addOnTouchEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this, string);
        }

        protected void removeNativeEventHandler() {
            boolean bl = SoRemoteVizClient.removeOnTouchEventEventHandler(SoRemoteVizClient.this.getNativeResourceHandle(), this.m_nativeEventHandler);
            assert (bl);
        }
    }

    public static enum SecurityProtocols implements IntegerValuedEnum
    {
        SSLv2(SecurityProtocols.getSSLv2()),
        SSLv3(SecurityProtocols.getSSLv3()),
        TLSv1(SecurityProtocols.getTLSv1()),
        TLSv1_1(SecurityProtocols.getTLSv11()),
        TLSv1_2(SecurityProtocols.getTLSv12()),
        TLSv1_3(SecurityProtocols.getTLSv13());

        private int value;

        private static native int getSSLv2Native();

        private SecurityProtocols(int n2) {
            this.value = n2;
        }

        private static int getTLSv13() {
            JniInitializer.checkInit();
            return SecurityProtocols.getTLSv13Native();
        }

        private static native int getTLSv13Native();

        private static int getTLSv12() {
            JniInitializer.checkInit();
            return SecurityProtocols.getTLSv12Native();
        }

        private static native int getTLSv12Native();

        private static int getTLSv11() {
            JniInitializer.checkInit();
            return SecurityProtocols.getTLSv11Native();
        }

        private static int getSSLv2() {
            JniInitializer.checkInit();
            return SecurityProtocols.getSSLv2Native();
        }

        private static native int getSSLv3Native();

        private static int getSSLv3() {
            JniInitializer.checkInit();
            return SecurityProtocols.getSSLv3Native();
        }

        private static native int getTLSv1Native();

        private static int getTLSv1() {
            JniInitializer.checkInit();
            return SecurityProtocols.getTLSv1Native();
        }

        private static native int getTLSv11Native();

        public int getValue() {
            return this.value;
        }

        public static SecurityProtocols valueOf(int n) {
            return (SecurityProtocols)IntegerValuedEnumHelper.fromIntValue(SecurityProtocols.class, (int)n);
        }
    }

    public static enum StreamingModes implements IntegerValuedEnum
    {
        UNKNOWN(StreamingModes.getUNKNOWN()),
        IMAGE(StreamingModes.getIMAGE()),
        VIDEO(StreamingModes.getVIDEO());

        private int value;

        private static native int getUNKNOWNNative();

        private StreamingModes(int n2) {
            this.value = n2;
        }

        private static int getVIDEO() {
            JniInitializer.checkInit();
            return StreamingModes.getVIDEONative();
        }

        private static native int getVIDEONative();

        private static int getIMAGE() {
            JniInitializer.checkInit();
            return StreamingModes.getIMAGENative();
        }

        private static native int getIMAGENative();

        private static int getUNKNOWN() {
            JniInitializer.checkInit();
            return StreamingModes.getUNKNOWNNative();
        }

        public int getValue() {
            return this.value;
        }

        public static StreamingModes valueOf(int n) {
            return (StreamingModes)IntegerValuedEnumHelper.fromIntValue(StreamingModes.class, (int)n);
        }
    }

    public static class BinaryMessageEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native long getBufferImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected BinaryMessageEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public BinaryMessageEventArg(SoRemoteVizClient soRemoteVizClient, SoCpuBufferObject soCpuBufferObject) {
            this(Inventor.ConstructorCommand.CreateInstance, BinaryMessageEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soCpuBufferObject != null ? soCpuBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)BinaryMessageEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(BinaryMessageEventArg binaryMessageEventArg) {
            BinaryMessageEventArg.setValueImpl(this.getNativeResourceHandle(), binaryMessageEventArg.getNativeResourceHandle());
        }

        public SoCpuBufferObject getBuffer() {
            return (SoCpuBufferObject)ObjectManager.getManagedObjectFor(SoCpuBufferObject.class, (Long)BinaryMessageEventArg.getBufferImpl(this.getNativeResourceHandle()));
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static class FrameEventArg
    extends Inventor
    implements SbEventArg {
        private static native void setValueImpl(long var0, long var2);

        private static native long getIdImpl(long var0);

        private static native long getDataLengthImpl(long var0);

        private static native long getSourceImpl(long var0);

        private static native boolean isLosslessImpl(long var0);

        private static native long ctorImpl(long var0, long var2, long var4, boolean var6, String var7);

        private static native String getMessageImpl(long var0);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected FrameEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public void setValue(FrameEventArg frameEventArg) {
            FrameEventArg.setValueImpl(this.getNativeResourceHandle(), frameEventArg.getNativeResourceHandle());
        }

        public FrameEventArg(SoRemoteVizClient soRemoteVizClient, long l, long l2, boolean bl, String string) {
            this(Inventor.ConstructorCommand.CreateInstance, FrameEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, l, l2, bl, string));
        }

        public String getMessage() {
            return FrameEventArg.getMessageImpl(this.getNativeResourceHandle());
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)FrameEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public boolean isLossless() {
            return FrameEventArg.isLosslessImpl(this.getNativeResourceHandle());
        }

        public long getId() {
            return FrameEventArg.getIdImpl(this.getNativeResourceHandle());
        }

        public long getDataLength() {
            return FrameEventArg.getDataLengthImpl(this.getNativeResourceHandle());
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static class KeyboardEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native long getKeyboardEventImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected KeyboardEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public KeyboardEventArg(SoRemoteVizClient soRemoteVizClient, SoKeyboardEvent soKeyboardEvent) {
            this(Inventor.ConstructorCommand.CreateInstance, KeyboardEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soKeyboardEvent != null ? soKeyboardEvent.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)KeyboardEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(KeyboardEventArg keyboardEventArg) {
            KeyboardEventArg.setValueImpl(this.getNativeResourceHandle(), keyboardEventArg.getNativeResourceHandle());
        }

        public SoKeyboardEvent getKeyboardEvent() {
            return (SoKeyboardEvent)ObjectManager.getManagedObjectFor(SoKeyboardEvent.class, (Long)KeyboardEventArg.getKeyboardEventImpl(this.getNativeResourceHandle()));
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static class MessageEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native String getMessageImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, String var2);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected MessageEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public MessageEventArg(SoRemoteVizClient soRemoteVizClient, String string) {
            this(Inventor.ConstructorCommand.CreateInstance, MessageEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, string));
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)MessageEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(MessageEventArg messageEventArg) {
            MessageEventArg.setValueImpl(this.getNativeResourceHandle(), messageEventArg.getNativeResourceHandle());
        }

        public String getMessage() {
            return MessageEventArg.getMessageImpl(this.getNativeResourceHandle());
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static class MouseButtonEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native long getMouseButtonEventImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected MouseButtonEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public MouseButtonEventArg(SoRemoteVizClient soRemoteVizClient, SoMouseButtonEvent soMouseButtonEvent) {
            this(Inventor.ConstructorCommand.CreateInstance, MouseButtonEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soMouseButtonEvent != null ? soMouseButtonEvent.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)MouseButtonEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(MouseButtonEventArg mouseButtonEventArg) {
            MouseButtonEventArg.setValueImpl(this.getNativeResourceHandle(), mouseButtonEventArg.getNativeResourceHandle());
        }

        public SoMouseButtonEvent getMouseButtonEvent() {
            return (SoMouseButtonEvent)ObjectManager.getManagedObjectFor(SoMouseButtonEvent.class, (Long)MouseButtonEventArg.getMouseButtonEventImpl(this.getNativeResourceHandle()));
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static class MouseLocationEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native long getMouseLocationEventImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected MouseLocationEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public MouseLocationEventArg(SoRemoteVizClient soRemoteVizClient, SoLocation2Event soLocation2Event) {
            this(Inventor.ConstructorCommand.CreateInstance, MouseLocationEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soLocation2Event != null ? soLocation2Event.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)MouseLocationEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(MouseLocationEventArg mouseLocationEventArg) {
            MouseLocationEventArg.setValueImpl(this.getNativeResourceHandle(), mouseLocationEventArg.getNativeResourceHandle());
        }

        public SoLocation2Event getMouseLocationEvent() {
            return (SoLocation2Event)ObjectManager.getManagedObjectFor(SoLocation2Event.class, (Long)MouseLocationEventArg.getMouseLocationEventImpl(this.getNativeResourceHandle()));
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static class MouseWheelEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native long getMouseWheelEventImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected MouseWheelEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public MouseWheelEventArg(SoRemoteVizClient soRemoteVizClient, SoMouseWheelEvent soMouseWheelEvent) {
            this(Inventor.ConstructorCommand.CreateInstance, MouseWheelEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soMouseWheelEvent != null ? soMouseWheelEvent.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)MouseWheelEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(MouseWheelEventArg mouseWheelEventArg) {
            MouseWheelEventArg.setValueImpl(this.getNativeResourceHandle(), mouseWheelEventArg.getNativeResourceHandle());
        }

        public SoMouseWheelEvent getMouseWheelEvent() {
            return (SoMouseWheelEvent)ObjectManager.getManagedObjectFor(SoMouseWheelEvent.class, (Long)MouseWheelEventArg.getMouseWheelEventImpl(this.getNativeResourceHandle()));
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static class RenderAreaSizeEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native void getSizeImpl(long var0, short[] var2);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, short[] var2);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected RenderAreaSizeEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public RenderAreaSizeEventArg(SoRemoteVizClient soRemoteVizClient, SbVec2s sbVec2s) {
            this(Inventor.ConstructorCommand.CreateInstance, RenderAreaSizeEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec2s != null ? sbVec2s.array : null));
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)RenderAreaSizeEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(RenderAreaSizeEventArg renderAreaSizeEventArg) {
            RenderAreaSizeEventArg.setValueImpl(this.getNativeResourceHandle(), renderAreaSizeEventArg.getNativeResourceHandle());
        }

        public SbVec2s getSize() {
            SbVec2s sbVec2s = new SbVec2s();
            RenderAreaSizeEventArg.getSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
            return sbVec2s;
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static class ServiceMessageEventArg
    extends Inventor
    implements SbEventArg {
        private static native int getStateImpl(long var0);

        private static native String getDetailsImpl(long var0);

        private static native void getRenderAreaSizeImpl(long var0, short[] var2);

        private static native void setValueImpl(long var0, long var2);

        private static native long getSourceImpl(long var0);

        private static native long ctorImpl(long var0, int var2, short[] var3, String var4);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected ServiceMessageEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public SbVec2s getRenderAreaSize() {
            SbVec2s sbVec2s = new SbVec2s();
            ServiceMessageEventArg.getRenderAreaSizeImpl(this.getNativeResourceHandle(), sbVec2s.array);
            return sbVec2s;
        }

        public States getState() {
            return (States)IntegerValuedEnumHelper.fromIntValue(States.class, (int)ServiceMessageEventArg.getStateImpl(this.getNativeResourceHandle()));
        }

        public String getDetails() {
            return ServiceMessageEventArg.getDetailsImpl(this.getNativeResourceHandle());
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)ServiceMessageEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(ServiceMessageEventArg serviceMessageEventArg) {
            ServiceMessageEventArg.setValueImpl(this.getNativeResourceHandle(), serviceMessageEventArg.getNativeResourceHandle());
        }

        public ServiceMessageEventArg(SoRemoteVizClient soRemoteVizClient, States states, SbVec2s sbVec2s, String string) {
            this(Inventor.ConstructorCommand.CreateInstance, ServiceMessageEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, states.getValue(), sbVec2s != null ? sbVec2s.array : null, string));
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }

        public static enum States implements IntegerValuedEnum
        {
            CONNECTED(States.getCONNECTED()),
            DISCONNECTED(States.getDISCONNECTED()),
            START_NETWORK_CALIBRATION(States.getSTARTNETWORKCALIBRATION()),
            FINISH_NETWORK_CALIBRATION(States.getFINISHNETWORKCALIBRATION()),
            START_BANDWIDTH_CALIBRATION(States.getSTARTBANDWIDTHCALIBRATION()),
            FINISH_BANDWIDTH_CALIBRATION(States.getFINISHBANDWIDTHCALIBRATION()),
            START_LATENCY_CALIBRATION(States.getSTARTLATENCYCALIBRATION()),
            FINISH_LATENCY_CALIBRATION(States.getFINISHLATENCYCALIBRATION()),
            PENDING_NETWORK_CALIBRATION(States.getPENDINGNETWORKCALIBRATION());

            private int value;

            private static native int getCONNECTEDNative();

            private static int getFINISHBANDWIDTHCALIBRATION() {
                JniInitializer.checkInit();
                return States.getFINISHBANDWIDTHCALIBRATIONNative();
            }

            private static native int getSTARTLATENCYCALIBRATIONNative();

            private static int getSTARTLATENCYCALIBRATION() {
                JniInitializer.checkInit();
                return States.getSTARTLATENCYCALIBRATIONNative();
            }

            private static native int getFINISHLATENCYCALIBRATIONNative();

            private static int getFINISHLATENCYCALIBRATION() {
                JniInitializer.checkInit();
                return States.getFINISHLATENCYCALIBRATIONNative();
            }

            private static native int getPENDINGNETWORKCALIBRATIONNative();

            private static int getPENDINGNETWORKCALIBRATION() {
                JniInitializer.checkInit();
                return States.getPENDINGNETWORKCALIBRATIONNative();
            }

            private States(int n2) {
                this.value = n2;
            }

            private static native int getFINISHBANDWIDTHCALIBRATIONNative();

            private static int getCONNECTED() {
                JniInitializer.checkInit();
                return States.getCONNECTEDNative();
            }

            private static native int getDISCONNECTEDNative();

            private static int getDISCONNECTED() {
                JniInitializer.checkInit();
                return States.getDISCONNECTEDNative();
            }

            private static native int getSTARTNETWORKCALIBRATIONNative();

            private static int getSTARTNETWORKCALIBRATION() {
                JniInitializer.checkInit();
                return States.getSTARTNETWORKCALIBRATIONNative();
            }

            private static native int getFINISHNETWORKCALIBRATIONNative();

            private static int getFINISHNETWORKCALIBRATION() {
                JniInitializer.checkInit();
                return States.getFINISHNETWORKCALIBRATIONNative();
            }

            private static native int getSTARTBANDWIDTHCALIBRATIONNative();

            private static int getSTARTBANDWIDTHCALIBRATION() {
                JniInitializer.checkInit();
                return States.getSTARTBANDWIDTHCALIBRATIONNative();
            }

            public int getValue() {
                return this.value;
            }

            public static States valueOf(int n) {
                return (States)IntegerValuedEnumHelper.fromIntValue(States.class, (int)n);
            }
        }
    }

    public static class TouchEventArg
    extends Inventor
    implements SbEventArg {
        private static native long getSourceImpl(long var0);

        private static native long getTouchEventImpl(long var0);

        private static native void setValueImpl(long var0, long var2);

        private static native long ctorImpl(long var0, long var2);

        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle((Inventor)this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        protected TouchEventArg(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
        }

        public TouchEventArg(SoRemoteVizClient soRemoteVizClient, SoTouchEvent soTouchEvent) {
            this(Inventor.ConstructorCommand.CreateInstance, TouchEventArg.ctorImpl(soRemoteVizClient != null ? soRemoteVizClient.getNativeResourceHandle() : Inventor.ZeroHandle, soTouchEvent != null ? soTouchEvent.getNativeResourceHandle() : Inventor.ZeroHandle));
        }

        public SoRemoteVizClient getSource() {
            return (SoRemoteVizClient)ObjectManager.getManagedObjectFor(SoRemoteVizClient.class, (Long)TouchEventArg.getSourceImpl(this.getNativeResourceHandle()));
        }

        public void setValue(TouchEventArg touchEventArg) {
            TouchEventArg.setValueImpl(this.getNativeResourceHandle(), touchEventArg.getNativeResourceHandle());
        }

        public SoTouchEvent getTouchEvent() {
            return (SoTouchEvent)ObjectManager.getManagedObjectFor(SoTouchEvent.class, (Long)TouchEventArg.getTouchEventImpl(this.getNativeResourceHandle()));
        }

        static {
            JarInitializer.checkInit();
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }
}

