/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestClassPath;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;

public class CreateExecutableDemosJars
extends Task {
    private Vector<FileSet> filesets = new Vector();
    private Vector<FileList> filelists = new Vector();
    private String jarFileName;
    private File inventorPropertyFile;

    public void setJarFileName(String string) {
        this.jarFileName = string;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public File getInventorPropertyFile() {
        return this.inventorPropertyFile;
    }

    public void setInventorPropertyFile(File file) {
        this.inventorPropertyFile = file;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void setFilesets(Vector<FileSet> vector) {
        this.filesets = vector;
    }

    public Vector<FileSet> getFilesets() {
        return this.filesets;
    }

    public void setFilelists(Vector<FileList> vector) {
        this.filelists = vector;
    }

    public Vector<FileList> getFilelists() {
        return this.filelists;
    }

    public void addFilelist(FileList fileList) {
        this.filelists.add(fileList);
    }

    private void validate() {
        if (this.jarFileName == null) {
            this.jarFileName = "main.jar";
        }
        if (this.filesets.size() < 1) {
            throw new BuildException("fileset not sets");
        }
        if (this.filelists.size() < 1) {
            throw new BuildException("jar filelist not set");
        }
    }

    public void execute() throws BuildException {
        this.validate();
        for (FileSet fileSet : this.filesets) {
            String[] stringArray = fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles();
            File file = fileSet.getDir(this.getProject());
            for (int i = 0; i < stringArray.length; ++i) {
                FileList fileList2;
                File file2 = new File(file, stringArray[i]);
                File file3 = new File(file2.getParentFile(), this.jarFileName);
                String string = stringArray[i].substring(0, stringArray[i].indexOf("."));
                string = string.replace(File.separatorChar, '.');
                Path path = new Path(this.getProject());
                Path.PathElement pathElement = path.createPathElement();
                pathElement.setLocation(file);
                Path.PathElement pathElement2 = path.createPathElement();
                pathElement2.setLocation(this.inventorPropertyFile);
                for (FileList fileList2 : this.filelists) {
                    for (FileResource fileResource : fileList2) {
                        Path.PathElement pathElement3 = path.createPathElement();
                        pathElement3.setLocation(fileResource.getFile());
                    }
                }
                String string2 = string + ".jar.classpath";
                fileList2 = new ManifestClassPath();
                fileList2.setProject(this.getProject());
                fileList2.setProperty(string2);
                fileList2.setJarFile(file3);
                fileList2.setMaxParentLevels(8);
                fileList2.addClassPath(path);
                fileList2.execute();
                try {
                    FileResource fileResource;
                    Iterator iterator = new Manifest();
                    iterator.addConfiguredAttribute(new Manifest.Attribute("Main-Class", string));
                    iterator.addConfiguredAttribute(new Manifest.Attribute("Class-Path", this.getProject().getProperty(string2)));
                    fileResource = new Jar();
                    fileResource.setProject(this.getProject());
                    fileResource.setDestFile(file3);
                    fileResource.addConfiguredManifest((Manifest)iterator);
                    fileResource.execute();
                    continue;
                }
                catch (ManifestException manifestException) {
                    throw new BuildException("Unable to configure manifest for " + file3.getAbsolutePath());
                }
            }
        }
    }
}

