/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.swt.GLCanvas;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.devices.SoGLContext;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.viewercomponents.SoRawStereoParameters;
import com.openinventor.inventor.viewercomponents.SoRenderAreaCore;
import com.openinventor.inventor.viewercomponents.SoStereoParameters;
import com.openinventor.inventor.viewercomponents.swt.Timer;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.OptionalStereoGLCapabilitiesChooser;
import org.eclipse.swt.widgets.Composite;

public class RenderArea
extends GLCanvas
implements GLEventListener {
    protected SoRenderAreaCore m_renderAreaCore = null;
    protected SoNode m_sceneGraph = null;
    private SoGLRenderAction m_glRenderAction;
    private SoSceneManager.AntialiasingModes m_antialiasingMode;
    private float m_antialiasingQuality;
    private int m_stillAntialiasingDelay;
    private float m_stillAntialiasingQuality;
    private boolean m_stereo = false;
    private boolean m_customGlRenderAction = false;

    public RenderArea(Composite composite, int n) {
        this(composite, n, null, (GLCapabilitiesChooser)new OptionalStereoGLCapabilitiesChooser());
    }

    public RenderArea(Composite composite, int n, GLCapabilities gLCapabilities) {
        this(composite, n, (GLCapabilitiesImmutable)gLCapabilities, (GLCapabilitiesChooser)new OptionalStereoGLCapabilitiesChooser());
    }

    private RenderArea(Composite composite, int n, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(composite, n, gLCapabilitiesImmutable, gLCapabilitiesChooser);
        SoDB.setSystemTimer((SoSystemTimer)new Timer());
        this.addGLEventListener(this);
        this.m_glRenderAction = null;
        this.m_antialiasingMode = SoSceneManager.AntialiasingModes.NO_ANTIALIASING;
        this.m_antialiasingQuality = 0.0f;
        this.m_stillAntialiasingDelay = 0;
        this.m_stillAntialiasingQuality = 0.0f;
    }

    public void setGLRenderAction(SoGLRenderAction soGLRenderAction) {
        this.m_glRenderAction = soGLRenderAction;
        this.m_customGlRenderAction = true;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setGLRenderAction(soGLRenderAction);
        }
    }

    public SoGLRenderAction getGLRenderAction() {
        if (this.m_renderAreaCore != null) {
            return this.m_renderAreaCore.getGLRenderAction();
        }
        return this.m_glRenderAction;
    }

    public float getAntialiasingQuality() {
        if (this.m_renderAreaCore == null) {
            return this.m_antialiasingQuality;
        }
        return this.m_renderAreaCore.getAntialiasingQuality();
    }

    public void setAntialiasingQuality(float f) {
        this.m_antialiasingQuality = f;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setAntialiasingQuality(f);
        }
    }

    public SoSceneManager.AntialiasingModes getAntialiasingMode() {
        if (this.m_renderAreaCore == null) {
            return this.m_antialiasingMode;
        }
        return this.m_renderAreaCore.getAntialiasingMode();
    }

    public void setAntialiasingMode(SoSceneManager.AntialiasingModes antialiasingModes) {
        this.m_antialiasingMode = antialiasingModes;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setAntialiasingMode(antialiasingModes);
        }
    }

    public float getStillSuperSamplingQuality() {
        if (this.m_renderAreaCore == null) {
            return this.m_antialiasingQuality;
        }
        return this.m_renderAreaCore.getAntialiasingQuality();
    }

    public void setStillSuperSamplingQuality(float f) {
        this.m_stillAntialiasingQuality = f;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setStillSuperSamplingQuality(f);
        }
    }

    public int getStillSuperSamplingDelay() {
        if (this.m_renderAreaCore == null) {
            return this.m_stillAntialiasingDelay;
        }
        return this.m_renderAreaCore.getStillSuperSamplingDelay();
    }

    public void setStillSuperSamplingDelay(int n) {
        this.m_stillAntialiasingDelay = n;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setStillSuperSamplingDelay(n);
        }
    }

    public void activateStereo(boolean bl) {
        this.m_stereo = bl;
        if (this.m_renderAreaCore == null) {
            return;
        }
        if (bl) {
            if (!this.isRawStereoAvailable()) {
                throw new UnsupportedOperationException("Stereo buffers are not enabled");
            }
            SoRawStereoParameters soRawStereoParameters = new SoRawStereoParameters();
            this.m_renderAreaCore.setStereoParameters((SoStereoParameters)soRawStereoParameters);
            this.m_renderAreaCore.activateStereo(true);
        } else {
            this.m_renderAreaCore.activateStereo(false);
        }
    }

    public boolean isRawStereoAvailable() {
        return this.getChosenGLCapabilities().getStereo();
    }

    public void setSceneGraph(SoNode soNode) {
        this.m_sceneGraph = soNode;
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.setSceneGraph(soNode);
        }
    }

    public void scheduleRedraw() {
        if (this.m_renderAreaCore != null) {
            this.m_renderAreaCore.getSceneManager().scheduleRedraw();
        }
    }

    protected void render() {
        this.m_renderAreaCore.render();
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        SoGLContext soGLContext = SoGLContext.getCurrent((boolean)true);
        this.m_renderAreaCore = new SoRenderAreaCore(soGLContext);
        this.m_renderAreaCore.setSceneGraph(this.m_sceneGraph);
        if (this.m_glRenderAction == null) {
            this.m_glRenderAction = this.m_renderAreaCore.getGLRenderAction();
        } else {
            this.m_renderAreaCore.setGLRenderAction(this.m_glRenderAction);
        }
        this.m_renderAreaCore.setAntialiasingMode(this.m_antialiasingMode);
        this.m_renderAreaCore.setAntialiasingQuality(this.m_antialiasingQuality);
        this.m_renderAreaCore.setStillSuperSamplingDelay(this.m_stillAntialiasingDelay);
        this.m_renderAreaCore.setStillSuperSamplingQuality(this.m_stillAntialiasingQuality);
        this.activateStereo(this.m_stereo);
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (!this.m_customGlRenderAction) {
            this.m_glRenderAction = null;
        }
        this.m_renderAreaCore.dispose();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        this.render();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.m_renderAreaCore.setSize(new SbVec2i32(n3, n4));
    }
}

