/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.viewercomponents.SoEventBuilder;
import java.util.Hashtable;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;

public class SWTEventToSoEvent {
    private static Hashtable<Integer, SoKeyboardEvent.Keys> swt2OivKey = null;
    private static SoEventBuilder s_ivEvent = new SoEventBuilder();

    private static SoKeyboardEvent.Keys getKeySym(int n) {
        Object[] objectArray;
        if (swt2OivKey == null) {
            swt2OivKey = new Hashtable();
            objectArray = new Object[]{131072, SoKeyboardEvent.Keys.LEFT_SHIFT, 262144, SoKeyboardEvent.Keys.LEFT_CONTROL, 65536, SoKeyboardEvent.Keys.LEFT_ALT, 48, SoKeyboardEvent.Keys.NUMBER_0, 49, SoKeyboardEvent.Keys.NUMBER_1, 50, SoKeyboardEvent.Keys.NUMBER_2, 51, SoKeyboardEvent.Keys.NUMBER_3, 52, SoKeyboardEvent.Keys.NUMBER_4, 53, SoKeyboardEvent.Keys.NUMBER_5, 54, SoKeyboardEvent.Keys.NUMBER_6, 55, SoKeyboardEvent.Keys.NUMBER_7, 56, SoKeyboardEvent.Keys.NUMBER_8, 57, SoKeyboardEvent.Keys.NUMBER_9, 97, SoKeyboardEvent.Keys.A, 98, SoKeyboardEvent.Keys.B, 99, SoKeyboardEvent.Keys.C, 100, SoKeyboardEvent.Keys.D, 101, SoKeyboardEvent.Keys.E, 102, SoKeyboardEvent.Keys.F, 103, SoKeyboardEvent.Keys.G, 104, SoKeyboardEvent.Keys.H, 105, SoKeyboardEvent.Keys.I, 106, SoKeyboardEvent.Keys.J, 107, SoKeyboardEvent.Keys.K, 108, SoKeyboardEvent.Keys.L, 109, SoKeyboardEvent.Keys.M, 110, SoKeyboardEvent.Keys.N, 111, SoKeyboardEvent.Keys.O, 112, SoKeyboardEvent.Keys.P, 113, SoKeyboardEvent.Keys.Q, 114, SoKeyboardEvent.Keys.R, 115, SoKeyboardEvent.Keys.S, 116, SoKeyboardEvent.Keys.T, 117, SoKeyboardEvent.Keys.U, 118, SoKeyboardEvent.Keys.V, 119, SoKeyboardEvent.Keys.W, 120, SoKeyboardEvent.Keys.X, 121, SoKeyboardEvent.Keys.Y, 122, SoKeyboardEvent.Keys.Z, 0x1000007, SoKeyboardEvent.Keys.HOME, 0x1000003, SoKeyboardEvent.Keys.LEFT_ARROW, 0x1000001, SoKeyboardEvent.Keys.UP_ARROW, 0x1000004, SoKeyboardEvent.Keys.RIGHT_ARROW, 0x1000002, SoKeyboardEvent.Keys.DOWN_ARROW, 0x1000005, SoKeyboardEvent.Keys.PAGE_UP, 0x1000006, SoKeyboardEvent.Keys.PAGE_DOWN, 65365, SoKeyboardEvent.Keys.PRIOR, 0x1000008, SoKeyboardEvent.Keys.END, 0x1000030, SoKeyboardEvent.Keys.PAD_0, 0x1000031, SoKeyboardEvent.Keys.PAD_1, 16777266, SoKeyboardEvent.Keys.PAD_2, 0x1000033, SoKeyboardEvent.Keys.PAD_3, 16777268, SoKeyboardEvent.Keys.PAD_4, 16777269, SoKeyboardEvent.Keys.PAD_5, 16777270, SoKeyboardEvent.Keys.PAD_6, 16777271, SoKeyboardEvent.Keys.PAD_7, 16777272, SoKeyboardEvent.Keys.PAD_8, 16777273, SoKeyboardEvent.Keys.PAD_9, 16777259, SoKeyboardEvent.Keys.PAD_ADD, 16777261, SoKeyboardEvent.Keys.PAD_SUBTRACT, 16777258, SoKeyboardEvent.Keys.PAD_MULTIPLY, 16777263, SoKeyboardEvent.Keys.PAD_DIVIDE, 0x1000050, SoKeyboardEvent.Keys.PAD_ENTER, 0x100000A, SoKeyboardEvent.Keys.F1, 0x100000B, SoKeyboardEvent.Keys.F2, 0x100000C, SoKeyboardEvent.Keys.F3, 0x100000D, SoKeyboardEvent.Keys.F4, 0x100000E, SoKeyboardEvent.Keys.F5, 0x100000F, SoKeyboardEvent.Keys.F6, 0x1000010, SoKeyboardEvent.Keys.F7, 0x1000011, SoKeyboardEvent.Keys.F8, 0x1000012, SoKeyboardEvent.Keys.F9, 0x1000013, SoKeyboardEvent.Keys.F10, 0x1000014, SoKeyboardEvent.Keys.F11, 0x1000015, SoKeyboardEvent.Keys.F12, 8, SoKeyboardEvent.Keys.BACKSPACE, 9, SoKeyboardEvent.Keys.TAB, 13, SoKeyboardEvent.Keys.ENTER, 0x1000055, SoKeyboardEvent.Keys.PAUSE, 16777300, SoKeyboardEvent.Keys.SCROLL_LOCK, 27, SoKeyboardEvent.Keys.ESCAPE, 127, SoKeyboardEvent.Keys.KEY_DELETE, 16777303, SoKeyboardEvent.Keys.PRINT, 0x1000009, SoKeyboardEvent.Keys.INSERT, 16777299, SoKeyboardEvent.Keys.NUM_LOCK, 16777298, SoKeyboardEvent.Keys.CAPS_LOCK, 32, SoKeyboardEvent.Keys.SPACE, 39, SoKeyboardEvent.Keys.APOSTROPHE, 44, SoKeyboardEvent.Keys.COMMA, 46, SoKeyboardEvent.Keys.PERIOD, 47, SoKeyboardEvent.Keys.SLASH, 59, SoKeyboardEvent.Keys.SEMICOLON, 61, SoKeyboardEvent.Keys.EQUAL, 91, SoKeyboardEvent.Keys.BRACKETLEFT, 92, SoKeyboardEvent.Keys.BACKSLASH, 93, SoKeyboardEvent.Keys.BRACKETRIGHT, 96, SoKeyboardEvent.Keys.GRAVE};
            for (int i = 0; i < objectArray.length; i += 2) {
                swt2OivKey.put((Integer)objectArray[i], (SoKeyboardEvent.Keys)objectArray[i + 1]);
            }
        }
        if ((objectArray = swt2OivKey.get(n)) == null) {
            return SoKeyboardEvent.Keys.ANY;
        }
        return objectArray;
    }

    public static SoMouseButtonEvent getMousePressEvent(MouseEvent mouseEvent, Composite composite) {
        SoMouseButtonEvent.Buttons buttons = SWTEventToSoEvent.getButtonId(mouseEvent);
        int n = composite.getSize().y - 1 - mouseEvent.y;
        return s_ivEvent.getMousePressEvent(mouseEvent.x, n, buttons, SWTEventToSoEvent.isAltDown(mouseEvent), SWTEventToSoEvent.isCtrlDown(mouseEvent), SWTEventToSoEvent.isShiftDown(mouseEvent));
    }

    public static SoMouseButtonEvent getMouseReleaseEvent(MouseEvent mouseEvent, Composite composite) {
        SoMouseButtonEvent.Buttons buttons = SWTEventToSoEvent.getButtonId(mouseEvent);
        int n = composite.getSize().y - 1 - mouseEvent.y;
        return s_ivEvent.getMouseReleaseEvent(mouseEvent.x, n, buttons, SWTEventToSoEvent.isAltDown(mouseEvent), SWTEventToSoEvent.isCtrlDown(mouseEvent), SWTEventToSoEvent.isShiftDown(mouseEvent));
    }

    public static SoMouseButtonEvent getMouseDoubleClickEvent(MouseEvent mouseEvent, Composite composite) {
        SoMouseButtonEvent.Buttons buttons = SWTEventToSoEvent.getButtonId(mouseEvent);
        int n = composite.getSize().y - 1 - mouseEvent.y;
        return s_ivEvent.getMouseDoubleClickEvent(mouseEvent.x, n, buttons, SWTEventToSoEvent.isAltDown(mouseEvent), SWTEventToSoEvent.isCtrlDown(mouseEvent), SWTEventToSoEvent.isShiftDown(mouseEvent));
    }

    public static SoMouseWheelEvent getMouseWheelEvent(MouseEvent mouseEvent, Composite composite) {
        int n = mouseEvent.count;
        int n2 = n * SoPreferences.getInteger((String)"OIV_WHEEL_DELTA", (int)120);
        return s_ivEvent.getMouseWheelEvent(n2, SWTEventToSoEvent.isAltDown(mouseEvent), SWTEventToSoEvent.isCtrlDown(mouseEvent), SWTEventToSoEvent.isShiftDown(mouseEvent));
    }

    public static SoLocation2Event getMouseMoveEvent(MouseEvent mouseEvent, Composite composite) {
        int n = composite.getSize().y - 1 - mouseEvent.y;
        return s_ivEvent.getMouseMoveEvent(mouseEvent.x, n, SWTEventToSoEvent.isAltDown(mouseEvent), SWTEventToSoEvent.isCtrlDown(mouseEvent), SWTEventToSoEvent.isShiftDown(mouseEvent));
    }

    public static SoLocation2Event getMouseEnterEvent(MouseEvent mouseEvent, Composite composite) {
        int n = composite.getSize().y - 1 - mouseEvent.y;
        return s_ivEvent.getMouseEnterEvent(mouseEvent.x, n, SWTEventToSoEvent.isAltDown(mouseEvent), SWTEventToSoEvent.isCtrlDown(mouseEvent), SWTEventToSoEvent.isShiftDown(mouseEvent));
    }

    public static SoLocation2Event getMouseLeaveEvent(MouseEvent mouseEvent, Composite composite) {
        int n = composite.getSize().y - 1 - mouseEvent.y;
        return s_ivEvent.getMouseLeaveEvent(mouseEvent.x, n, SWTEventToSoEvent.isAltDown(mouseEvent), SWTEventToSoEvent.isCtrlDown(mouseEvent), SWTEventToSoEvent.isShiftDown(mouseEvent));
    }

    private static SoMouseButtonEvent.Buttons getButtonId(MouseEvent mouseEvent) {
        return switch (mouseEvent.button) {
            case 1 -> SoMouseButtonEvent.Buttons.BUTTON1;
            case 2 -> SoMouseButtonEvent.Buttons.BUTTON2;
            case 3 -> SoMouseButtonEvent.Buttons.BUTTON3;
            default -> SoMouseButtonEvent.Buttons.ANY;
        };
    }

    private static boolean isAltDown(MouseEvent mouseEvent) {
        return (mouseEvent.stateMask & 0x10000) != 0;
    }

    private static boolean isShiftDown(MouseEvent mouseEvent) {
        return (mouseEvent.stateMask & 0x20000) != 0;
    }

    private static boolean isCtrlDown(MouseEvent mouseEvent) {
        return (mouseEvent.stateMask & 0x40000) != 0;
    }

    public static SoKeyboardEvent getKeyPressEvent(KeyEvent keyEvent, Composite composite) {
        SoKeyboardEvent.Keys keys = SWTEventToSoEvent.getKeySym(keyEvent.keyCode);
        return s_ivEvent.getKeyPressEvent(keys, SWTEventToSoEvent.isAltDown(keyEvent), SWTEventToSoEvent.isCtrlDown(keyEvent), SWTEventToSoEvent.isShiftDown(keyEvent));
    }

    public static SoKeyboardEvent getKeyReleaseEvent(KeyEvent keyEvent, Composite composite) {
        SoKeyboardEvent.Keys keys = SWTEventToSoEvent.getKeySym(keyEvent.keyCode);
        return s_ivEvent.getKeyReleaseEvent(keys, SWTEventToSoEvent.isAltDown(keyEvent), SWTEventToSoEvent.isCtrlDown(keyEvent), SWTEventToSoEvent.isShiftDown(keyEvent));
    }

    private static boolean isAltDown(KeyEvent keyEvent) {
        return (keyEvent.stateMask & 0x10000) != 0;
    }

    private static boolean isShiftDown(KeyEvent keyEvent) {
        return (keyEvent.stateMask & 0x20000) != 0;
    }

    private static boolean isCtrlDown(KeyEvent keyEvent) {
        return (keyEvent.stateMask & 0x40000) != 0;
    }
}

