/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.swt.tools;

import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.RenderAreaInteractive;
import com.openinventor.inventor.viewercomponents.swt.tools.SWTResourceManager;
import java.text.DecimalFormat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class PreferencesDialog
extends Dialog {
    private static PreferencesDialog m_instance = null;
    private Shell shell;
    private StereoListener stereoListener;
    private GeneralPreferencesListener generalPreferencesListener;
    private Button btnActivateRawStereo;
    private Button balanceCheckBox;
    private Slider balanceSlider;
    private Label balanceValueLabel;
    private Button offsetCheckBox;
    private Slider offsetSlider;
    private Label offsetValueLabel;
    private Button orbitButton;
    private Button planeButton;
    private Label clippingModeLabel;
    private Combo clippingPlanesCombo;
    private Label lblNavigationMode;

    private PreferencesDialog(Shell shell) {
        super(shell, 0);
        this.setText("Preferences");
        this.stereoListener = null;
        this.generalPreferencesListener = null;
        this.createContents();
    }

    public static PreferencesDialog getInstance(Shell shell) {
        if (m_instance == null) {
            m_instance = new PreferencesDialog(shell);
        }
        return m_instance;
    }

    public void setStereoListener(StereoListener stereoListener) {
        this.stereoListener = stereoListener;
    }

    public StereoListener getStereoListener() {
        return this.stereoListener;
    }

    public void setGeneralPreferencesListener(GeneralPreferencesListener generalPreferencesListener) {
        this.generalPreferencesListener = generalPreferencesListener;
    }

    public GeneralPreferencesListener getGeneralPreferencesListener() {
        return this.generalPreferencesListener;
    }

    public void enableStereoPreferences(boolean bl) {
        if (!bl && this.btnActivateRawStereo.getSelection()) {
            if (this.stereoListener != null) {
                this.stereoListener.activateRawStereo(false);
            }
            this.btnActivateRawStereo.setSelection(false);
        }
        this.btnActivateRawStereo.setEnabled(bl);
        this.balanceCheckBox.setEnabled(bl);
        this.balanceSlider.setEnabled(bl);
        this.balanceValueLabel.setEnabled(bl);
        this.offsetCheckBox.setEnabled(bl);
        this.offsetSlider.setEnabled(bl);
        this.offsetValueLabel.setEnabled(bl);
    }

    public void setNavigationMode(SceneExaminer.NavigationMode navigationMode) {
        switch (navigationMode) {
            case ORBIT: {
                this.orbitButton.setSelection(true);
                break;
            }
            case PLANE: {
                this.planeButton.setSelection(true);
                break;
            }
        }
    }

    public void setClippingPlanesAdjustMode(RenderAreaInteractive.ClippingPlanesAdjustMode clippingPlanesAdjustMode) {
        this.clippingPlanesCombo.select(clippingPlanesAdjustMode.ordinal());
    }

    public void open() {
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), 1264);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                PreferencesDialog.this.shell.setVisible(false);
                event.doit = false;
            }
        });
        this.shell.setImage(SWTResourceManager.getImage(PreferencesDialog.class, "/com/openinventor/inventor/viewercomponents/icons/preferencesMenu.png"));
        this.shell.setSize(450, 200);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("General");
        Composite composite = new Composite((Composite)tabFolder, 0);
        tabItem.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.lblNavigationMode = new Label(composite, 0);
        this.lblNavigationMode.setText("Navigation mode");
        this.orbitButton = new Button(composite, 16);
        this.orbitButton.setText("Orbit");
        this.orbitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreferencesDialog.this.generalPreferencesListener != null && PreferencesDialog.this.orbitButton.getSelection()) {
                    PreferencesDialog.this.generalPreferencesListener.navigationModeChanged(SceneExaminer.NavigationMode.ORBIT);
                }
            }
        });
        this.planeButton = new Button(composite, 16);
        this.planeButton.setText("Plane");
        this.planeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreferencesDialog.this.generalPreferencesListener != null && PreferencesDialog.this.planeButton.getSelection()) {
                    PreferencesDialog.this.generalPreferencesListener.navigationModeChanged(SceneExaminer.NavigationMode.PLANE);
                }
            }
        });
        this.clippingModeLabel = new Label(composite, 32);
        this.clippingModeLabel.setText("Clipping planes mode");
        RenderAreaInteractive.ClippingPlanesAdjustMode[] clippingPlanesAdjustModeArray = RenderAreaInteractive.ClippingPlanesAdjustMode.values();
        String[] stringArray = new String[clippingPlanesAdjustModeArray.length];
        for (int i = 0; i < clippingPlanesAdjustModeArray.length; ++i) {
            stringArray[i] = clippingPlanesAdjustModeArray[i].toString();
        }
        this.clippingPlanesCombo = new Combo(composite, 8);
        this.clippingPlanesCombo.setItems(stringArray);
        this.clippingPlanesCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.clippingPlanesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreferencesDialog.this.generalPreferencesListener != null) {
                    PreferencesDialog.this.generalPreferencesListener.clippingModeChanged(RenderAreaInteractive.ClippingPlanesAdjustMode.valueOf(PreferencesDialog.this.clippingPlanesCombo.getText()));
                }
            }
        });
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setImage(SWTResourceManager.getImage(PreferencesDialog.class, "/com/openinventor/inventor/viewercomponents/icons/ViewerStereo24.png"));
        tabItem2.setText("Stereo");
        Composite composite2 = new Composite((Composite)tabFolder, 0);
        tabItem2.setControl((Control)composite2);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.btnActivateRawStereo = new Button(composite2, 32);
        this.btnActivateRawStereo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreferencesDialog.this.stereoListener != null) {
                    PreferencesDialog.this.stereoListener.activateRawStereo(PreferencesDialog.this.btnActivateRawStereo.getSelection());
                }
            }
        });
        this.btnActivateRawStereo.setText("Activate raw stereo");
        Group group = new Group(composite2, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group.setText("Stereo Adjustment");
        group.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label((Composite)group, 0);
        label.setText("Zero Parallax Balance:");
        this.balanceCheckBox = new Button((Composite)group, 32);
        float f = 1.0f;
        this.balanceSlider = new Slider((Composite)group, 0);
        this.balanceSlider.setMinimum(-300);
        this.balanceSlider.setMaximum(300);
        this.balanceSlider.setSelection((int)f * 100);
        this.balanceSlider.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.balanceValueLabel = new Label((Composite)group, 2048);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gridData.widthHint = 30;
        this.balanceValueLabel.setLayoutData((Object)gridData);
        this.balanceValueLabel.setText(DecimalFormat.getInstance().format(f));
        this.balanceSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreferencesDialog.this.balanceCheckBox.getSelection() || selectionEvent.detail != 1) {
                    float f = PreferencesDialog.this.balanceSlider.getSelection();
                    PreferencesDialog.this.balanceValueLabel.setText(DecimalFormat.getInstance().format(f /= 100.0f));
                    if (PreferencesDialog.this.stereoListener != null) {
                        PreferencesDialog.this.stereoListener.balanceValueChanged(f);
                    }
                }
            }
        });
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Camera Offset:");
        this.offsetCheckBox = new Button((Composite)group, 32);
        float f2 = 0.7f;
        this.offsetSlider = new Slider((Composite)group, 0);
        this.offsetSlider.setMinimum(0);
        this.offsetSlider.setMaximum(200);
        this.offsetSlider.setSelection((int)f2 * 100);
        this.offsetSlider.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.offsetValueLabel = new Label((Composite)group, 2048);
        GridData gridData2 = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        gridData2.widthHint = 30;
        this.offsetValueLabel.setLayoutData((Object)gridData2);
        this.offsetValueLabel.setText(DecimalFormat.getInstance().format(f2));
        this.offsetSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (PreferencesDialog.this.offsetCheckBox.getSelection() || selectionEvent.detail != 1) {
                    float f = PreferencesDialog.this.offsetSlider.getSelection();
                    PreferencesDialog.this.offsetValueLabel.setText(DecimalFormat.getInstance().format(f /= 100.0f));
                    if (PreferencesDialog.this.stereoListener != null) {
                        PreferencesDialog.this.stereoListener.offsetValueChanged(f);
                    }
                }
            }
        });
    }

    public static interface StereoListener {
        public void activateRawStereo(boolean var1);

        public void balanceValueChanged(float var1);

        public void offsetValueChanged(float var1);
    }

    public static interface GeneralPreferencesListener {
        public void navigationModeChanged(SceneExaminer.NavigationMode var1);

        public void clippingModeChanged(RenderAreaInteractive.ClippingPlanesAdjustMode var1);
    }
}

