/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.medical.nodes;

import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoDB;
import com.openinventor.inventor.SoInput;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.elements.SoViewingMatrixElement;
import com.openinventor.inventor.elements.SoViewportRegionElement;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFInt32;
import com.openinventor.inventor.fields.SoSFVec2i32;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoBBox;
import com.openinventor.inventor.nodes.SoCallback;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoScale;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;

public class Gnomon
extends SoAnnotation {
    public SoSFBool isDisplayed = new SoSFBool((SoFieldContainer)this, "isDisplayed", SoField.FieldTypes.EXPOSED_FIELD, true);
    public SoSFVec2i32 position = new SoSFVec2i32((SoFieldContainer)this, "position", SoField.FieldTypes.EXPOSED_FIELD, new SbVec2i32(0, 0));
    public SoSFInt32 width = new SoSFInt32((SoFieldContainer)this, "width", SoField.FieldTypes.EXPOSED_FIELD, 100);
    public SoSFInt32 height = new SoSFInt32((SoFieldContainer)this, "height", SoField.FieldTypes.EXPOSED_FIELD, 100);
    public SoSFFloat cameraDistance = new SoSFFloat((SoFieldContainer)this, "cameraDistance", SoField.FieldTypes.EXPOSED_FIELD, 3.5f);
    protected SoCallback _callback;
    protected SoOrthographicCamera _camera;
    protected SoSwitch _displaySwitch;
    protected SoScale _gnomonScale;
    protected SoSeparator _geometry;
    final String gnomonGeometry = "#Inventor V2.1 ascii\nDEF GnomonGeom Separator { \n  DepthBuffer { test TRUE write TRUE } \n  PickStyle { style UNPICKABLE } \n  DrawStyle { style FILLED } \n  LightModel { model PHONG } \n  MaterialBinding { value OVERALL } \n  Complexity { value .2 } \n  ShapeHints { vertexOrdering COUNTERCLOCKWISE shapeType SOLID } \n  RotationXYZ { axis X angle 1.570796327 } \n  Separator { \n    Cube { \n      width 1 \n      height 1 \n      depth 1 \n    } \n    DrawStyle { \n      style LINES \n    } \n    Material { \n    } \n    Cube { \n      width 1.01 \n      height 1.01 \n      depth 1.01 \n    } \n  } \n  Font { \n    name arial \n  } \n  Separator { \n    Transform { \n      translation 0 -0.4 0.6 \n      rotation 0 0 1  0  \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0 0 1 \n    } \n    Text3 { \n      parts ALL \n      string A \n      justification CENTER \n    } \n  } \n  Separator { \n    Transform { \n      translation -0.6 -0.4 0 \n      rotation 0 -1 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 1 0 0 \n    } \n    Material { \n      diffuseColor 0 1 0 \n    } \n    Text3 { \n      string R \n      parts ALL \n      justification CENTER \n    } \n  } \n  Separator { \n    Transform { \n      translation 0.6 -0.4 0 \n      rotation 0 1 0 1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 1 0  0 \n    } \n    Material { \n      diffuseColor 1 0 0 \n    } \n    Text3 { \n      justification CENTER \n      parts ALL \n      string L \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 -0.4 -0.6 \n      rotation 0 1 0  3.14 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0 0 1 \n    } \n    Text3 { \n      string P \n      justification CENTER \n      parts ALL \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 0.6 0.35 \n      rotation -1 0 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 1 1 1 \n    } \n    Text3 { \n      justification CENTER \n      parts ALL \n      string H \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 -0.6 -0.35 \n      rotation 1 0 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0.5 0.5 0.5 \n    } \n    Text3 { \n      string F \n      justification CENTER \n      parts ALL \n    } \n  } \n} ";

    public Gnomon() {
        this.setName("Gnomon");
        this._displaySwitch = new SoSwitch();
        this._displaySwitch.whichChild.setValue(-1);
        this._callback = new SoCallback();
        this._callback.setCallback((SoCallback.CB)new GnomonRenderCB());
        this._camera = new SoOrthographicCamera();
        this._camera.position.setValue(new SbVec3f(0.0f, 0.0f, this.cameraDistance.getValue()));
        this._camera.nearDistance.setValue(1.0f);
        this._camera.farDistance.setValue(6.0f);
        this._camera.focalDistance.setValue(this.cameraDistance.getValue());
        this._geometry = new SoSeparator();
        this.buildSceneGraph();
    }

    public SoNode.RenderModes getRenderEngineMode() {
        return SoNode.RenderModes.OIV_OPENINVENTOR_RENDERING;
    }

    public void setScale(SbVec3f sbVec3f) {
        this._gnomonScale.scaleFactor.setValue(sbVec3f);
    }

    public void setGeometry(SoNode soNode) {
        if (soNode == null) {
            return;
        }
        this._geometry.removeAllChildren();
        this._geometry.addChild(soNode);
    }

    protected void buildSceneGraph() {
        SoBBox soBBox = new SoBBox();
        soBBox.mode.setValue((Enum)SoBBox.Modes.NO_BOUNDING_BOX);
        this.addChild((SoNode)soBBox);
        this.addChild((SoNode)this._displaySwitch);
        this._displaySwitch.addChild((SoNode)this._callback);
        this._displaySwitch.addChild((SoNode)this._camera);
        this._gnomonScale = new SoScale();
        this._displaySwitch.addChild((SoNode)this._gnomonScale);
        this._displaySwitch.addChild((SoNode)this._geometry);
        SoInput soInput = new SoInput();
        soInput.setBuffer("#Inventor V2.1 ascii\nDEF GnomonGeom Separator { \n  DepthBuffer { test TRUE write TRUE } \n  PickStyle { style UNPICKABLE } \n  DrawStyle { style FILLED } \n  LightModel { model PHONG } \n  MaterialBinding { value OVERALL } \n  Complexity { value .2 } \n  ShapeHints { vertexOrdering COUNTERCLOCKWISE shapeType SOLID } \n  RotationXYZ { axis X angle 1.570796327 } \n  Separator { \n    Cube { \n      width 1 \n      height 1 \n      depth 1 \n    } \n    DrawStyle { \n      style LINES \n    } \n    Material { \n    } \n    Cube { \n      width 1.01 \n      height 1.01 \n      depth 1.01 \n    } \n  } \n  Font { \n    name arial \n  } \n  Separator { \n    Transform { \n      translation 0 -0.4 0.6 \n      rotation 0 0 1  0  \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0 0 1 \n    } \n    Text3 { \n      parts ALL \n      string A \n      justification CENTER \n    } \n  } \n  Separator { \n    Transform { \n      translation -0.6 -0.4 0 \n      rotation 0 -1 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 1 0 0 \n    } \n    Material { \n      diffuseColor 0 1 0 \n    } \n    Text3 { \n      string R \n      parts ALL \n      justification CENTER \n    } \n  } \n  Separator { \n    Transform { \n      translation 0.6 -0.4 0 \n      rotation 0 1 0 1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 1 0  0 \n    } \n    Material { \n      diffuseColor 1 0 0 \n    } \n    Text3 { \n      justification CENTER \n      parts ALL \n      string L \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 -0.4 -0.6 \n      rotation 0 1 0  3.14 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0 0 1 \n    } \n    Text3 { \n      string P \n      justification CENTER \n      parts ALL \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 0.6 0.35 \n      rotation -1 0 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 1 1 1 \n    } \n    Text3 { \n      justification CENTER \n      parts ALL \n      string H \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 -0.6 -0.35 \n      rotation 1 0 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0.5 0.5 0.5 \n    } \n    Text3 { \n      string F \n      justification CENTER \n      parts ALL \n    } \n  } \n} ", "#Inventor V2.1 ascii\nDEF GnomonGeom Separator { \n  DepthBuffer { test TRUE write TRUE } \n  PickStyle { style UNPICKABLE } \n  DrawStyle { style FILLED } \n  LightModel { model PHONG } \n  MaterialBinding { value OVERALL } \n  Complexity { value .2 } \n  ShapeHints { vertexOrdering COUNTERCLOCKWISE shapeType SOLID } \n  RotationXYZ { axis X angle 1.570796327 } \n  Separator { \n    Cube { \n      width 1 \n      height 1 \n      depth 1 \n    } \n    DrawStyle { \n      style LINES \n    } \n    Material { \n    } \n    Cube { \n      width 1.01 \n      height 1.01 \n      depth 1.01 \n    } \n  } \n  Font { \n    name arial \n  } \n  Separator { \n    Transform { \n      translation 0 -0.4 0.6 \n      rotation 0 0 1  0  \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0 0 1 \n    } \n    Text3 { \n      parts ALL \n      string A \n      justification CENTER \n    } \n  } \n  Separator { \n    Transform { \n      translation -0.6 -0.4 0 \n      rotation 0 -1 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 1 0 0 \n    } \n    Material { \n      diffuseColor 0 1 0 \n    } \n    Text3 { \n      string R \n      parts ALL \n      justification CENTER \n    } \n  } \n  Separator { \n    Transform { \n      translation 0.6 -0.4 0 \n      rotation 0 1 0 1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 1 0  0 \n    } \n    Material { \n      diffuseColor 1 0 0 \n    } \n    Text3 { \n      justification CENTER \n      parts ALL \n      string L \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 -0.4 -0.6 \n      rotation 0 1 0  3.14 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0 0 1 \n    } \n    Text3 { \n      string P \n      justification CENTER \n      parts ALL \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 0.6 0.35 \n      rotation -1 0 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 1 1 1 \n    } \n    Text3 { \n      justification CENTER \n      parts ALL \n      string H \n    } \n  } \n  Separator { \n    Transform { \n      translation 0 -0.6 -0.35 \n      rotation 1 0 0  1.55 \n      scaleFactor 0.1 0.1 0.1 \n      scaleOrientation 0 0 1  0 \n    } \n    Material { \n      diffuseColor 0.5 0.5 0.5 \n    } \n    Text3 { \n      string F \n      justification CENTER \n      parts ALL \n    } \n  } \n} ".length());
        SoNode soNode = SoDB.read((SoInput)soInput);
        if (soNode != null) {
            this._geometry.addChild(soNode);
            this._displaySwitch.whichChild.setValue(-3);
        }
    }

    private class GnomonRenderCB
    implements SoCallback.CB {
        private GnomonRenderCB() {
        }

        public void invoke(SoAction soAction) {
            if (soAction instanceof SoGLRenderAction) {
                SoState soState = soAction.getState();
                ((SoGLRenderAction)soAction).shouldAutoCache(SoGLRenderAction.AutoCacheModes.DONT_AUTO_CACHE);
                SbViewportRegion sbViewportRegion = SoViewportRegionElement.get((SoState)soState);
                SbVec2i32 sbVec2i32 = sbViewportRegion.getViewportOriginPixelsi32();
                float f = sbViewportRegion.getPixelsPerPoint();
                SbViewportRegion sbViewportRegion2 = new SbViewportRegion(new SbVec2i32(Gnomon.this.width.getValue(), Gnomon.this.height.getValue()));
                SbVec2i32 sbVec2i322 = Gnomon.this.position.getValue().times((double)f).plus(sbVec2i32);
                SbVec2i32 sbVec2i323 = new SbVec2i32((int)((float)Gnomon.this.width.getValue() * f), (int)((float)Gnomon.this.height.getValue() * f));
                sbViewportRegion2.setViewportPixels(sbVec2i322, sbVec2i323);
                SoViewportRegionElement.set((SoState)soState, (SbViewportRegion)sbViewportRegion2);
                SbMatrix sbMatrix = SoViewingMatrixElement.get((SoState)soState);
                SbRotation sbRotation = sbMatrix.inverse().decompose().rotation;
                Gnomon.this._camera.enableNotify(false);
                Gnomon.this._camera.orientation.setValue(sbRotation);
                float f2 = Gnomon.this._camera.focalDistance.getValue();
                SbMatrix sbMatrix2 = sbRotation.getMatrix();
                SbVec3f sbVec3f = new SbVec3f(-sbMatrix2.getColumn(2)[0], -sbMatrix2.getColumn(2)[1], -sbMatrix2.getColumn(2)[2]);
                sbVec3f.multiply(f2);
                Gnomon.this._camera.position.setValue(new SbVec3f(0.0f, 0.0f, 0.0f).minus(sbVec3f));
                Gnomon.this._camera.enableNotify(false);
            }
        }
    }
}

