/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.medical.nodes;

import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbColorRGBA;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoCone;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoLineSet;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.nodes.SoText2;
import com.openinventor.inventor.nodes.SoTextProperty;
import com.openinventor.inventor.nodes.SoTransform;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.inventor.sensors.SoNodeSensor;
import com.openinventor.volumeviz.details.SoOrthoSliceDetail;

public class Ruler
extends SoNode {
    public SoSFFloat globalFactor = new SoSFFloat((SoFieldContainer)this, "globalFactor", SoField.FieldTypes.EXPOSED_FIELD, 1.0f);
    public SoSFString label = new SoSFString((SoFieldContainer)this, "label", SoField.FieldTypes.EXPOSED_FIELD, "mm");
    private static SbVec3f initPos;
    private SoCone _leftCone;
    private SoCone _rightCone;
    private SoFont _annotationFont;
    private SoDrawStyle _dStyle;
    private SoLineSet _ruler;
    private SoText2 _rulerAnnotation;
    private SoTransform _leftConeTransform;
    private SoTransform _rightConeTransform;
    private SoTransform _annotationTransform;
    private SoTranslation _initialLeftTranslation;
    private SoTranslation _initialRightTranslation;
    private SoVertexProperty _rulerVertexProp;
    private SoSeparator _root;
    private SoFieldSensor _labelFieldSensor;
    private SoFieldSensor _globalFactorFieldSensor;
    private SoNodeSensor _internalRootSensor;

    public void doAction(SoAction soAction) {
        soAction.forwardTraversal((SoNode)this._root);
    }

    public void GLRender(SoGLRenderAction soGLRenderAction) {
        this.doAction((SoAction)soGLRenderAction);
    }

    public void getBoundingBox(SoGetBoundingBoxAction soGetBoundingBoxAction) {
        this.doAction((SoAction)soGetBoundingBoxAction);
    }

    public void manageMouseMove(boolean bl, SoOrthoSliceDetail soOrthoSliceDetail) {
        SbVec3f sbVec3f = soOrthoSliceDetail != null ? soOrthoSliceDetail.getValueObjectPos() : initPos;
        this._root.enableNotify(false);
        if (bl) {
            initPos = sbVec3f;
            this._rulerVertexProp.vertex.set1Value(0, initPos);
            this._leftConeTransform.translation.setValue(initPos);
            this._dStyle.style.setValue((Enum)SoDrawStyle.Styles.INVISIBLE);
            this._ruler.numVertices.setValue(1);
        } else {
            this._rulerVertexProp.vertex.set1Value(1, sbVec3f);
            this._rightConeTransform.translation.setValue(sbVec3f);
            this._ruler.numVertices.setValue(2);
            this._dStyle.style.setValue((Enum)SoDrawStyle.Styles.FILLED);
        }
        SbVec3f sbVec3f2 = initPos.minus(sbVec3f);
        float f = sbVec3f2.length();
        if (f < this.globalFactor.getValue() * 5.0f) {
            this._leftConeTransform.rotation.setValue(new SbRotation(new SbVec3f(0.0f, -1.0f, 0.0f), sbVec3f2));
            this._rightConeTransform.rotation.setValue(new SbRotation(new SbVec3f(0.0f, 1.0f, 0.0f), sbVec3f2));
        } else {
            this._leftConeTransform.rotation.setValue(new SbRotation(new SbVec3f(0.0f, 1.0f, 0.0f), sbVec3f2));
            this._rightConeTransform.rotation.setValue(new SbRotation(new SbVec3f(0.0f, -1.0f, 0.0f), sbVec3f2));
        }
        this._rulerAnnotation.string.setValue(String.valueOf(f) + " " + this.label.getValue());
        sbVec3f2.divide(3.0f);
        this._annotationTransform.translation.setValue(initPos.minus(sbVec3f2));
        this._root.enableNotify(true);
        this._root.touch();
    }

    public Ruler() {
        initPos = new SbVec3f(0.0f, 0.0f, 0.0f);
        this.setName("Ruler");
        this.buildSceneGraph();
    }

    public SoNode.RenderModes getRenderEngineMode() {
        return SoNode.RenderModes.OIV_OPENINVENTOR_RENDERING;
    }

    public SoFont getFont() {
        return this._annotationFont;
    }

    private void buildSceneGraph() {
        this._root = new SoSeparator();
        this._dStyle = new SoDrawStyle();
        this._dStyle.style.setValue((Enum)SoDrawStyle.Styles.INVISIBLE);
        this._dStyle.lineWidth.setValue(2.0f);
        this._root.addChild((SoNode)this._dStyle);
        SoPickStyle soPickStyle = new SoPickStyle();
        soPickStyle.style.setValue((Enum)SoPickStyle.Styles.UNPICKABLE);
        this._root.addChild((SoNode)soPickStyle);
        SoShapeHints soShapeHints = new SoShapeHints();
        soShapeHints.vertexOrdering.setValue((Enum)SoShapeHints.VertexOrderings.COUNTERCLOCKWISE);
        this._root.addChild((SoNode)soShapeHints);
        SoMaterial soMaterial = new SoMaterial();
        soMaterial.diffuseColor.setValue(new SbColor(1.0f, 0.0f, 0.0f));
        this._root.addChild((SoNode)soMaterial);
        SoSeparator soSeparator = new SoSeparator();
        this._root.addChild((SoNode)soSeparator);
        this._leftConeTransform = new SoTransform();
        soSeparator.addChild((SoNode)this._leftConeTransform);
        this._initialLeftTranslation = new SoTranslation();
        this._initialLeftTranslation.translation.setValue(new SbVec3f(0.0f, -this.globalFactor.getValue(), 0.0f));
        soSeparator.addChild((SoNode)this._initialLeftTranslation);
        this._leftCone = new SoCone();
        this._leftCone.bottomRadius.setValue(this.globalFactor.getValue());
        this._leftCone.height.setValue(2.0f * this.globalFactor.getValue());
        soSeparator.addChild((SoNode)this._leftCone);
        SoSeparator soSeparator2 = new SoSeparator();
        this._root.addChild((SoNode)soSeparator2);
        this._rightConeTransform = new SoTransform();
        soSeparator2.addChild((SoNode)this._rightConeTransform);
        this._initialRightTranslation = new SoTranslation();
        this._initialRightTranslation.translation.setValue(new SbVec3f(0.0f, -this.globalFactor.getValue(), 0.0f));
        soSeparator2.addChild((SoNode)this._initialRightTranslation);
        this._rightCone = new SoCone();
        this._rightCone.bottomRadius.setValue(this.globalFactor.getValue());
        this._rightCone.height.setValue(2.0f * this.globalFactor.getValue());
        soSeparator2.addChild((SoNode)this._rightCone);
        this._rulerVertexProp = new SoVertexProperty();
        this._ruler = new SoLineSet();
        this._ruler.vertexProperty.setValue((SoNode)this._rulerVertexProp);
        this._root.addChild((SoNode)this._ruler);
        SoAnnotation soAnnotation = new SoAnnotation();
        this._root.addChild((SoNode)soAnnotation);
        this._annotationTransform = new SoTransform();
        soAnnotation.addChild((SoNode)this._annotationTransform);
        SoMaterial soMaterial2 = new SoMaterial();
        soMaterial2.diffuseColor.setValue(0.1f, 0.1f, 0.1f);
        soAnnotation.addChild((SoNode)soMaterial2);
        SoTextProperty soTextProperty = new SoTextProperty();
        soTextProperty.alignmentV.setValue((Enum)SoTextProperty.AlignmentVs.BOTTOM);
        soTextProperty.style.setValue((Enum)SoTextProperty.Styles.BACK_FRAME);
        soTextProperty.styleColors.set1Value(SoTextProperty.StyleColorType.BACK_FRAME_COLOR.getValue(), new SbColorRGBA(1.0f, 1.0f, 1.0f, 0.5f));
        soAnnotation.addChild((SoNode)soTextProperty);
        this._annotationFont = new SoFont();
        this._annotationFont.size.setValue(17.0f);
        soAnnotation.addChild((SoNode)this._annotationFont);
        SoTranslation soTranslation = new SoTranslation();
        soTranslation.translation.setValue(new SbVec3f(0.0f, this.globalFactor.getValue(), 0.0f));
        soAnnotation.addChild((SoNode)soTranslation);
        this._rulerAnnotation = new SoText2();
        soAnnotation.addChild((SoNode)this._rulerAnnotation);
        this._labelFieldSensor = new SoFieldSensor(new Runnable(){

            @Override
            public void run() {
                SbVec3f sbVec3f = Ruler.this._rulerVertexProp.vertex.getValueAt(0);
                SbVec3f sbVec3f2 = Ruler.this._rulerVertexProp.vertex.getValueAt(1);
                SbVec3f sbVec3f3 = sbVec3f.minus(sbVec3f2);
                float f = sbVec3f3.length();
                Ruler.this._rulerAnnotation.string.setValue(String.valueOf(f) + " " + Ruler.this.label.getValue());
            }
        });
        this._labelFieldSensor.setPriority(0L);
        this._labelFieldSensor.attach((SoField)this.label);
        this._globalFactorFieldSensor = new SoFieldSensor(new Runnable(){

            @Override
            public void run() {
                Ruler.this.updateGlobalFactor();
            }
        });
        this._globalFactorFieldSensor.setPriority(0L);
        this._globalFactorFieldSensor.attach((SoField)this.globalFactor);
        this._internalRootSensor = new SoNodeSensor(new Runnable(){

            @Override
            public void run() {
                Ruler.this.touch();
            }
        });
        this._internalRootSensor.setPriority(0L);
        this._internalRootSensor.attach((SoNode)this._root);
    }

    private void updateGlobalFactor() {
        this._initialLeftTranslation.translation.setValue(new SbVec3f(0.0f, -this.globalFactor.getValue(), 0.0f));
        this._initialRightTranslation.translation.setValue(new SbVec3f(0.0f, -this.globalFactor.getValue(), 0.0f));
        this._leftCone.bottomRadius.setValue(this.globalFactor.getValue());
        this._leftCone.height.setValue(2.0f * this.globalFactor.getValue());
        this._rightCone.bottomRadius.setValue(this.globalFactor.getValue());
        this._rightCone.height.setValue(2.0f * this.globalFactor.getValue());
    }
}

