/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.medical.nodes;

import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoBBox;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoText2;
import com.openinventor.inventor.nodes.SoTextProperty;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.medical.helpers.MedicalHelper;

public class SliceOrientationMarkers
extends SoAnnotation {
    public SoSFEnum<MedicalHelper.Axis> axis;
    public SoSFFloat offset = new SoSFFloat((SoFieldContainer)this, "offset", SoField.FieldTypes.EXPOSED_FIELD, 0.05f);
    public SoSFString fontName = new SoSFString((SoFieldContainer)this, "fontName", SoField.FieldTypes.EXPOSED_FIELD, "Arial:Bold");
    public SoSFFloat fontSize = new SoSFFloat((SoFieldContainer)this, "fontSize", SoField.FieldTypes.EXPOSED_FIELD, 17.0f);
    protected SoFont _fontNode;
    protected SoText2[] _textNodes;
    protected SoTranslation[] _tranNodes;
    protected SoFieldSensor _axisSensor;
    protected SoFieldSensor _offsetSensor;

    public SliceOrientationMarkers() {
        this.axis = new SoSFEnum((SoFieldContainer)this, "axis", SoField.FieldTypes.EXPOSED_FIELD, MedicalHelper.Axis.class, (Enum)MedicalHelper.Axis.AXIAL);
        this._fontNode = new SoFont();
        this._textNodes = new SoText2[4];
        this._tranNodes = new SoTranslation[4];
        for (int i = 0; i < 4; ++i) {
            this._textNodes[i] = new SoText2();
            this._tranNodes[i] = new SoTranslation();
        }
        this.buildSceneGraph();
    }

    public SoNode.RenderModes getRenderEngineMode() {
        return SoNode.RenderModes.OIV_OPENINVENTOR_RENDERING;
    }

    protected void buildSceneGraph() {
        this.setName("SliceOrientationMarkers");
        SoBBox soBBox = new SoBBox();
        soBBox.mode.setValue((Enum)SoBBox.Modes.NO_BOUNDING_BOX);
        this.addChild((SoNode)soBBox);
        SoLightModel soLightModel = new SoLightModel();
        soLightModel.model.setValue((Enum)SoLightModel.Models.BASE_COLOR);
        this.addChild((SoNode)soLightModel);
        SoPickStyle soPickStyle = new SoPickStyle();
        soPickStyle.style.setValue((Enum)SoPickStyle.Styles.UNPICKABLE);
        this.addChild((SoNode)soPickStyle);
        SoOrthographicCamera soOrthographicCamera = new SoOrthographicCamera();
        soOrthographicCamera.viewportMapping.setValue((Enum)SoCamera.ViewportMappings.LEAVE_ALONE);
        this.addChild((SoNode)soOrthographicCamera);
        this._fontNode = new SoFont();
        this._fontNode.size.connectFrom((SoField)this.fontSize);
        this._fontNode.name.connectFrom((SoField)this.fontName);
        this._fontNode.renderStyle.setValue((Enum)SoFont.RenderStyles.TEXTURE);
        this.addChild((SoNode)this._fontNode);
        for (int i = 0; i < 4; ++i) {
            SoSeparator soSeparator = new SoSeparator();
            this.addChild((SoNode)soSeparator);
            SoTextProperty soTextProperty = new SoTextProperty();
            soTextProperty.backFrameLineWidth.setIgnored(true);
            soTextProperty.margin.setIgnored(true);
            soTextProperty.style.setIgnored(true);
            soTextProperty.styleColors.setIgnored(true);
            soSeparator.addChild((SoNode)soTextProperty);
            switch (i) {
                case 0: {
                    soTextProperty.alignmentH.setValue((Enum)SoTextProperty.AlignmentHs.LEFT);
                    soTextProperty.alignmentV.setValue((Enum)SoTextProperty.AlignmentVs.HALF);
                    break;
                }
                case 1: {
                    soTextProperty.alignmentH.setValue((Enum)SoTextProperty.AlignmentHs.RIGHT);
                    soTextProperty.alignmentV.setValue((Enum)SoTextProperty.AlignmentVs.HALF);
                    break;
                }
                case 2: {
                    soTextProperty.alignmentH.setValue((Enum)SoTextProperty.AlignmentHs.CENTER);
                    soTextProperty.alignmentV.setValue((Enum)SoTextProperty.AlignmentVs.TOP);
                    break;
                }
                case 3: {
                    soTextProperty.alignmentH.setValue((Enum)SoTextProperty.AlignmentHs.CENTER);
                    soTextProperty.alignmentV.setValue((Enum)SoTextProperty.AlignmentVs.BASE);
                }
            }
            this._tranNodes[i] = new SoTranslation();
            soSeparator.addChild((SoNode)this._tranNodes[i]);
            this._textNodes[i] = new SoText2();
            this._textNodes[i].justification.setValue((Enum)SoText2.Justifications.INHERITED);
            soSeparator.addChild((SoNode)this._textNodes[i]);
        }
        this.updateLetters();
        this._axisSensor = new SoFieldSensor(() -> this.updateLetters());
        this._axisSensor.setPriority(0L);
        this._axisSensor.attach(this.axis);
        this._offsetSensor = new SoFieldSensor(() -> this.updateLetters());
        this._offsetSensor.setPriority(0L);
        this._offsetSensor.attach((SoField)this.offset);
    }

    protected void updateLetters() {
        float f = this.offset.getValue();
        this._tranNodes[0].translation.setValue(f - 1.0f, 0.0f, 0.0f);
        this._tranNodes[1].translation.setValue(1.0f - f, 0.0f, 0.0f);
        this._tranNodes[2].translation.setValue(0.0f, 1.0f - f, 0.0f);
        this._tranNodes[3].translation.setValue(0.0f, f - 1.0f, 0.0f);
        if (this.axis.getValue() == MedicalHelper.Axis.AXIAL.getValue()) {
            this._textNodes[0].string.set1Value(0, "R");
            this._textNodes[1].string.set1Value(0, "L");
            this._textNodes[2].string.set1Value(0, "A");
            this._textNodes[3].string.set1Value(0, "P");
        } else if (this.axis.getValue() == MedicalHelper.Axis.CORONAL.getValue()) {
            this._textNodes[0].string.set1Value(0, "R");
            this._textNodes[1].string.set1Value(0, "L");
            this._textNodes[2].string.set1Value(0, "S");
            this._textNodes[3].string.set1Value(0, "I");
        } else {
            this._textNodes[0].string.set1Value(0, "A");
            this._textNodes[1].string.set1Value(0, "P");
            this._textNodes[2].string.set1Value(0, "S");
            this._textNodes[3].string.set1Value(0, "I");
        }
    }
}

