/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.GenericAbstractNativeResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.errors.SoInternalError;

public abstract class AbstractNativeResourceHandle
extends GenericAbstractNativeResourceHandle<Inventor> {
    private int handleState;

    protected AbstractNativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
        super(inventor, l);
        this.handleState = NativeHandleStateBitMask.set(0, NativeHandleStateBitMask.NEW_INSTANCE, constructorCommand == Inventor.ConstructorCommand.CreateInstance);
    }

    abstract boolean deleteNativeResourceWhenReleased();

    public boolean isClosed() {
        return NativeHandleStateBitMask.get(this.handleState, NativeHandleStateBitMask.CLOSED);
    }

    private void closeHandle(boolean bl) {
        this.handleState = NativeHandleStateBitMask.set(this.handleState, NativeHandleStateBitMask.CLOSED, bl);
    }

    public boolean isNewInstance() {
        return NativeHandleStateBitMask.get(this.handleState, NativeHandleStateBitMask.NEW_INSTANCE);
    }

    @Override
    public void DangerousAddRef() {
        if (this.isClosed()) {
            throw new SoInternalError("trying to resurrect a potentially released native resource.");
        }
        super.DangerousAddRef();
    }

    @Override
    public void DangerousRelease() {
        super.DangerousRelease();
        this.closeHandle(this.refCounter == 0);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() == AbstractNativeResourceHandle.class) {
            AbstractNativeResourceHandle abstractNativeResourceHandle = (AbstractNativeResourceHandle)object;
            return abstractNativeResourceHandle.getHandle() == this.getHandle();
        }
        return false;
    }

    private static enum NativeHandleStateBitMask implements IntegerValuedEnum
    {
        CLOSED(1),
        NEW_INSTANCE(2);

        private int value;

        private NativeHandleStateBitMask(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static int set(int n, NativeHandleStateBitMask nativeHandleStateBitMask, boolean bl) {
            if (bl) {
                return n | nativeHandleStateBitMask.getValue();
            }
            return n & ~nativeHandleStateBitMask.getValue();
        }

        public static boolean get(int n, NativeHandleStateBitMask nativeHandleStateBitMask) {
            return (n & nativeHandleStateBitMask.getValue()) == nativeHandleStateBitMask.getValue();
        }
    }
}

