/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.SbBasic;
import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.internal.JniInitializer;

public class SbPlane
extends SbBasic {
    public final float[] array;

    private static native void setValueFromHandle(float[] var0, long var1);

    private static native void ctorImpl(float[] var0);

    private static native void transformImpl(float[] var0, float[] var1);

    private static native void ctorImpl1(float[] var0, float[] var1, float[] var2, float[] var3);

    private static native void ctorImpl2(float[] var0, float[] var1, float var2);

    private static native boolean intersectImpl(float[] var0, float[] var1, float[] var2);

    private static native void ctorImpl3(float[] var0, float[] var1, float[] var2);

    private static native boolean isInHalfSpaceImpl(float[] var0, float[] var1);

    private static native void toArrayImpl(long var0, SbPlane[] var2);

    private static native float getDistanceImpl(float[] var0, float[] var1);

    private static native boolean equalsImpl(float[] var0, float[] var1);

    private static native float getDistanceFromOriginImpl(float[] var0);

    private static native void checkSize();

    private static native void getNormalImpl(float[] var0, float[] var1);

    private static native void offsetImpl(float[] var0, float var1);

    protected SbPlane(int n) {
        this.array = new float[n];
    }

    SbPlane(long l) {
        this();
        SbPlane.setValueFromHandle(this.array, l);
    }

    public SbPlane setValue(float[] fArray, int n) {
        if (n < 0 || n >= fArray.length - 4) {
            throw new IllegalArgumentException();
        }
        this.array[0] = fArray[n + 0];
        this.array[1] = fArray[n + 1];
        this.array[2] = fArray[n + 2];
        this.array[3] = fArray[n + 3];
        return this;
    }

    public float[] getValue() {
        return this.array;
    }

    public SbPlane(float[] fArray) {
        this(4);
        if (fArray == null) {
            throw new IllegalArgumentException("Expected a non-null argument.");
        }
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4.");
        }
        this.setValue(fArray);
    }

    public SbPlane(SbPlane sbPlane) {
        this();
        this.setValue(sbPlane);
    }

    public void setValue(SbPlane sbPlane) {
        this.setValue(sbPlane.array);
    }

    public SbPlane setValue(float[] fArray) {
        this.array[0] = fArray[0];
        this.array[1] = fArray[1];
        this.array[2] = fArray[2];
        this.array[3] = fArray[3];
        return this;
    }

    public float getDistance(SbVec3f sbVec3f) {
        return SbPlane.getDistanceImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public static SbPlane[] toArray(long l, long l2) {
        SbPlane[] sbPlaneArray = new SbPlane[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbPlaneArray[n] = new SbPlane();
            ++n;
        }
        SbPlane.toArrayImpl(l, sbPlaneArray);
        return sbPlaneArray;
    }

    public void offset(float f) {
        SbPlane.offsetImpl(this.array, f);
    }

    public SbVec3f intersect(SbLine sbLine) {
        SbVec3f sbVec3f = new SbVec3f();
        boolean bl = false;
        bl = SbPlane.intersectImpl(this.array, sbLine != null ? sbLine.array : null, sbVec3f != null ? sbVec3f.array : null);
        if (bl) {
            return sbVec3f;
        }
        return null;
    }

    public SbPlane(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this(4);
        SbPlane.ctorImpl3(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
    }

    public SbPlane(SbVec3f sbVec3f, float f) {
        this(4);
        SbPlane.ctorImpl2(this.array, sbVec3f != null ? sbVec3f.array : null, f);
    }

    public SbPlane(SbVec3f sbVec3f, SbVec3f sbVec3f2, SbVec3f sbVec3f3) {
        this(4);
        SbPlane.ctorImpl1(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null, sbVec3f3 != null ? sbVec3f3.array : null);
    }

    public boolean isInHalfSpace(SbVec3f sbVec3f) {
        return SbPlane.isInHalfSpaceImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public SbPlane() {
        this(4);
        SbPlane.ctorImpl(this.array);
    }

    public SbVec3f getNormal() {
        SbVec3f sbVec3f = new SbVec3f();
        SbPlane.getNormalImpl(this.array, sbVec3f.array);
        return sbVec3f;
    }

    public float getDistanceFromOrigin() {
        return SbPlane.getDistanceFromOriginImpl(this.array);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SbPlane) {
            SbPlane sbPlane = (SbPlane)object;
            return SbPlane.equalsImpl(this.array, sbPlane.array);
        }
        return false;
    }

    public void transform(SbMatrix sbMatrix) {
        SbPlane.transformImpl(this.array, sbMatrix != null ? sbMatrix.array : null);
    }

    static {
        JniInitializer.checkInit();
        SbPlane.checkSize();
    }
}

