/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.SbBasic;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbLine;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.internal.JniInitializer;

public class SbSphere
extends SbBasic {
    public final float[] array;

    private static native void setRadiusImpl(float[] var0, float var1);

    private static native void setValueImpl(float[] var0, float[] var1, float var2);

    private static native void setCenterImpl(float[] var0, float[] var1);

    private static native void setValueFromHandle(float[] var0, long var1);

    private static native void getCenterImpl(float[] var0, float[] var1);

    private static native float getRadiusImpl(float[] var0);

    private static native void circumscribeImpl(float[] var0, float[] var1);

    private static native boolean intersectFirstImpl(float[] var0, float[] var1, float[] var2);

    private static native boolean intersectImpl(float[] var0, float[] var1, float[] var2, float[] var3);

    private static native void toArrayImpl(long var0, SbSphere[] var2);

    private static native void ctorImpl1(float[] var0, float[] var1, float var2);

    private static native void checkSize();

    private static native void ctorImpl(float[] var0);

    protected SbSphere(int n) {
        this.array = new float[n];
    }

    SbSphere(long l) {
        this();
        SbSphere.setValueFromHandle(this.array, l);
    }

    public SbSphere(float[] fArray) {
        this(4);
        if (fArray == null) {
            throw new IllegalArgumentException("Expected a non-null argument.");
        }
        if (fArray.length != 4) {
            throw new IllegalArgumentException("Expected size is 4.");
        }
        this.setValue(fArray);
    }

    public SbSphere setValue(float[] fArray, int n) {
        if (n < 0 || n >= fArray.length - 4) {
            throw new IllegalArgumentException();
        }
        this.array[0] = fArray[n + 0];
        this.array[1] = fArray[n + 1];
        this.array[2] = fArray[n + 2];
        this.array[3] = fArray[n + 3];
        return this;
    }

    public float[] getValue() {
        return this.array;
    }

    public void setValue(SbSphere sbSphere) {
        this.setValue(sbSphere.array);
    }

    public SbSphere(SbSphere sbSphere) {
        this();
        this.setValue(sbSphere);
    }

    public SbSphere setValue(float[] fArray) {
        this.array[0] = fArray[0];
        this.array[1] = fArray[1];
        this.array[2] = fArray[2];
        this.array[3] = fArray[3];
        return this;
    }

    public static SbSphere[] toArray(long l, long l2) {
        SbSphere[] sbSphereArray = new SbSphere[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbSphereArray[n] = new SbSphere();
            ++n;
        }
        SbSphere.toArrayImpl(l, sbSphereArray);
        return sbSphereArray;
    }

    public SbVec3f[] intersect(SbLine sbLine) {
        SbVec3f sbVec3f = new SbVec3f();
        SbVec3f sbVec3f2 = new SbVec3f();
        boolean bl = false;
        bl = SbSphere.intersectImpl(this.array, sbLine != null ? sbLine.array : null, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null);
        if (bl) {
            SbVec3f[] sbVec3fArray = new SbVec3f[]{sbVec3f, sbVec3f2};
            return sbVec3fArray;
        }
        return null;
    }

    public void setCenter(SbVec3f sbVec3f) {
        SbSphere.setCenterImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public void setRadius(float f) {
        SbSphere.setRadiusImpl(this.array, f);
    }

    public SbSphere() {
        this(4);
        SbSphere.ctorImpl(this.array);
    }

    public SbVec3f getCenter() {
        SbVec3f sbVec3f = new SbVec3f();
        SbSphere.getCenterImpl(this.array, sbVec3f.array);
        return sbVec3f;
    }

    public float getRadius() {
        return SbSphere.getRadiusImpl(this.array);
    }

    public SbSphere(SbVec3f sbVec3f, float f) {
        this(4);
        SbSphere.ctorImpl1(this.array, sbVec3f != null ? sbVec3f.array : null, f);
    }

    public void setValue(SbVec3f sbVec3f, float f) {
        SbSphere.setValueImpl(this.array, sbVec3f != null ? sbVec3f.array : null, f);
    }

    public SbVec3f intersectFirst(SbLine sbLine) {
        SbVec3f sbVec3f = new SbVec3f();
        boolean bl = false;
        bl = SbSphere.intersectFirstImpl(this.array, sbLine != null ? sbLine.array : null, sbVec3f != null ? sbVec3f.array : null);
        if (bl) {
            return sbVec3f;
        }
        return null;
    }

    public void circumscribe(SbBox3f sbBox3f) {
        SbSphere.circumscribeImpl(this.array, sbBox3f != null ? sbBox3f.array : null);
    }

    static {
        JniInitializer.checkInit();
        SbSphere.checkSize();
    }
}

