/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.SbBasic;
import com.openinventor.inventor.SbPlane;
import com.openinventor.inventor.SbVec3d;
import com.openinventor.inventor.internal.JniInitializer;

public class SbVec3f
extends SbBasic {
    public final float[] array;
    public static final int LENGTH = 500000;

    private static void setValuesTest() {
        SbVec3f[] sbVec3fArray = new SbVec3f[500000];
        for (int i = 0; i < 500000; ++i) {
            sbVec3fArray[i] = new SbVec3f(i + 1, i, i - 1);
        }
    }

    private static native void negateImpl(float[] var0);

    private static native void setValueFromHandle(float[] var0, long var1);

    private static native void setValueImpl2(float[] var0, float[] var1, float[] var2, float[] var3, float[] var4, float[] var5);

    private static native void setValueImpl3(float[] var0, double[] var1, float[] var2);

    private static native void multiplyImpl(float[] var0, float var1);

    private static native float normalizeImpl(float[] var0);

    private static native void ctorImpl3(float[] var0, float[] var1, float[] var2, float[] var3);

    private static native void crossImpl(float[] var0, float[] var1, float[] var2);

    private static native float dotImpl(float[] var0, float[] var1);

    private static native float lengthImpl(float[] var0);

    private static native float lengthSquaredImpl(float[] var0);

    private static native void divideImpl(float[] var0, float var1);

    private static native void minusImpl(float[] var0, float[] var1, float[] var2);

    private static native boolean equalsImpl(float[] var0, float[] var1);

    private static native boolean equalsImpl1(float[] var0, float[] var1, float var2);

    private static native void getClosestAxisImpl(float[] var0, float[] var1);

    private static native void toArrayImpl(long var0, SbVec3f[] var2);

    private static native void plusImpl(float[] var0, float[] var1, float[] var2);

    private static native void addImpl(float[] var0, float[] var1);

    private static native void substractImpl(float[] var0, float[] var1);

    private static native void timesImpl(float[] var0, float[] var1, float[] var2);

    private static native void multiplyImpl1(float[] var0, float[] var1);

    private static native void timesImpl1(float[] var0, float var1, float[] var2);

    private static native void overImpl(float[] var0, float var1, float[] var2);

    private static native void checkSize();

    protected SbVec3f(int n) {
        this.array = new float[n];
    }

    SbVec3f(long l) {
        this();
        SbVec3f.setValueFromHandle(this.array, l);
    }

    public void setValue(SbVec3f sbVec3f) {
        this.setValue(sbVec3f.array);
    }

    public float[] getValue() {
        return this.array;
    }

    public SbVec3f setValue(float[] fArray) {
        this.array[0] = fArray[0];
        this.array[1] = fArray[1];
        this.array[2] = fArray[2];
        return this;
    }

    public SbVec3f setValue(float[] fArray, int n) {
        if (n < 0 || n >= fArray.length - 3) {
            throw new IllegalArgumentException();
        }
        this.array[0] = fArray[n + 0];
        this.array[1] = fArray[n + 1];
        this.array[2] = fArray[n + 2];
        return this;
    }

    public void setX(float f) {
        this.setValueAt(0, f);
    }

    public void setY(float f) {
        this.setValueAt(1, f);
    }

    public float getValueAt(int n) {
        return this.array[n];
    }

    public SbVec3f(float[] fArray) {
        this(3);
        if (fArray == null) {
            throw new IllegalArgumentException("Expected a non-null argument.");
        }
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3.");
        }
        this.setValue(fArray);
    }

    public SbVec3f(SbVec3f sbVec3f) {
        this();
        this.setValue(sbVec3f);
    }

    public SbVec3f(float f, float f2, float f3) {
        this(3);
        this.setValue(f, f2, f3);
    }

    public SbVec3f() {
        this(3);
        this.setValue(0.0f, 0.0f, 0.0f);
    }

    public SbVec3f setValue(float f, float f2, float f3) {
        this.array[0] = f;
        this.array[1] = f2;
        this.array[2] = f3;
        return this;
    }

    public void setValueAt(int n, float f) {
        this.array[n] = f;
    }

    public float getY() {
        return this.getValueAt(1);
    }

    public void setZ(float f) {
        this.setValueAt(2, f);
    }

    public float getZ() {
        return this.getValueAt(2);
    }

    public float getX() {
        return this.getValueAt(0);
    }

    public float normalize() {
        return SbVec3f.normalizeImpl(this.array);
    }

    public boolean equals(SbVec3f sbVec3f, float f) {
        return SbVec3f.equalsImpl1(this.array, sbVec3f != null ? sbVec3f.array : null, f);
    }

    public void negate() {
        SbVec3f.negateImpl(this.array);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SbVec3f) {
            SbVec3f sbVec3f = (SbVec3f)object;
            return SbVec3f.equalsImpl(this.array, sbVec3f.array);
        }
        return false;
    }

    public SbVec3f getClosestAxis() {
        SbVec3f sbVec3f = new SbVec3f();
        SbVec3f.getClosestAxisImpl(this.array, sbVec3f.array);
        return sbVec3f;
    }

    public static SbVec3f[] toArray(long l, long l2) {
        SbVec3f[] sbVec3fArray = new SbVec3f[(int)l2];
        int n = 0;
        while ((long)n < l2) {
            sbVec3fArray[n] = new SbVec3f();
            ++n;
        }
        SbVec3f.toArrayImpl(l, sbVec3fArray);
        return sbVec3fArray;
    }

    public float length() {
        return SbVec3f.lengthImpl(this.array);
    }

    public float lengthSquared() {
        return SbVec3f.lengthSquaredImpl(this.array);
    }

    public float dot(SbVec3f sbVec3f) {
        return SbVec3f.dotImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public SbVec3f(SbPlane sbPlane, SbPlane sbPlane2, SbPlane sbPlane3) {
        this(3);
        SbVec3f.ctorImpl3(this.array, sbPlane != null ? sbPlane.array : null, sbPlane2 != null ? sbPlane2.array : null, sbPlane3 != null ? sbPlane3.array : null);
    }

    public SbVec3f setValue(SbVec3d sbVec3d) {
        SbVec3f sbVec3f = new SbVec3f();
        SbVec3f.setValueImpl3(this.array, sbVec3d != null ? sbVec3d.array : null, sbVec3f.array);
        return sbVec3f;
    }

    public void multiply(float f) {
        SbVec3f.multiplyImpl(this.array, f);
    }

    public void substract(SbVec3f sbVec3f) {
        SbVec3f.substractImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public void add(SbVec3f sbVec3f) {
        SbVec3f.addImpl(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public void multiply(SbVec3f sbVec3f) {
        SbVec3f.multiplyImpl1(this.array, sbVec3f != null ? sbVec3f.array : null);
    }

    public SbVec3f minus(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbVec3f.minusImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2.array);
        return sbVec3f2;
    }

    public void divide(float f) {
        if (f == 0.0f) {
            throw new ArithmeticException("Divide by zero");
        }
        SbVec3f.divideImpl(this.array, f);
    }

    public SbVec3f plus(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbVec3f.plusImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2.array);
        return sbVec3f2;
    }

    public SbVec3f over(float f) {
        if (f == 0.0f) {
            throw new ArithmeticException("Divide by zero");
        }
        SbVec3f sbVec3f = new SbVec3f();
        SbVec3f.overImpl(this.array, f, sbVec3f.array);
        return sbVec3f;
    }

    public SbVec3f setValue(SbVec3f sbVec3f, SbVec3f sbVec3f2, SbVec3f sbVec3f3, SbVec3f sbVec3f4) {
        SbVec3f sbVec3f5 = new SbVec3f();
        SbVec3f.setValueImpl2(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2 != null ? sbVec3f2.array : null, sbVec3f3 != null ? sbVec3f3.array : null, sbVec3f4 != null ? sbVec3f4.array : null, sbVec3f5.array);
        return sbVec3f5;
    }

    public SbVec3f times(float f) {
        SbVec3f sbVec3f = new SbVec3f();
        SbVec3f.timesImpl1(this.array, f, sbVec3f.array);
        return sbVec3f;
    }

    public SbVec3f cross(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbVec3f.crossImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2.array);
        return sbVec3f2;
    }

    public SbVec3f times(SbVec3f sbVec3f) {
        SbVec3f sbVec3f2 = new SbVec3f();
        SbVec3f.timesImpl(this.array, sbVec3f != null ? sbVec3f.array : null, sbVec3f2.array);
        return sbVec3f2;
    }

    static {
        JniInitializer.checkInit();
        SbVec3f.checkSize();
    }
}

