/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoInputParameters;
import com.openinventor.inventor.internal.JniInitializer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class SoInput
extends Inventor {
    private SoInputParameters m_parameters_setInputParameters;
    public static final String DIRECTORIES_SEPARATOR = File.pathSeparator;
    private long nativBuff = 0L;

    public void setBuffer(byte[] byArray) {
        this.setBufferImpl(this.getNativeResourceHandle(), byArray, byArray.length);
    }

    public void setBuffer(byte[] byArray, int n) {
        this.setBufferImpl(this.getNativeResourceHandle(), byArray, n);
    }

    private native void setBufferImpl(long var1, byte[] var3, int var4);

    public void setBuffer(String string, int n) {
        this.setBufferImpl2(this.getNativeResourceHandle(), string, n);
    }

    private native void setBufferImpl2(long var1, String var3, int var4);

    public boolean openURL(URL uRL) {
        if (uRL == null) {
            return false;
        }
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                return false;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n2 = 4096;
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[2 * n2];
            int n3 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, n2)) > 0) {
                int n4 = n3 + n;
                if (n4 > byArray2.length) {
                    byte[] byArray3 = new byte[Math.max(byArray2.length << 1, n4)];
                    System.arraycopy(byArray2, 0, byArray3, 0, n3);
                    byArray2 = byArray3;
                }
                System.arraycopy(byArray, 0, byArray2, n3, n);
                n3 = n4;
            }
            if (n3 <= 0) {
                return false;
            }
            this.setBuffer(byArray2, n3);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getClass().getName() + " in " + this.getClass().getName() + ".openURL(" + String.valueOf(uRL) + ")");
            System.err.println(iOException.getMessage());
            return false;
        }
        return this.isValidBuffer();
    }

    private static native void addDirectoryFirstImpl(String var0);

    private static native long getInputParametersImpl(long var0);

    private static native void setInputParametersImpl(long var0, long var2);

    private static native void updateReadPercentImpl(long var0, double var2);

    private static native float getIVVersionImpl(long var0);

    private static native String getHeaderImpl(long var0);

    private static native int getNumBytesReadImpl(long var0);

    private static native String getCurStringFileNameImpl(long var0);

    private static native String getCurFileNameImpl(long var0);

    private static native boolean findAbsolutePathImpl(String var0, String[] var1);

    private static native void addEnvDirectoriesLastImpl(String var0, String var1);

    private static native void addEnvDirectoriesFirstImpl(String var0, String var1);

    private static native void clearDirectoriesImpl();

    private static native void addDirectoryLastImpl1(String var0);

    private static native boolean isValidBufferImpl(long var0);

    private static native void removeDirectoryImpl(String var0);

    private static native boolean openFileImpl1(long var0, String var2, boolean var3, boolean var4);

    private static native long ctorImpl();

    private static native boolean pushFileImpl1(long var0, String var2);

    private static native void closeFileImpl(long var0);

    private static native boolean isValidFileImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoInput(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public boolean openFile(String string) {
        return this.openFile(string, false, false);
    }

    public boolean openFile(String string, boolean bl) {
        return this.openFile(string, bl, false);
    }

    public static void addEnvDirectoriesLast(String string) {
        SoInput.addEnvDirectoriesLast(string, DIRECTORIES_SEPARATOR);
    }

    public static void addEnvDirectoriesFirst(String string) {
        SoInput.addEnvDirectoriesFirst(string, DIRECTORIES_SEPARATOR);
    }

    public boolean isValidBuffer() {
        return SoInput.isValidBufferImpl(this.getNativeResourceHandle());
    }

    public boolean isValidFile() {
        return SoInput.isValidFileImpl(this.getNativeResourceHandle());
    }

    public void closeFile() {
        SoInput.closeFileImpl(this.getNativeResourceHandle());
    }

    public boolean pushFile(String string) {
        return SoInput.pushFileImpl1(this.getNativeResourceHandle(), string);
    }

    public boolean openFile(String string, boolean bl, boolean bl2) {
        return SoInput.openFileImpl1(this.getNativeResourceHandle(), string, bl, bl2);
    }

    public SoInput() {
        this(Inventor.ConstructorCommand.CreateInstance, SoInput.ctorImpl());
    }

    public static void addDirectoryLast(String string) {
        SoInput.addDirectoryLastImpl1(string);
    }

    public static void addEnvDirectoriesFirst(String string, String string2) {
        SoInput.addEnvDirectoriesFirstImpl(string, string2);
    }

    public static void addEnvDirectoriesLast(String string, String string2) {
        SoInput.addEnvDirectoriesLastImpl(string, string2);
    }

    public static void removeDirectory(String string) {
        SoInput.removeDirectoryImpl(string);
    }

    public static void clearDirectories() {
        SoInput.clearDirectoriesImpl();
    }

    public static String findAbsolutePath(String string) {
        String[] stringArray = new String[1];
        boolean bl = false;
        bl = SoInput.findAbsolutePathImpl(string, stringArray);
        if (bl) {
            return stringArray[0];
        }
        return null;
    }

    public String getCurFileName() {
        return SoInput.getCurFileNameImpl(this.getNativeResourceHandle());
    }

    public String getCurStringFileName() {
        return SoInput.getCurStringFileNameImpl(this.getNativeResourceHandle());
    }

    public int getNumBytesRead() {
        return SoInput.getNumBytesReadImpl(this.getNativeResourceHandle());
    }

    public String getHeader() {
        return SoInput.getHeaderImpl(this.getNativeResourceHandle());
    }

    public float getIVVersion() {
        return SoInput.getIVVersionImpl(this.getNativeResourceHandle());
    }

    public void updateReadPercent(double d) {
        SoInput.updateReadPercentImpl(this.getNativeResourceHandle(), d);
    }

    public void setInputParameters(SoInputParameters soInputParameters) {
        this.m_parameters_setInputParameters = soInputParameters;
        SoInput.setInputParametersImpl(this.getNativeResourceHandle(), soInputParameters != null ? soInputParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoInputParameters getInputParameters() {
        return ObjectManager.getManagedObjectFor(SoInputParameters.class, SoInput.getInputParametersImpl(this.getNativeResourceHandle()));
    }

    public static void addDirectoryFirst(String string) {
        SoInput.addDirectoryFirstImpl(string);
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

