/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor;

import com.openinventor.inventor.lock.SoLockManager;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public class SoPreferences {
    public static final String IV_ALLOW_LOCATE_HIGHLIGHT = "IV_ALLOW_LOCATE_HIGHLIGHT";
    public static final String IV_AUTO_CACHE_MIN_VALUE = "IV_AUTO_CACHE_MIN_VALUE";
    public static final String IV_AUTO_CACHE_MAX_VALUE = "IV_AUTO_CACHE_MAX_VALUE";
    public static final String IV_NO_TEXTURE_OBJECT = "IV_NO_TEXTURE_OBJECT";
    public static final String IV_NO_VERTEX_ARRAY = "IV_NO_VERTEX_ARRAY";
    public static final String IV_OCTREE_MAX_DEPTH = "IV_OCTREE_MAX_DEPTH";
    @Deprecated
    public static final String IV_SEPARATOR_MAX_CACHES = "IV_SEPARATOR_MAX_CACHES";
    public static final String IVVR_40_COMPAT = "IVVR_40_COMPAT";
    public static final String IVVR_CHECK_3DTEX_SIZE = "IVVR_CHECK_3DTEX_SIZE";
    public static final String IVVR_DEBUG = "IVVR_DEBUG";
    public static final String IVVR_DELAY_RENDER = "IVVR_DELAY_RENDER";
    public static final String IVVR_IRREGULAR_TRACE_NUM = "IVVR_IRREGULAR_TRACE_NUM";
    public static final String IVVR_INCONSTANT_TRACE_LENGTH = "IVVR_INCONSTANT_TRACE_LENGTH";
    public static final String IVVR_MAX_NUM_LOADERS = "IVVR_MAX_NUM_LOADERS";
    public static final String IVVR_NUM_LOADERS = "IVVR_NUM_LOADERS";
    public static final String IVVR_OGL_CLIPPING = "IVVR_OGL_CLIPPING";
    public static final String IVVR_SEGY_DUMP = "IVVR_SEGY_DUMP";
    public static final String IVVR_SEGY_FLOATISIEEE = "IVVR_SEGY_FLOATISIEEE";
    public static final String IVVR_SEGY_SWAPBYTES = "IVVR_SEGY_SWAPBYTES";
    public static final String IVVR_SHADERS_PATH = "IVVR_SHADERS_PATH";
    public static final String IVVR_TF_TEX_UNIT = "IVVR_TF_TEX_UNIT";
    public static final String IVVR_USE_TEX3D = "IVVR_USE_TEX3D";
    public static final String OIV_3DDATA_CREASE_ANGLE = "OIV_3DDATA_CREASE_ANGLE";
    public static final String OIV_3DDATA_CROSS_SECTION_METHOD = "OIV_3DDATA_CROSS_SECTION_METHOD";
    public static final String OIV_3DDATA_USE_TRIANGLE_STRIP_SET = "OIV_3DDATA_USE_TRIANGLE_STRIP_SET";
    public static final String OIV_ALPHA_TEST = "OIV_ALPHA_TEST";
    public static final String OIV_AMBIENT_COLOR = "OIV_AMBIENT_COLOR";
    public static final String OIV_AMBIENT_INTENSITY = "OIV_AMBIENT_INTENSITY";
    public static final String OIV_BACKGROUND_COLOR = "OIV_BACKGROUND_COLOR";
    public static final String OIV_BUFFER_REGION_ENABLE = "OIV_BUFFER_REGION_ENABLE";
    public static final String OIV_CACHE_MODE = "OIV_CACHE_MODE";
    public static final String OIV_CG_FRAG_PROFILE = "OIV_CG_FRAG_PROFILE";
    public static final String OIV_CG_VTX_PROFILE = "OIV_CG_VTX_PROFILE";
    public static final String OIV_CGM_HARDCOPY_BUFSIZE = "OIV_CGM_HARDCOPY_BUFSIZE";
    public static final String OIV_CLIP_TEXT2 = "OIV_CLIP_TEXT2";
    public static final String OIV_COMPAT_30 = "OIV_COMPAT_30";
    public static final String OIV_COMPAT_40 = "OIV_COMPAT_40";
    public static final String OIV_COMPAT_CGM_HARDCOPY_400 = "OIV_COMPAT_CGM_HARDCOPY_400";
    public static final String OIV_COMPAT_HPGL_HARDCOPY_370 = "OIV_COMPAT_HPGL_HARDCOPY_370";
    public static final String OIV_COMPLEXITY = "OIV_COMPLEXITY";
    public static final String OIV_COMPLEXITY_TYPE = "OIV_COMPLEXITY_TYPE";
    public static final String OIV_CREASE_ANGLE_FIX = "OIV_CREASE_ANGLE_FIX";
    public static final String OIV_DISABLE_DRAGGER_CTRL_KEY = "OIV_DISABLE_DRAGGER_CTRL_KEY";
    public static final String OIV_DRAW_OCTREE = "OIV_DRAW_OCTREE";
    public static final String OIV_ENABLE_MESA_RENDERING = "OIV_ENABLE_MESA_RENDERING";
    public static final String OIV_ENABLE_PNG_BACKGROUND = "OIV_ENABLE_PNG_BACKGROUND";
    public static final String OIV_ENVIRONMENT_ATTENUATION = "OIV_ENVIRONMENT_ATTENUATION";
    public static final String OIV_EXTRUSION_EPSILON = "OIV_EXTRUSION_EPSILON";
    public static final String OIV_FACE_TYPE = "OIV_FACE_TYPE";
    public static final String OIV_FOG_COLOR = "OIV_FOG_COLOR";
    public static final String OIV_FOG_TYPE = "OIV_FOG_TYPE";
    public static final String OIV_FOG_VISIBILITY = "OIV_FOG_VISIBILITY";
    public static final String OIV_FONT_NAME = "OIV_FONT_NAME";
    public static final String OIV_FONT_PATH = "OIV_FONT_PATH";
    public static final String OIV_FONT_SIZE = "OIV_FONT_SIZE";
    public static final String OIV_FONT_RENDERSTYLE = "OIV_FONT_RENDERSTYLE";
    public static final String OIV_FORCE_GLU_NURBS = "OIV_FORCE_GLU_NURBS";
    public static final String OIV_FORCE_TEX_COORD_SENDING = "OIV_FORCE_TEX_COORD_SENDING";
    public static final String OIV_FULL_SCENE_ANTIALIASING = "OIV_FULL_SCENE_ANTIALIASING";
    public static final String OIV_FULL_SCENE_ANTIALIASING_FILTER = "OIV_FULL_SCENE_ANTIALIASING_FILTER";
    public static final String OIV_GL_SMOOTHING = "OIV_GL_SMOOTHING";
    public static final String OIV_SET_RAY_PRECISION = "OIV_SET_RAY_PRECISION";
    public static final String OIV_GLSL_DEBUG = "OIV_GLSL_DEBUG";
    public static final String OIV_INTERSECT_EPSILON = "OIV_INTERSECT_EPSILON";
    public static final String OIV_LINE_WIDTH = "OIV_LINE_WIDTH";
    public static final String OIV_LOWRESHIGHPERCENT = "OIV_LOWRESHIGHPERCENT";
    public static final String OIV_LOWRESLOWPERCENT = "OIV_LOWRESLOWPERCENT";
    public static final String OIV_LOWRESRENDER = "OIV_LOWRESRENDER";
    public static final String OIV_MATERIALS_PATH = "OIV_MATERIALS_PATH";
    public static final String OIV_MAX_ANNO_RENDER2D_SIZE = "OIV_MAX_ANNO_RENDER2D_SIZE";
    public static final String OIV_MAX_CACHES = "OOIV_MAX_CACHESV";
    public static final String OIV_MAX_FONT_CACHES = "OIV_MAX_FONT_CACHES";
    public static final String OIV_MAX_TEXTURED_FONT_RES = "OIV_MAX_TEXTURED_FONT_RES";
    public static final String OIV_MIN_TEXTURED_FONT_RES = "OIV_MIN_TEXTURED_FONT_RES";
    public static final String OIV_MULTITEXTURING = "OIV_MULTITEXTURING";
    public static final String OIV_NO_FBO = "OIV_NO_FBO";
    public static final String OIV_NO_FLEXNET = "OIV_NO_FLEXNET";
    public static final String OIV_NO_OVERLAYS = "OIV_NO_OVERLAYS";
    public static final String OIV_NORMGEN_COMPAT = "OIV_NORMGEN_COMPAT";
    public static final String OIV_NORMGEN_TOLERANCE = "OIV_NORMGEN_TOLERANCE";
    public static final String OIV_NO_SHADER_LAYERS_BLEND = "OIV_NO_SHADER_LAYERS_BLEND";
    public static final String OIV_NO_TEX_TRIM_NURBS = "OIV_NO_TEX_TRIM_NURBS";
    public static final String OIV_NO_VBO = "OIV_NO_VBO";
    public static final String OIV_NUM_RENDER_PASSES = "OIV_NUM_RENDER_PASSES";
    public static final String OIV_NUM_SORTED_LAYERS_PASSES = "OIV_NUM_SORTED_LAYERS_PASSES";
    public static final String OIV_PBUFFER_DEBUG = "OIV_PBUFFER_DEBUG";
    public static final String OIV_PBUFFER_ENABLE = "OIV_PBUFFER_ENABLE";
    public static final String OIV_POLYGON_OFFSET = "OIV_POLYGON_OFFSET";
    public static final String OIV_POLYGON_OFFSET_FACTOR = "OIV_POLYGON_OFFSET_FACTOR";
    public static final String OIV_POLYGON_OFFSET_STYLES = "OIV_POLYGON_OFFSET_STYLES";
    public static final String OIV_POLYGON_OFFSET_UNITS = "OIV_POLYGON_OFFSET_UNITS";
    public static final String OIV_PRIORITIZE_CHILDREN_CACHING = "OIV_PRIORITIZE_CHILDREN_CACHING";
    public static final String OIV_PSFONT_PATH = "OIV_PSFONT_PATH";
    public static final String OIV_REMOTE_ENABLE = "OIV_REMOTE_ENABLE";
    public static final String OIV_REMOTE_PORT = "OIV_REMOTE_PORT";
    public static final String OIV_REMOTE_TIMING = "OIV_REMOTE_TIMING";
    public static final String OIV_REMOTERENDER = "OIV_REMOTERENDER";
    public static final String OIV_REMOTERENDER_BUFFER = "OIV_REMOTERENDER_BUFFER";
    public static final String OIV_REMOTERENDER_DEBUG = "OIV_REMOTERENDER_DEBUG";
    public static final String OIV_REMOTERENDER_DISPLAY = "OIV_REMOTERENDER_DISPLAY";
    public static final String OIV_SHADER_CHECK_INTERVAL = "OIV_SHADER_CHECK_INTERVAL";
    public static final String OIV_SHAPE_TYPE = "OIV_SHAPE_TYPE";
    public static final String OIV_SHARE_GEOM_MUTEX = "OIV_SHARE_GEOM_MUTEX";
    public static final String OIV_SHARE_LISTS = "OIV_SHARE_LISTS";
    public static final String OIV_STROKE_FONT_PATH = "OIV_STROKE_FONT_PATH";
    public static final String OIV_TEXTURE_BORDER_CLAMP_ENABLE = "OIV_TEXTURE_BORDER_CLAMP_ENABLE";
    public static final String OIV_TEXTURE_QUALITY = "OIV_TEXTURE_QUALITY";
    public static final String OIV_TEXTURED_TEXT_NO_MIPMAP = "OIV_TEXTURED_TEXT_NO_MIPMAP";
    public static final String OIV_TRACKER_DIRECT_MODE = "OIV_TRACKER_DIRECT_MODE";
    public static final String OIV_TRANSPARENCY_TYPE = "OIV_TRANSPARENCY_TYPE";
    public static final String OIV_UPDATE_AREA_COMPAT = "OIV_UPDATE_AREA_COMPAT";
    public static final String OIV_USE_NPOT = "OIV_USE_NPOT";
    public static final String OIV_USE_VOLUMEPRO = "OIV_USE_VOLUMEPRO";
    public static final String OIV_VERTEX_ATTRIBS = "OIV_VERTEX_ATTRIBS";
    public static final String OIV_VERTEX_ORDERING = "OIV_VERTEX_ORDERING";
    public static final String OIV_WINDING_TYPE = "OIV_WINDING_TYPE";
    public static final String OIV_ZERO_AREA_CHECK = "OIV_ZERO_AREA_CHECK";
    public static final String SO_DRAGGER_DIR = "SO_DRAGGER_DIR";
    public static final String SCALEVIZ_CLUSTERCOM = "SCALEVIZ_CLUSTERCOM";
    public static final String SCALEVIZ_CONFIG_FILE = "SCALEVIZ_CONFIG_FILE";
    public static final String SCALEVIZ_CONNECT_TIMEOUT = "SCALEVIZ_CONNECT_TIMEOUT";
    public static final String SCALEVIZ_OIRU_DISPLAY = "SCALEVIZ_OIRU_DISPLAY";
    public static final String SCALEVIZ_OIRU_PATH = "SCALEVIZ_OIRU_PATH";
    public static final String SCALEVIZD_RESOURCES_FILE = "SCALEVIZD_RESOURCES_FILE";
    public static final String MESHVIZ_POLYGON_OFFSET = "MESHVIZ_POLYGON_OFFSET";
    public static final String MESHVIZ_OCTREE_CACHE_CELLBBOX = "MESHVIZ_OCTREE_CACHE_CELLBBOX";
    public static final String MESHVIZ_OCTREE_MAX_DEPTH = "MESHVIZ_OCTREE_MAX_DEPTH";
    public static final String MESHVIZ_OCTREE_MAX_CELL_PER_TILE = "MESHVIZ_OCTREE_MAX_CELL_PER_TILE";
    @Deprecated
    public static final String TGS_LICENSE_DEBUG = "TGS_LICENSE_DEBUG";
    @Deprecated
    public static final String TGS_LICENSE_FILE = "TGS_LICENSE_FILE";
    @Deprecated
    public static final String VSG_LICENSE_DEBUG = "VSG_LICENSE_DEBUG";
    public static final String OIV_LICENSE_DEBUG = "OIV_LICENSE_DEBUG";
    public static final String VSG_LICENSE_FILE = "VSG_LICENSE_FILE";
    public static final String OIV_JAVA_VERBOSE_LEVEL = "OIV_JAVA_VERBOSE_LEVEL";
    public static final String OIV_JAVA_LOAD_DEBUG_NATIVE_LIBRARIES = "OIV_JAVA_LOAD_DEBUG_NATIVE_LIBRARIES";
    public static final String OIVJHOME = "OIVJHOME";
    public static final String OIV_HELP_URL = "OIV_HELP_URL";
    public static final String OIV_LIBRARY_PATH = "OIV_LIBRARY_PATH";
    private static Properties m_properties;

    static void initNativeEnvironment() {
        String[] stringArray;
        for (String string : stringArray = m_properties.keySet().toArray(new String[m_properties.size()])) {
            SoPreferences.setValueNativ(string, m_properties.getProperty(string));
        }
        String string = m_properties.getProperty("java.library.path", "") + File.pathSeparatorChar + m_properties.getProperty(OIV_LIBRARY_PATH, "");
        if (System.getProperty("os.name").startsWith("Windows")) {
            SoPreferences.setValueNativ("PATH", string);
        } else if (System.getProperty("os.name").startsWith("Mac OS X")) {
            SoPreferences.setValueNativ("DYLD_LIBRARY_PATH", string);
        } else {
            SoPreferences.setValueNativ("LD_LIBRARY_PATH", string);
        }
    }

    public static String getValue(String string) {
        if (string == null) {
            return null;
        }
        String string2 = m_properties.getProperty(string);
        if (string2 == null) {
            string2 = SoLockManager.isNativeLoaded() ? SoPreferences.getValueNativ(string) : System.getenv(string);
        }
        return string2;
    }

    private static native String getValueNativ(String var0);

    public static String getValue(String string, String string2) {
        String string3 = SoPreferences.getValue(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public static boolean getBoolean(String string, boolean bl) {
        String string2 = SoPreferences.getValue(string);
        if (string2 != null) {
            if (string2.toLowerCase().equals("true")) {
                return true;
            }
            if (string2.toLowerCase().equals("false")) {
                return false;
            }
            if (string2.equals("1")) {
                return true;
            }
            if (string2.equals("0")) {
                return false;
            }
        }
        return bl;
    }

    public static int getInteger(String string, int n) {
        String string2 = SoPreferences.getValue(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    public static long getLong(String string, long l) {
        String string2 = SoPreferences.getValue(string);
        if (string2 != null) {
            return Long.parseLong(string2);
        }
        return l;
    }

    public static float getFloat(String string, float f) {
        String string2 = SoPreferences.getValue(string);
        if (string2 != null) {
            return Float.parseFloat(string2);
        }
        return f;
    }

    public static double getDouble(String string, double d) {
        String string2 = SoPreferences.getValue(string);
        if (string2 != null) {
            return Double.parseDouble(string2);
        }
        return d;
    }

    public static void setValue(String string, String string2) {
        m_properties.setProperty(string, string2);
        if (SoLockManager.isNativeLoaded()) {
            SoPreferences.setValueNativ(string, string2);
        }
    }

    private static native void setValueNativ(String var0, String var1);

    static {
        String string;
        Object object;
        Properties properties = new Properties();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("com.openinventor.inventor.properties");
        if (inputStream == null) {
            System.out.println("Properties file not found... Starting with defaults.");
        } else {
            try {
                properties.load(inputStream);
            }
            catch (Exception exception) {
                System.err.println("Error while loading properties... Starting with defaults.");
                properties.clear();
            }
        }
        Properties properties2 = new Properties();
        properties2.setProperty("SCALEVIZ_DISABLE_GUI", "1");
        String string2 = System.getProperty(OIVJHOME);
        if (string2 == null) {
            string2 = properties.getProperty(OIVJHOME);
        }
        if (string2 == null) {
            string2 = System.getenv(OIVJHOME);
        }
        if (string2 == null) {
            System.out.println("Warning: OIVJHOME not set... some default properties can not be set properly.");
        } else {
            Object object2;
            properties2.setProperty(IVVR_SHADERS_PATH, string2 + "/data/volumeviz/shaders");
            properties2.setProperty("OIVHOME", string2);
            properties2.setProperty(OIV_FONT_PATH, string2 + "/data/fonts");
            properties2.setProperty(OIV_MATERIALS_PATH, string2 + "/data/materials");
            properties2.setProperty(OIV_PSFONT_PATH, string2 + "/data/fonts");
            properties2.setProperty(OIV_STROKE_FONT_PATH, string2 + "/data/fonts");
            properties2.setProperty(SO_DRAGGER_DIR, string2 + "/data/draggerDefaults");
            properties2.setProperty(SCALEVIZ_OIRU_PATH, string2 + "/jre/bin");
            object = Arrays.asList("/bin", "/lib/i386", "/lib/amd64", "/lib/sparc", "/lib/sparcv9", "/lib");
            String object3 = null;
            try {
                String string3 = System.getProperty("sun.boot.library.path");
                object2 = System.getProperty("java.home");
                if (!string3.startsWith((String)object2)) {
                    throw new Exception();
                }
                String string4 = string3.substring(((String)object2).length()).replace(File.separatorChar, '/');
                if (!object.contains(string4)) {
                    throw new Exception();
                }
                properties2.setProperty(OIV_LIBRARY_PATH, string2 + "/jre" + string4);
            }
            catch (Exception exception) {
                System.out.println("Warning: filling OIV_LIBRARY_PATH with defaults.");
                object2 = object3 != null ? string2 + "/jre" + object3 : new String();
                Object object4 = object.iterator();
                while (object4.hasNext()) {
                    string = (String)object4.next();
                    object2 = (String)object2 + File.pathSeparator + string2 + "/jre" + string;
                }
                properties2.setProperty(OIV_LIBRARY_PATH, (String)object2);
            }
            properties2.setProperty("U3D_LIBDIR", properties2.getProperty(OIV_LIBRARY_PATH));
        }
        m_properties = new Properties();
        m_properties.putAll((Map<?, ?>)properties2);
        try {
            object = m_properties.keySet().toArray(new String[m_properties.size()]);
            for (Object object4 : object) {
                string = System.getenv((String)object4);
                if (string == null) continue;
                m_properties.setProperty((String)object4, string);
            }
        }
        catch (SecurityException securityException) {
            System.out.println("Warning: can not retrieve system environment.");
        }
        m_properties.putAll((Map<?, ?>)properties);
        try {
            m_properties.putAll((Map<?, ?>)System.getProperties());
        }
        catch (SecurityException securityException) {
            System.out.println("Warning: can not retrieve system properties.");
        }
        object = m_properties.keySet().toArray(new String[m_properties.size()]);
        for (Object object4 : object) {
            if (!((String)object4).startsWith("3DMSJ_")) continue;
            string = new String("OIV_" + ((String)object4).substring(6));
            if (!m_properties.containsKey(string)) {
                m_properties.setProperty(string, m_properties.getProperty((String)object4));
                continue;
            }
            System.out.println("Warning: " + (String)object4 + " is overidden by" + string + ".");
        }
    }
}

