/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.SoSceneManager;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Vector;

public abstract class SoAction
extends Inventor {
    private SoSceneManager m_mgr_setSceneManager;

    private static native void setPipeIdImpl(long var0, int var2);

    private static native void setUpStateImpl(long var0);

    private static native int getDistribModeImpl(long var0);

    private static native void forwardTraversalImpl1(long var0, long var2);

    private static native int getPipeIdImpl(long var0);

    private static native void forwardTraversalImpl(long var0, long var2);

    private static native boolean isBeingAppliedImpl(long var0);

    private static native long getSceneManagerImpl(long var0);

    private static native boolean preDelayedTraversalImpl(long var0);

    private static native void setSceneManagerImpl(long var0, long var2);

    private static native int getWhatAppliedToImpl(long var0);

    private static native boolean isLastPathListAppliedToImpl(long var0);

    private static native long[] getOriginalPathListAppliedToImpl(long var0);

    private static native void traverseImpl(long var0, long var2);

    private static native long[] getPathListAppliedToImpl(long var0);

    private static native boolean hasTerminatedImpl(long var0);

    private static native long getPathAppliedToImpl(long var0);

    private static native long getCurPathImpl(long var0);

    private static native long getNodeAppliedToImpl(long var0);

    private static native long getStateImpl(long var0);

    private static native void postDelayedTraversalImpl(long var0);

    private static native int getPathCodeImpl(long var0, Object[] var2);

    private static native void invalidateStateImpl(long var0);

    private static native void clearApplyResultImpl(long var0);

    private static native void applyImpl1(long var0, long var2);

    private static native void applyImpl(long var0, long var2);

    private static native void stopActionInBranchImpl(long var0);

    private static native void resetContinueActionInBranchFlagImpl(long var0);

    private static native void useAlternateRepImpl(long var0, boolean var2);

    private static native boolean getContinueActionInBranchFlagImpl(long var0);

    private static native void nullActionImpl(long var0, long var2);

    private static native boolean isUsingAlternateRepImpl(long var0);

    protected SoAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    static native String getClassTypeId();

    public void traverse(SoNode soNode) {
        SoAction.traverseImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public Vector<SoPath> getOriginalPathListAppliedTo() {
        Vector<SoPath> vector = null;
        vector = SoAction.toVector(SoPath.class, SoAction.getOriginalPathListAppliedToImpl(this.getNativeResourceHandle()));
        return vector;
    }

    public void useAlternateRep(boolean bl) {
        SoAction.useAlternateRepImpl(this.getNativeResourceHandle(), bl);
    }

    public boolean hasTerminated() {
        return SoAction.hasTerminatedImpl(this.getNativeResourceHandle());
    }

    public Vector<SoPath> getPathListAppliedTo() {
        Vector<SoPath> vector = null;
        vector = SoAction.toVector(SoPath.class, SoAction.getPathListAppliedToImpl(this.getNativeResourceHandle()));
        return vector;
    }

    public SoPath getCurPath() {
        return ObjectManager.getManagedObjectFor(SoPath.class, SoAction.getCurPathImpl(this.getNativeResourceHandle()));
    }

    public void resetContinueActionInBranchFlag() {
        SoAction.resetContinueActionInBranchFlagImpl(this.getNativeResourceHandle());
    }

    public boolean isLastPathListAppliedTo() {
        return SoAction.isLastPathListAppliedToImpl(this.getNativeResourceHandle());
    }

    public void apply(SoNode soNode) {
        SoAction.applyImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void apply(SoPath soPath) {
        SoAction.applyImpl1(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void clearApplyResult() {
        SoAction.clearApplyResultImpl(this.getNativeResourceHandle());
    }

    public void invalidateState() {
        SoAction.invalidateStateImpl(this.getNativeResourceHandle());
    }

    public void stopActionInBranch() {
        SoAction.stopActionInBranchImpl(this.getNativeResourceHandle());
    }

    public boolean getContinueActionInBranchFlag() {
        return SoAction.getContinueActionInBranchFlagImpl(this.getNativeResourceHandle());
    }

    public SoPath getPathAppliedTo() {
        return ObjectManager.getManagedObjectFor(SoPath.class, SoAction.getPathAppliedToImpl(this.getNativeResourceHandle()));
    }

    public void forwardTraversal(SoNode soNode) {
        SoAction.forwardTraversalImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public boolean preDelayedTraversal() {
        return SoAction.preDelayedTraversalImpl(this.getNativeResourceHandle());
    }

    public SoSceneManager getSceneManager() {
        return ObjectManager.getManagedObjectFor(SoSceneManager.class, SoAction.getSceneManagerImpl(this.getNativeResourceHandle()));
    }

    public void postDelayedTraversal() {
        SoAction.postDelayedTraversalImpl(this.getNativeResourceHandle());
    }

    public void setSceneManager(SoSceneManager soSceneManager) {
        this.m_mgr_setSceneManager = soSceneManager;
        SoAction.setSceneManagerImpl(this.getNativeResourceHandle(), soSceneManager != null ? soSceneManager.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static void nullAction(SoAction soAction, SoNode soNode) {
        SoAction.nullActionImpl(soAction != null ? soAction.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public boolean isUsingAlternateRep() {
        return SoAction.isUsingAlternateRepImpl(this.getNativeResourceHandle());
    }

    public PathIndices getPathCode() {
        PathIndices pathIndices = new PathIndices();
        Object[] objectArray = new ByteBuffer[1];
        pathIndices.returnedValue = IntegerValuedEnumHelper.fromIntValue(PathCodes.class, SoAction.getPathCodeImpl(this.getNativeResourceHandle(), objectArray));
        if (objectArray[0] != null) {
            ((ByteBuffer)objectArray[0]).order(ByteOrder.nativeOrder());
        }
        pathIndices.indices = objectArray[0] != null ? ((ByteBuffer)objectArray[0]).asIntBuffer() : null;
        return pathIndices;
    }

    public boolean isBeingApplied() {
        return SoAction.isBeingAppliedImpl(this.getNativeResourceHandle());
    }

    public SoState getState() {
        return ObjectManager.getManagedObjectFor(SoState.class, SoAction.getStateImpl(this.getNativeResourceHandle()));
    }

    public SoNode getNodeAppliedTo() {
        return ObjectManager.getManagedObjectFor(SoNode.class, SoAction.getNodeAppliedToImpl(this.getNativeResourceHandle()));
    }

    public void setUpState() {
        SoAction.setUpStateImpl(this.getNativeResourceHandle());
    }

    public AppliedCodes getWhatAppliedTo() {
        return IntegerValuedEnumHelper.fromIntValue(AppliedCodes.class, SoAction.getWhatAppliedToImpl(this.getNativeResourceHandle()));
    }

    public void setPipeId(int n) {
        SoAction.setPipeIdImpl(this.getNativeResourceHandle(), n);
    }

    public DistribModes getDistribMode() {
        return IntegerValuedEnumHelper.fromIntValue(DistribModes.class, SoAction.getDistribModeImpl(this.getNativeResourceHandle()));
    }

    public int getPipeId() {
        return SoAction.getPipeIdImpl(this.getNativeResourceHandle());
    }

    public void forwardTraversal(SoPath soPath) {
        SoAction.forwardTraversalImpl1(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static class PathIndices {
        public IntBuffer indices;
        public PathCodes returnedValue;

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum PathCodes implements IntegerValuedEnum
    {
        NO_PATH(PathCodes.getNOPATH()),
        IN_PATH(PathCodes.getINPATH()),
        BELOW_PATH(PathCodes.getBELOWPATH()),
        OFF_PATH(PathCodes.getOFFPATH());

        private int value;

        private static native int getNOPATHNative();

        private PathCodes(int n2) {
            this.value = n2;
        }

        private static int getOFFPATH() {
            JniInitializer.checkInit();
            return PathCodes.getOFFPATHNative();
        }

        private static native int getOFFPATHNative();

        private static int getBELOWPATH() {
            JniInitializer.checkInit();
            return PathCodes.getBELOWPATHNative();
        }

        private static native int getBELOWPATHNative();

        private static int getINPATH() {
            JniInitializer.checkInit();
            return PathCodes.getINPATHNative();
        }

        private static native int getINPATHNative();

        private static int getNOPATH() {
            JniInitializer.checkInit();
            return PathCodes.getNOPATHNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static PathCodes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(PathCodes.class, n);
        }
    }

    public static enum AppliedCodes implements IntegerValuedEnum
    {
        NODE(AppliedCodes.getNODE()),
        PATH(AppliedCodes.getPATH()),
        PATH_LIST(AppliedCodes.getPATHLIST());

        private int value;

        private static native int getNODENative();

        private AppliedCodes(int n2) {
            this.value = n2;
        }

        private static int getPATHLIST() {
            JniInitializer.checkInit();
            return AppliedCodes.getPATHLISTNative();
        }

        private static native int getPATHLISTNative();

        private static int getPATH() {
            JniInitializer.checkInit();
            return AppliedCodes.getPATHNative();
        }

        private static native int getPATHNative();

        private static int getNODE() {
            JniInitializer.checkInit();
            return AppliedCodes.getNODENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static AppliedCodes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(AppliedCodes.class, n);
        }
    }

    public static enum DistribModes implements IntegerValuedEnum
    {
        LOCAL_ONLY(DistribModes.getLOCALONLY()),
        CLUSTER_ONLY(DistribModes.getCLUSTERONLY()),
        ALL(DistribModes.getALL());

        private int value;

        private static native int getLOCALONLYNative();

        private DistribModes(int n2) {
            this.value = n2;
        }

        private static int getALL() {
            JniInitializer.checkInit();
            return DistribModes.getALLNative();
        }

        private static native int getALLNative();

        private static int getCLUSTERONLY() {
            JniInitializer.checkInit();
            return DistribModes.getCLUSTERONLYNative();
        }

        private static native int getCLUSTERONLYNative();

        private static int getLOCALONLY() {
            JniInitializer.checkInit();
            return DistribModes.getLOCALONLYNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static DistribModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(DistribModes.class, n);
        }
    }
}

