/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbMatrix;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.SbVec2i32;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbVec4f;
import com.openinventor.inventor.SbViewVolume;
import com.openinventor.inventor.SoPrimitiveVertex;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.elements.SoDecimationTypeElement;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.misc.callbacks.SoCallbackActionCB;
import com.openinventor.inventor.misc.callbacks.SoLineSegmentCB;
import com.openinventor.inventor.misc.callbacks.SoPointCB;
import com.openinventor.inventor.misc.callbacks.SoTriangleCB;
import com.openinventor.inventor.nodes.SoComplexity;
import com.openinventor.inventor.nodes.SoDrawStyle;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoMaterialBinding;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoNormalBinding;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoShape;
import com.openinventor.inventor.nodes.SoShapeHints;
import com.openinventor.inventor.nodes.SoTexture;
import com.openinventor.inventor.nodes.SoTexture2Transform;
import com.openinventor.inventor.nodes.SoTextureCoordinateBinding;
import com.openinventor.inventor.nodes.SoUnits;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class SoCallbackAction
extends SoAction {
    private Set<SoCallbackActionCB> m_preTailCBList = new HashSet<SoCallbackActionCB>();
    private Set<SoCallbackActionCB> m_postTailCBList = new HashSet<SoCallbackActionCB>();
    private Set<SoCallbackActionCB> m_preCBList = new HashSet<SoCallbackActionCB>();
    private Set<SoCallbackActionCB> m_postCBList = new HashSet<SoCallbackActionCB>();
    private Set<SoTriangleCB> m_triangleCBList = new HashSet<SoTriangleCB>();
    private Set<SoLineSegmentCB> m_lineCBList = new HashSet<SoLineSegmentCB>();
    private Set<SoPointCB> m_pointCBList = new HashSet<SoPointCB>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreTailCallback(SoCallbackActionCB soCallbackActionCB, Object object) {
        if (soCallbackActionCB != null) {
            Set<SoCallbackActionCB> set = this.m_preTailCBList;
            synchronized (set) {
                this.m_preTailCBList.add(soCallbackActionCB);
                SoCallbackAction.addPreTailCallbackImpl(this.getNativeResourceHandle(), soCallbackActionCB, object, soCallbackActionCB.getNativeResourceHandle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostTailCallback(SoCallbackActionCB soCallbackActionCB, Object object) {
        if (soCallbackActionCB != null) {
            Set<SoCallbackActionCB> set = this.m_postTailCBList;
            synchronized (set) {
                this.m_postTailCBList.add(soCallbackActionCB);
                SoCallbackAction.addPostTailCallbackImpl(this.getNativeResourceHandle(), soCallbackActionCB, object, soCallbackActionCB.getNativeResourceHandle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreCallback(Class<? extends SoNode> clazz, SoCallbackActionCB soCallbackActionCB, Object object) {
        if (soCallbackActionCB != null) {
            Set<SoCallbackActionCB> set = this.m_preCBList;
            synchronized (set) {
                this.m_preCBList.add(soCallbackActionCB);
                SoCallbackAction.addPreCallbackImpl(this.getNativeResourceHandle(), clazz.getName(), soCallbackActionCB, object, soCallbackActionCB.getNativeResourceHandle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostCallback(Class<? extends SoNode> clazz, SoCallbackActionCB soCallbackActionCB, Object object) {
        if (soCallbackActionCB != null) {
            Set<SoCallbackActionCB> set = this.m_postCBList;
            synchronized (set) {
                this.m_postCBList.add(soCallbackActionCB);
                SoCallbackAction.addPostCallbackImpl(this.getNativeResourceHandle(), clazz.getName(), soCallbackActionCB, object, soCallbackActionCB.getNativeResourceHandle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTriangleCallback(Class<? extends SoNode> clazz, SoTriangleCB soTriangleCB, Object object) {
        if (soTriangleCB != null) {
            Set<SoTriangleCB> set = this.m_triangleCBList;
            synchronized (set) {
                this.m_triangleCBList.add(soTriangleCB);
                SoCallbackAction.addTriangleCallbackImpl(this.getNativeResourceHandle(), clazz.getName(), soTriangleCB, object, soTriangleCB.getNativeResourceHandle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineSegmentCallback(Class<? extends SoNode> clazz, SoLineSegmentCB soLineSegmentCB, Object object) {
        if (soLineSegmentCB != null) {
            Set<SoLineSegmentCB> set = this.m_lineCBList;
            synchronized (set) {
                this.m_lineCBList.add(soLineSegmentCB);
                SoCallbackAction.addLineSegmentCallbackImpl(this.getNativeResourceHandle(), clazz.getName(), soLineSegmentCB, object, soLineSegmentCB.getNativeResourceHandle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPointCallback(Class<? extends SoNode> clazz, SoPointCB soPointCB, Object object) {
        if (soPointCB != null) {
            Set<SoPointCB> set = this.m_pointCBList;
            synchronized (set) {
                this.m_pointCBList.add(soPointCB);
                SoCallbackAction.addPointCallbackImpl(this.getNativeResourceHandle(), clazz.getName(), soPointCB, object, soPointCB.getNativeResourceHandle());
            }
        }
    }

    private static native void addPreCallbackImpl(long var0, String var2, SoCallbackActionCB var3, Object var4, long var5);

    private static native void addPostCallbackImpl(long var0, String var2, SoCallbackActionCB var3, Object var4, long var5);

    private static native void addTriangleCallbackImpl(long var0, String var2, SoTriangleCB var3, Object var4, long var5);

    private static native void addLineSegmentCallbackImpl(long var0, String var2, SoLineSegmentCB var3, Object var4, long var5);

    private static native void addPointCallbackImpl(long var0, String var2, SoPointCB var3, Object var4, long var5);

    private static native void addPreTailCallbackImpl(long var0, SoCallbackActionCB var2, Object var3, long var4);

    private static native void addPostTailCallbackImpl(long var0, SoCallbackActionCB var2, Object var3, long var4);

    private static native int getNormalBindingImpl(long var0);

    private static native int getPickStyleImpl(long var0);

    private static native int getNumProfileCoordinatesImpl(long var0);

    private static native void getViewVolumeImpl(long var0, long var2);

    private static native void getProfileCoordinate2Impl(long var0, int var2, float[] var3);

    private static native void getViewingMatrixImpl(long var0, float[] var2);

    private static native void getProfileCoordinate3Impl(long var0, int var2, float[] var3);

    private static native void getProjectionMatrixImpl(long var0, float[] var2);

    private static native int getSwitchImpl(long var0);

    private static native byte[] getTextureImageImpl(long var0, int[] var2, int[] var3);

    private static native void getMaterialImpl(long var0, float[] var2, float[] var3, float[] var4, float[] var5, float[] var6, float[] var7, int var8);

    private static native int getMaterialBindingImpl(long var0);

    private static native int getTransparencyTypeImpl(long var0);

    private static native boolean isCallbackAllImpl(long var0);

    private static native int getNumNormalsImpl(long var0);

    private static native void setCallbackAllImpl(long var0, boolean var2);

    private static native void getNormalImpl(long var0, int var2, float[] var3);

    private static native long[] getProfileImpl(long var0);

    private static native int getTextureModelImpl(long var0);

    private static native void getTextureCoordinate2Impl(long var0, int var2, float[] var3);

    private static native long getTextureTransformNodeImpl(long var0);

    private static native void getTextureCoordinate4Impl(long var0, int var2, float[] var3);

    private static native void getTextureMatrixImpl(long var0, float[] var2);

    private static native int getTextureCoordinateBindingImpl(long var0);

    private static native String getTextureFileNameImpl(long var0);

    private static native void getTextureBlendColorImpl(long var0, float[] var2);

    private static native int getNumTextureCoordinatesImpl(long var0);

    private static native float getFocalDistanceImpl(long var0);

    private static native int getVertexOrderingImpl(long var0);

    private static native int getUnitsImpl(long var0);

    private static native int getShapeTypeImpl(long var0);

    private static native void getModelMatrixImpl(long var0, float[] var2);

    private static native int getFaceTypeImpl(long var0);

    private static native int getTextureWrapTImpl(long var0);

    private static native float getCreaseAngleImpl(long var0);

    private static native int getTextureWrapSImpl(long var0);

    private static native void getLightAttenuationImpl(long var0, float[] var2);

    private static native float getDecimationPercentageImpl(long var0);

    private static native int getDrawStyleImpl(long var0);

    private static native boolean shouldGeneratePrimitivesImpl(long var0, long var2);

    private static native short getLinePatternImpl(long var0);

    private static native void invokePointCallbacksImpl(long var0, long var2, long[] var4);

    private static native int getLinePatternScaleFactorImpl(long var0);

    private static native int getDecimationTypeImpl(long var0);

    private static native long ctorImpl();

    private static native float getComplexityImpl(long var0);

    private static native int getComplexityTypeImpl(long var0);

    private static native int getNumCoordinatesImpl(long var0);

    private static native void getCoordinate3Impl(long var0, int var2, float[] var3);

    private static native void getCoordinate4Impl(long var0, int var2, float[] var3);

    private static native void invokeLineSegmentCallbacksImpl(long var0, long var2, long[] var4, long[] var5);

    private static native void enableElementImpl(String var0, int var1);

    private static native int getLightModelImpl(long var0);

    private static native int getFontRenderStyleImpl(long var0);

    private static native int getCurrentResponseImpl(long var0);

    private static native float getFontSizeImpl(long var0);

    private static native void invokePreCallbacksImpl(long var0, long var2);

    private static native void invokeTriangleCallbacksImpl(long var0, long var2, long[] var4, long[] var5, long[] var6);

    private static native float getPointSizeImpl(long var0);

    private static native void invokePostCallbacksImpl(long var0, long var2);

    private static native float getLineWidthImpl(long var0);

    private static native String getFontNameImpl(long var0);

    protected SoCallbackAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public Material getMaterial() {
        return this.getMaterial(0);
    }

    public SoFont.RenderStyles getFontRenderStyle() {
        return IntegerValuedEnumHelper.fromIntValue(SoFont.RenderStyles.class, SoCallbackAction.getFontRenderStyleImpl(this.getNativeResourceHandle()));
    }

    public void invokePreCallbacks(SoNode soNode) {
        SoCallbackAction.invokePreCallbacksImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public float getFontSize() {
        return SoCallbackAction.getFontSizeImpl(this.getNativeResourceHandle());
    }

    public void invokePostCallbacks(SoNode soNode) {
        SoCallbackAction.invokePostCallbacksImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public String getFontName() {
        return SoCallbackAction.getFontNameImpl(this.getNativeResourceHandle());
    }

    public void invokeTriangleCallbacks(SoShape soShape, SoPrimitiveVertex[] soPrimitiveVertexArray, SoPrimitiveVertex[] soPrimitiveVertexArray2, SoPrimitiveVertex[] soPrimitiveVertexArray3) {
        long[] lArray = null;
        if (soPrimitiveVertexArray != null) {
            lArray = new long[soPrimitiveVertexArray.length];
            for (int i = 0; i < soPrimitiveVertexArray.length; ++i) {
                lArray[i] = soPrimitiveVertexArray[i] != null ? soPrimitiveVertexArray[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        long[] lArray2 = null;
        if (soPrimitiveVertexArray2 != null) {
            lArray2 = new long[soPrimitiveVertexArray2.length];
            for (int i = 0; i < soPrimitiveVertexArray2.length; ++i) {
                lArray2[i] = soPrimitiveVertexArray2[i] != null ? soPrimitiveVertexArray2[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        long[] lArray3 = null;
        if (soPrimitiveVertexArray3 != null) {
            lArray3 = new long[soPrimitiveVertexArray3.length];
            for (int i = 0; i < soPrimitiveVertexArray3.length; ++i) {
                lArray3[i] = soPrimitiveVertexArray3[i] != null ? soPrimitiveVertexArray3[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        SoCallbackAction.invokeTriangleCallbacksImpl(this.getNativeResourceHandle(), soShape != null ? soShape.getNativeResourceHandle() : Inventor.ZeroHandle, (long[])(soPrimitiveVertexArray != null ? lArray : null), (long[])(soPrimitiveVertexArray2 != null ? lArray2 : null), (long[])(soPrimitiveVertexArray3 != null ? lArray3 : null));
    }

    public Responses getCurrentResponse() {
        return IntegerValuedEnumHelper.fromIntValue(Responses.class, SoCallbackAction.getCurrentResponseImpl(this.getNativeResourceHandle()));
    }

    public SoGLRenderAction.TransparencyTypes getTransparencyType() {
        return IntegerValuedEnumHelper.fromIntValue(SoGLRenderAction.TransparencyTypes.class, SoCallbackAction.getTransparencyTypeImpl(this.getNativeResourceHandle()));
    }

    public SoMaterialBinding.Bindings getMaterialBinding() {
        return IntegerValuedEnumHelper.fromIntValue(SoMaterialBinding.Bindings.class, SoCallbackAction.getMaterialBindingImpl(this.getNativeResourceHandle()));
    }

    public Material getMaterial(int n) {
        Material material = new Material();
        SbColor sbColor = new SbColor();
        SbColor sbColor2 = new SbColor();
        SbColor sbColor3 = new SbColor();
        SbColor sbColor4 = new SbColor();
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        SoCallbackAction.getMaterialImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null, sbColor2 != null ? sbColor2.array : null, sbColor3 != null ? sbColor3.array : null, sbColor4 != null ? sbColor4.array : null, fArray, fArray2, n);
        material.ambient = sbColor;
        material.diffuse = sbColor2;
        material.specular = sbColor3;
        material.emission = sbColor4;
        material.shininess = fArray[0];
        material.transparency = fArray2[0];
        return material;
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        SoCallbackAction.enableElementImpl(string, n);
    }

    public SbVec3f getLightAttenuation() {
        SbVec3f sbVec3f = new SbVec3f();
        SoCallbackAction.getLightAttenuationImpl(this.getNativeResourceHandle(), sbVec3f.array);
        return sbVec3f;
    }

    public SoLightModel.Models getLightModel() {
        return IntegerValuedEnumHelper.fromIntValue(SoLightModel.Models.class, SoCallbackAction.getLightModelImpl(this.getNativeResourceHandle()));
    }

    public float getPointSize() {
        return SoCallbackAction.getPointSizeImpl(this.getNativeResourceHandle());
    }

    public SoDecimationTypeElement.Types getDecimationType() {
        return IntegerValuedEnumHelper.fromIntValue(SoDecimationTypeElement.Types.class, SoCallbackAction.getDecimationTypeImpl(this.getNativeResourceHandle()));
    }

    public SbVec4f getCoordinate4(int n) {
        SbVec4f sbVec4f = new SbVec4f();
        SoCallbackAction.getCoordinate4Impl(this.getNativeResourceHandle(), n, sbVec4f.array);
        return sbVec4f;
    }

    public SbVec3f getCoordinate3(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        SoCallbackAction.getCoordinate3Impl(this.getNativeResourceHandle(), n, sbVec3f.array);
        return sbVec3f;
    }

    public int getNumCoordinates() {
        return SoCallbackAction.getNumCoordinatesImpl(this.getNativeResourceHandle());
    }

    public SoComplexity.Types getComplexityType() {
        return IntegerValuedEnumHelper.fromIntValue(SoComplexity.Types.class, SoCallbackAction.getComplexityTypeImpl(this.getNativeResourceHandle()));
    }

    public float getComplexity() {
        return SoCallbackAction.getComplexityImpl(this.getNativeResourceHandle());
    }

    public SoCallbackAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoCallbackAction.ctorImpl());
    }

    public float getDecimationPercentage() {
        return SoCallbackAction.getDecimationPercentageImpl(this.getNativeResourceHandle());
    }

    public void invokeLineSegmentCallbacks(SoShape soShape, SoPrimitiveVertex[] soPrimitiveVertexArray, SoPrimitiveVertex[] soPrimitiveVertexArray2) {
        long[] lArray = null;
        if (soPrimitiveVertexArray != null) {
            lArray = new long[soPrimitiveVertexArray.length];
            for (int i = 0; i < soPrimitiveVertexArray.length; ++i) {
                lArray[i] = soPrimitiveVertexArray[i] != null ? soPrimitiveVertexArray[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        long[] lArray2 = null;
        if (soPrimitiveVertexArray2 != null) {
            lArray2 = new long[soPrimitiveVertexArray2.length];
            for (int i = 0; i < soPrimitiveVertexArray2.length; ++i) {
                lArray2[i] = soPrimitiveVertexArray2[i] != null ? soPrimitiveVertexArray2[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        SoCallbackAction.invokeLineSegmentCallbacksImpl(this.getNativeResourceHandle(), soShape != null ? soShape.getNativeResourceHandle() : Inventor.ZeroHandle, (long[])(soPrimitiveVertexArray != null ? lArray : null), (long[])(soPrimitiveVertexArray2 != null ? lArray2 : null));
    }

    public float getLineWidth() {
        return SoCallbackAction.getLineWidthImpl(this.getNativeResourceHandle());
    }

    public void invokePointCallbacks(SoShape soShape, SoPrimitiveVertex[] soPrimitiveVertexArray) {
        long[] lArray = null;
        if (soPrimitiveVertexArray != null) {
            lArray = new long[soPrimitiveVertexArray.length];
            for (int i = 0; i < soPrimitiveVertexArray.length; ++i) {
                lArray[i] = soPrimitiveVertexArray[i] != null ? soPrimitiveVertexArray[i].getNativeResourceHandle() : Inventor.ZeroHandle;
            }
        }
        SoCallbackAction.invokePointCallbacksImpl(this.getNativeResourceHandle(), soShape != null ? soShape.getNativeResourceHandle() : Inventor.ZeroHandle, (long[])(soPrimitiveVertexArray != null ? lArray : null));
    }

    public int getLinePatternScaleFactor() {
        return SoCallbackAction.getLinePatternScaleFactorImpl(this.getNativeResourceHandle());
    }

    public boolean shouldGeneratePrimitives(SoShape soShape) {
        return SoCallbackAction.shouldGeneratePrimitivesImpl(this.getNativeResourceHandle(), soShape != null ? soShape.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public short getLinePattern() {
        return SoCallbackAction.getLinePatternImpl(this.getNativeResourceHandle());
    }

    public SoDrawStyle.Styles getDrawStyle() {
        return IntegerValuedEnumHelper.fromIntValue(SoDrawStyle.Styles.class, SoCallbackAction.getDrawStyleImpl(this.getNativeResourceHandle()));
    }

    public int getNumNormals() {
        return SoCallbackAction.getNumNormalsImpl(this.getNativeResourceHandle());
    }

    public SoTexture.WrapType getTextureWrapS() {
        return IntegerValuedEnumHelper.fromIntValue(SoTexture.WrapType.class, SoCallbackAction.getTextureWrapSImpl(this.getNativeResourceHandle()));
    }

    public int getNumTextureCoordinates() {
        return SoCallbackAction.getNumTextureCoordinatesImpl(this.getNativeResourceHandle());
    }

    public SoTexture.WrapType getTextureWrapT() {
        return IntegerValuedEnumHelper.fromIntValue(SoTexture.WrapType.class, SoCallbackAction.getTextureWrapTImpl(this.getNativeResourceHandle()));
    }

    public float getCreaseAngle() {
        return SoCallbackAction.getCreaseAngleImpl(this.getNativeResourceHandle());
    }

    public SbMatrix getModelMatrix() {
        SbMatrix sbMatrix = new SbMatrix();
        SoCallbackAction.getModelMatrixImpl(this.getNativeResourceHandle(), sbMatrix.array);
        return sbMatrix;
    }

    public SoShapeHints.FaceTypes getFaceType() {
        return IntegerValuedEnumHelper.fromIntValue(SoShapeHints.FaceTypes.class, SoCallbackAction.getFaceTypeImpl(this.getNativeResourceHandle()));
    }

    public SoUnits.UnitsType getUnits() {
        return IntegerValuedEnumHelper.fromIntValue(SoUnits.UnitsType.class, SoCallbackAction.getUnitsImpl(this.getNativeResourceHandle()));
    }

    public SbVec2f getTextureCoordinate2(int n) {
        SbVec2f sbVec2f = new SbVec2f();
        SoCallbackAction.getTextureCoordinate2Impl(this.getNativeResourceHandle(), n, sbVec2f.array);
        return sbVec2f;
    }

    public TextureImage getTextureImage() {
        TextureImage textureImage = new TextureImage();
        SbVec2i32 sbVec2i32 = new SbVec2i32();
        int[] nArray = new int[1];
        textureImage.buffer = SoCallbackAction.getTextureImageImpl(this.getNativeResourceHandle(), sbVec2i32 != null ? sbVec2i32.array : null, nArray);
        textureImage.size = sbVec2i32;
        textureImage.numComps = nArray[0];
        return textureImage;
    }

    public String getTextureFileName() {
        return SoCallbackAction.getTextureFileNameImpl(this.getNativeResourceHandle());
    }

    public SbColor getTextureBlendColor() {
        SbColor sbColor = new SbColor();
        SoCallbackAction.getTextureBlendColorImpl(this.getNativeResourceHandle(), sbColor.array);
        return sbColor;
    }

    public SbMatrix getTextureMatrix() {
        SbMatrix sbMatrix = new SbMatrix();
        SoCallbackAction.getTextureMatrixImpl(this.getNativeResourceHandle(), sbMatrix.array);
        return sbMatrix;
    }

    public SoTextureCoordinateBinding.Bindings getTextureCoordinateBinding() {
        return IntegerValuedEnumHelper.fromIntValue(SoTextureCoordinateBinding.Bindings.class, SoCallbackAction.getTextureCoordinateBindingImpl(this.getNativeResourceHandle()));
    }

    public SoTexture2Transform getTextureTransformNode() {
        return ObjectManager.getManagedObjectFor(SoTexture2Transform.class, SoCallbackAction.getTextureTransformNodeImpl(this.getNativeResourceHandle()));
    }

    public SoTexture.Models getTextureModel() {
        return IntegerValuedEnumHelper.fromIntValue(SoTexture.Models.class, SoCallbackAction.getTextureModelImpl(this.getNativeResourceHandle()));
    }

    public SoShapeHints.ShapeTypes getShapeType() {
        return IntegerValuedEnumHelper.fromIntValue(SoShapeHints.ShapeTypes.class, SoCallbackAction.getShapeTypeImpl(this.getNativeResourceHandle()));
    }

    public SoPickStyle.Styles getPickStyle() {
        return IntegerValuedEnumHelper.fromIntValue(SoPickStyle.Styles.class, SoCallbackAction.getPickStyleImpl(this.getNativeResourceHandle()));
    }

    public int getNumProfileCoordinates() {
        return SoCallbackAction.getNumProfileCoordinatesImpl(this.getNativeResourceHandle());
    }

    public int getSwitch() {
        return SoCallbackAction.getSwitchImpl(this.getNativeResourceHandle());
    }

    public SoNormalBinding.Bindings getNormalBinding() {
        return IntegerValuedEnumHelper.fromIntValue(SoNormalBinding.Bindings.class, SoCallbackAction.getNormalBindingImpl(this.getNativeResourceHandle()));
    }

    public void setCallbackAll(boolean bl) {
        SoCallbackAction.setCallbackAllImpl(this.getNativeResourceHandle(), bl);
    }

    public SbVec3f getNormal(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        SoCallbackAction.getNormalImpl(this.getNativeResourceHandle(), n, sbVec3f.array);
        return sbVec3f;
    }

    public boolean isCallbackAll() {
        return SoCallbackAction.isCallbackAllImpl(this.getNativeResourceHandle());
    }

    public SbVec2f getProfileCoordinate2(int n) {
        SbVec2f sbVec2f = new SbVec2f();
        SoCallbackAction.getProfileCoordinate2Impl(this.getNativeResourceHandle(), n, sbVec2f.array);
        return sbVec2f;
    }

    public float getFocalDistance() {
        return SoCallbackAction.getFocalDistanceImpl(this.getNativeResourceHandle());
    }

    public SoShapeHints.VertexOrderings getVertexOrdering() {
        return IntegerValuedEnumHelper.fromIntValue(SoShapeHints.VertexOrderings.class, SoCallbackAction.getVertexOrderingImpl(this.getNativeResourceHandle()));
    }

    public SbMatrix getProjectionMatrix() {
        SbMatrix sbMatrix = new SbMatrix();
        SoCallbackAction.getProjectionMatrixImpl(this.getNativeResourceHandle(), sbMatrix.array);
        return sbMatrix;
    }

    public Vector<SoNode> getProfile() {
        Vector<SoNode> vector = null;
        vector = SoCallbackAction.toVector(SoNode.class, SoCallbackAction.getProfileImpl(this.getNativeResourceHandle()));
        return vector;
    }

    public SbMatrix getViewingMatrix() {
        SbMatrix sbMatrix = new SbMatrix();
        SoCallbackAction.getViewingMatrixImpl(this.getNativeResourceHandle(), sbMatrix.array);
        return sbMatrix;
    }

    public SbVec3f getProfileCoordinate3(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        SoCallbackAction.getProfileCoordinate3Impl(this.getNativeResourceHandle(), n, sbVec3f.array);
        return sbVec3f;
    }

    public SbViewVolume getViewVolume() {
        SbViewVolume sbViewVolume = new SbViewVolume();
        SoCallbackAction.getViewVolumeImpl(this.getNativeResourceHandle(), sbViewVolume.getNativeResourceHandle());
        return sbViewVolume;
    }

    public SbVec4f getTextureCoordinate4(int n) {
        SbVec4f sbVec4f = new SbVec4f();
        SoCallbackAction.getTextureCoordinate4Impl(this.getNativeResourceHandle(), n, sbVec4f.array);
        return sbVec4f;
    }

    public static class Material {
        public SbColor ambient;
        public SbColor diffuse;
        public SbColor specular;
        public SbColor emission;
        public float shininess;
        public float transparency;

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum Responses implements IntegerValuedEnum
    {
        CONTINUE(Responses.getCONTINUE()),
        ABORT(Responses.getABORT()),
        PRUNE(Responses.getPRUNE());

        private int value;

        private static native int getCONTINUENative();

        private Responses(int n2) {
            this.value = n2;
        }

        private static int getPRUNE() {
            JniInitializer.checkInit();
            return Responses.getPRUNENative();
        }

        private static native int getPRUNENative();

        private static int getABORT() {
            JniInitializer.checkInit();
            return Responses.getABORTNative();
        }

        private static native int getABORTNative();

        private static int getCONTINUE() {
            JniInitializer.checkInit();
            return Responses.getCONTINUENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static Responses valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Responses.class, n);
        }
    }

    public static class TextureImage {
        public SbVec2i32 size;
        public int numComps;
        public byte[] buffer;

        static {
            JniInitializer.checkInit();
        }
    }
}

