/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;
import java.util.Vector;

public class SoSearchAction
extends SoAction {
    private static native void setNodeImpl(long var0, long var2);

    private static native void setFoundImpl(long var0);

    private static native String getNodeClassImpl(long var0);

    private static native void setNodeClassImpl(long var0, String var2, boolean var3);

    private static native void enableElementImpl(String var0, int var1);

    private static native String getNameImpl(long var0);

    private static native boolean isSearchingAllImpl(long var0);

    private static native long getPathImpl(long var0);

    private static native void setInterestImpl(long var0, int var2);

    private static native long[] getPathsImpl(long var0);

    private static native int getInterestImpl(long var0);

    private static native void setNameImpl(long var0, String var2);

    private static native void setSearchingAllImpl(long var0, boolean var2);

    private static native void resetImpl(long var0);

    private static native void setFindImpl(long var0, int var2);

    private static native long ctorImpl();

    private static native int getFindImpl(long var0);

    private static native void isSearchingExtendedClassImpl(long var0, boolean[] var2);

    private static native void addPathImpl(long var0, long var2);

    private static native long getNodeImpl(long var0);

    private static native boolean isFoundImpl(long var0);

    protected SoSearchAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void setNodeClass(Class<? extends Inventor> clazz) {
        this.setNodeClass(clazz, true);
    }

    public void reset() {
        SoSearchAction.resetImpl(this.getNativeResourceHandle());
    }

    public void setNode(SoNode soNode) {
        SoSearchAction.setNodeImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void addPath(SoPath soPath) {
        SoSearchAction.addPathImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoNode getNode() {
        return ObjectManager.getManagedObjectFor(SoNode.class, SoSearchAction.getNodeImpl(this.getNativeResourceHandle()));
    }

    public int getFind() {
        return SoSearchAction.getFindImpl(this.getNativeResourceHandle());
    }

    public void setFind(int n) {
        SoSearchAction.setFindImpl(this.getNativeResourceHandle(), n);
    }

    public boolean isSearchingExtendedClass() {
        boolean[] blArray = new boolean[1];
        SoSearchAction.isSearchingExtendedClassImpl(this.getNativeResourceHandle(), blArray);
        return blArray[0];
    }

    public SoSearchAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoSearchAction.ctorImpl());
    }

    public boolean isFound() {
        return SoSearchAction.isFoundImpl(this.getNativeResourceHandle());
    }

    public void setSearchingAll(boolean bl) {
        SoSearchAction.setSearchingAllImpl(this.getNativeResourceHandle(), bl);
    }

    public SoPath getPath() {
        return ObjectManager.getManagedObjectFor(SoPath.class, SoSearchAction.getPathImpl(this.getNativeResourceHandle()));
    }

    public Vector<SoPath> getPaths() {
        Vector<SoPath> vector = null;
        vector = SoSearchAction.toVector(SoPath.class, SoSearchAction.getPathsImpl(this.getNativeResourceHandle()));
        return vector;
    }

    public void setInterest(Interests interests) {
        SoSearchAction.setInterestImpl(this.getNativeResourceHandle(), interests.getValue());
    }

    public Interests getInterest() {
        return IntegerValuedEnumHelper.fromIntValue(Interests.class, SoSearchAction.getInterestImpl(this.getNativeResourceHandle()));
    }

    public void setName(String string) {
        SoSearchAction.setNameImpl(this.getNativeResourceHandle(), string);
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        SoSearchAction.enableElementImpl(string, n);
    }

    public String getName() {
        return SoSearchAction.getNameImpl(this.getNativeResourceHandle());
    }

    public void setNodeClass(Class<? extends Inventor> clazz, boolean bl) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        SoSearchAction.setNodeClassImpl(this.getNativeResourceHandle(), string, bl);
    }

    public void setFound() {
        SoSearchAction.setFoundImpl(this.getNativeResourceHandle());
    }

    public Class<? extends Inventor> getNodeClass() {
        return NativeTypeMap.getJavaClass(SoSearchAction.getNodeClassImpl(this.getNativeResourceHandle()));
    }

    public boolean isSearchingAll() {
        return SoSearchAction.isSearchingAllImpl(this.getNativeResourceHandle());
    }

    public static enum Interests implements IntegerValuedEnum
    {
        FIRST(Interests.getFIRST()),
        LAST(Interests.getLAST()),
        ALL(Interests.getALL());

        private int value;

        private static native int getFIRSTNative();

        private Interests(int n2) {
            this.value = n2;
        }

        private static int getALL() {
            JniInitializer.checkInit();
            return Interests.getALLNative();
        }

        private static native int getALLNative();

        private static int getLAST() {
            JniInitializer.checkInit();
            return Interests.getLASTNative();
        }

        private static native int getLASTNative();

        private static int getFIRST() {
            JniInitializer.checkInit();
            return Interests.getFIRSTNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static Interests valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Interests.class, n);
        }
    }

    public static enum LookFors implements IntegerValuedEnum
    {
        NODE(LookFors.getNODE()),
        TYPE(LookFors.getTYPE()),
        NAME(LookFors.getNAME());

        private int value;

        private static native int getNODENative();

        private LookFors(int n2) {
            this.value = n2;
        }

        private static int getNAME() {
            JniInitializer.checkInit();
            return LookFors.getNAMENative();
        }

        private static native int getNAMENative();

        private static int getTYPE() {
            JniInitializer.checkInit();
            return LookFors.getTYPENative();
        }

        private static native int getTYPENative();

        private static int getNODE() {
            JniInitializer.checkInit();
            return LookFors.getNODENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static LookFors valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(LookFors.class, n);
        }
    }
}

