/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.actions;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.internal.JniInitializer;

public class SoToHTMLAction
extends SoAction {
    private static native float getImageQualityImpl(long var0);

    private static native void setImageComponentsImpl(long var0, int var2);

    private static native void getImageBackgroundColorImpl(long var0, float[] var2);

    private static native void setImageBackgroundColorImpl(long var0, float[] var2);

    private static native int getRegionShapeTypeImpl(long var0);

    private static native void setRegionShapeTypeImpl(long var0, int var2);

    private static native int getImageComponentsImpl(long var0);

    private static native void setViewportRegionImpl(long var0, long var2);

    private static native void getViewportRegionImpl(long var0, long var2);

    private static native void setMapHighlightImpl(long var0, boolean var2);

    private static native boolean isMapHighlightImpl(long var0);

    private static native void setImageQualityImpl(long var0, float var2);

    private static native int getImageFormatImpl(long var0);

    private static native void enableElementImpl(String var0, int var1);

    private static native void setImageFormatImpl(long var0, int var2);

    private static native void closeHTMLFileImpl(long var0);

    private static native boolean openHTMLFileImpl1(long var0, String var2);

    private static native long ctorImpl();

    private static native String getImageURLNameImpl(long var0);

    private static native void setImageURLNameImpl(long var0, String var2);

    private static native void resetHTMLBufferImpl(long var0);

    protected SoToHTMLAction(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public String getImageURLName() {
        return SoToHTMLAction.getImageURLNameImpl(this.getNativeResourceHandle());
    }

    public boolean openHTMLFile(String string) {
        return SoToHTMLAction.openHTMLFileImpl1(this.getNativeResourceHandle(), string);
    }

    public void setImageURLName(String string) {
        SoToHTMLAction.setImageURLNameImpl(this.getNativeResourceHandle(), string);
    }

    public void resetHTMLBuffer() {
        SoToHTMLAction.resetHTMLBufferImpl(this.getNativeResourceHandle());
    }

    public SoToHTMLAction() {
        this(Inventor.ConstructorCommand.CreateInstance, SoToHTMLAction.ctorImpl());
    }

    public void closeHTMLFile() {
        SoToHTMLAction.closeHTMLFileImpl(this.getNativeResourceHandle());
    }

    public static void enableElement(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        SoToHTMLAction.enableElementImpl(string, n);
    }

    public void setImageQuality(float f) {
        SoToHTMLAction.setImageQualityImpl(this.getNativeResourceHandle(), f);
    }

    public float getImageQuality() {
        return SoToHTMLAction.getImageQualityImpl(this.getNativeResourceHandle());
    }

    public boolean isMapHighlight() {
        return SoToHTMLAction.isMapHighlightImpl(this.getNativeResourceHandle());
    }

    public void setMapHighlight(boolean bl) {
        SoToHTMLAction.setMapHighlightImpl(this.getNativeResourceHandle(), bl);
    }

    public void setViewportRegion(SbViewportRegion sbViewportRegion) {
        SoToHTMLAction.setViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public ImageFormats getImageFormat() {
        return IntegerValuedEnumHelper.fromIntValue(ImageFormats.class, SoToHTMLAction.getImageFormatImpl(this.getNativeResourceHandle()));
    }

    public void setRegionShapeType(ShapeTypes shapeTypes) {
        SoToHTMLAction.setRegionShapeTypeImpl(this.getNativeResourceHandle(), shapeTypes.getValue());
    }

    public ShapeTypes getRegionShapeType() {
        return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, SoToHTMLAction.getRegionShapeTypeImpl(this.getNativeResourceHandle()));
    }

    public void setImageBackgroundColor(SbColor sbColor) {
        SoToHTMLAction.setImageBackgroundColorImpl(this.getNativeResourceHandle(), sbColor != null ? sbColor.array : null);
    }

    public SbColor getImageBackgroundColor() {
        SbColor sbColor = new SbColor();
        SoToHTMLAction.getImageBackgroundColorImpl(this.getNativeResourceHandle(), sbColor.array);
        return sbColor;
    }

    public void setImageComponents(Components components) {
        SoToHTMLAction.setImageComponentsImpl(this.getNativeResourceHandle(), components.getValue());
    }

    public SbViewportRegion getViewportRegion() {
        SbViewportRegion sbViewportRegion = new SbViewportRegion();
        SoToHTMLAction.getViewportRegionImpl(this.getNativeResourceHandle(), sbViewportRegion.getNativeResourceHandle());
        return sbViewportRegion;
    }

    public void setImageFormat(ImageFormats imageFormats) {
        SoToHTMLAction.setImageFormatImpl(this.getNativeResourceHandle(), imageFormats.getValue());
    }

    public Components getImageComponents() {
        return IntegerValuedEnumHelper.fromIntValue(Components.class, SoToHTMLAction.getImageComponentsImpl(this.getNativeResourceHandle()));
    }

    public static enum ImageFormats implements IntegerValuedEnum
    {
        BMP_FORMAT(ImageFormats.getBMPFORMAT()),
        JPEG_FORMAT(ImageFormats.getJPEGFORMAT());

        private int value;

        private static native int getBMPFORMATNative();

        private static int getBMPFORMAT() {
            JniInitializer.checkInit();
            return ImageFormats.getBMPFORMATNative();
        }

        private static native int getJPEGFORMATNative();

        private static int getJPEGFORMAT() {
            JniInitializer.checkInit();
            return ImageFormats.getJPEGFORMATNative();
        }

        private ImageFormats(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ImageFormats valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ImageFormats.class, n);
        }
    }

    public static enum ShapeTypes implements IntegerValuedEnum
    {
        NONE(ShapeTypes.getNONE()),
        RECTANGLE(ShapeTypes.getRECTANGLE()),
        CIRCLE(ShapeTypes.getCIRCLE()),
        POLYGON(ShapeTypes.getPOLYGON());

        private int value;

        private static native int getNONENative();

        private ShapeTypes(int n2) {
            this.value = n2;
        }

        private static int getPOLYGON() {
            JniInitializer.checkInit();
            return ShapeTypes.getPOLYGONNative();
        }

        private static native int getPOLYGONNative();

        private static int getCIRCLE() {
            JniInitializer.checkInit();
            return ShapeTypes.getCIRCLENative();
        }

        private static native int getCIRCLENative();

        private static int getRECTANGLE() {
            JniInitializer.checkInit();
            return ShapeTypes.getRECTANGLENative();
        }

        private static native int getRECTANGLENative();

        private static int getNONE() {
            JniInitializer.checkInit();
            return ShapeTypes.getNONENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ShapeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ShapeTypes.class, n);
        }
    }

    public static enum Components implements IntegerValuedEnum
    {
        LUMINANCE(Components.getLUMINANCE()),
        LUMINANCE_TRANSPARENCY(Components.getLUMINANCETRANSPARENCY()),
        RGB(Components.getRGB()),
        RGB_TRANSPARENCY(Components.getRGBTRANSPARENCY());

        private int value;

        private static native int getLUMINANCENative();

        private Components(int n2) {
            this.value = n2;
        }

        private static int getRGBTRANSPARENCY() {
            JniInitializer.checkInit();
            return Components.getRGBTRANSPARENCYNative();
        }

        private static native int getRGBTRANSPARENCYNative();

        private static int getRGB() {
            JniInitializer.checkInit();
            return Components.getRGBNative();
        }

        private static native int getRGBNative();

        private static int getLUMINANCETRANSPARENCY() {
            JniInitializer.checkInit();
            return Components.getLUMINANCETRANSPARENCYNative();
        }

        private static native int getLUMINANCETRANSPARENCYNative();

        private static int getLUMINANCE() {
            JniInitializer.checkInit();
            return Components.getLUMINANCENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static Components valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Components.class, n);
        }
    }
}

