/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.caches;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.misc.SoState;

public class SoNodeDependencies
extends Inventor
implements SafeDisposable {
    private static native boolean isValidImpl(long var0, long var2);

    private static native void invalidateImpl(long var0);

    private static native long ctorImpl();

    private static native void updateCacheImpl(long var0, long var2);

    private static native void addDependencyImpl(long var0, String var2, int var3);

    protected SoNodeDependencies(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    public SoNodeDependencies() {
        this(Inventor.ConstructorCommand.CreateInstance, SoNodeDependencies.ctorImpl());
    }

    public boolean isValid(SoState soState) {
        return SoNodeDependencies.isValidImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void updateCache(SoState soState) {
        SoNodeDependencies.updateCacheImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void addDependency(Class<? extends Inventor> clazz, int n) {
        String string = NativeTypeMap.getNativeTypeName(clazz);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        SoNodeDependencies.addDependencyImpl(this.getNativeResourceHandle(), string, n);
    }

    public void invalidate() {
        SoNodeDependencies.invalidateImpl(this.getNativeResourceHandle());
    }
}

