/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.collision;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoTransform;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SoCollisionManager
extends Inventor {
    private static Hashtable<Long, Filter> filtering = new Hashtable();
    private Vector<BBoxCollisionListener> bboxCollisionListeners = new Vector();
    private static Hashtable<Long, Vector<BBoxCollisionListener>> bboxCollisionListening = new Hashtable();
    private static Hashtable<Long, CollisionListener> callbackKeys2Listeners = new Hashtable();
    private Hashtable<CollisionListener, Vector<Long>> localListeners2CallbackKeys = new Hashtable();

    public void setFilter(Filter filter) {
        if (filter != null) {
            Filter filter2 = filtering.put((long)this.getNativeResourceHandle(), filter);
            if (filter2 == null) {
                this.setFilterCallbackNative(this.getNativeResourceHandle());
            }
        } else {
            Filter filter3 = filtering.remove((long)this.getNativeResourceHandle());
            if (filter3 != null) {
                this.unsetFilterCallbackNative(this.getNativeResourceHandle());
            }
        }
    }

    private static boolean notifyFilter(long l, long l2, long l3) {
        Filter filter = filtering.get(l);
        return filter.accept(ObjectManager.getManagedObjectFor(SoPath.class, l2), ObjectManager.getManagedObjectFor(SoPath.class, l3));
    }

    private native void setFilterCallbackNative(long var1);

    private native void unsetFilterCallbackNative(long var1);

    public void addBBoxCollisionListener(BBoxCollisionListener bBoxCollisionListener) {
        if (this.bboxCollisionListeners.isEmpty()) {
            bboxCollisionListening.put(this.getNativeResourceHandle(), this.bboxCollisionListeners);
            this.setBBoxCollisionCallbackNative(this.getNativeResourceHandle());
        }
        this.bboxCollisionListeners.add(bBoxCollisionListener);
    }

    public void removeBBoxCollisionListener(BBoxCollisionListener bBoxCollisionListener) {
        this.bboxCollisionListeners.remove(bBoxCollisionListener);
        if (this.bboxCollisionListeners.isEmpty()) {
            this.unsetBBoxCollisionCallbackNative(this.getNativeResourceHandle());
            bboxCollisionListening.remove(this.getNativeResourceHandle());
        }
    }

    private static void notifyBBoxCollisionListeners(long l, long l2, long l3) {
        Vector<BBoxCollisionListener> vector = bboxCollisionListening.get(l);
        for (int i = 0; i < vector.size(); ++i) {
            SoPath soPath = ObjectManager.getManagedObjectFor(SoPath.class, l2);
            SoPath soPath2 = ObjectManager.getManagedObjectFor(SoPath.class, l3);
            vector.get(i).bboxCollide(soPath, soPath2);
        }
    }

    private native void setBBoxCollisionCallbackNative(long var1);

    private native void unsetBBoxCollisionCallbackNative(long var1);

    public void addCollisionListener(CollisionListener collisionListener) {
        long l = this.addCollisionCallbackNative(this.getNativeResourceHandle());
        callbackKeys2Listeners.put(l, collisionListener);
        Vector<Long> vector = this.localListeners2CallbackKeys.get(collisionListener);
        if (vector == null) {
            vector = new Vector();
            this.localListeners2CallbackKeys.put(collisionListener, vector);
        }
        vector.add(l);
    }

    public void removeCollisionListener(CollisionListener collisionListener) {
        Vector<Long> vector = this.localListeners2CallbackKeys.get(collisionListener);
        if (vector != null && !vector.isEmpty()) {
            Long l = vector.remove(0);
            callbackKeys2Listeners.remove(l);
            this.removeCollisionCallbackNative(this.getNativeResourceHandle(), l);
        }
    }

    private void removeAllCollisionListeners() {
        Enumeration<Vector<Long>> enumeration = this.localListeners2CallbackKeys.elements();
        while (enumeration.hasMoreElements()) {
            Vector<Long> vector = enumeration.nextElement();
            for (int i = 0; i < vector.size(); ++i) {
                Long l = vector.get(i);
                callbackKeys2Listeners.remove(l);
                this.removeCollisionCallbackNative(this.getNativeResourceHandle(), l);
            }
        }
        this.localListeners2CallbackKeys.clear();
    }

    private static int notifyCollisionListeners(long l, long l2, SbVec3f[] sbVec3fArray, long l3, SbVec3f[] sbVec3fArray2) {
        CollidingPrimitive collidingPrimitive = null;
        CollidingPrimitive collidingPrimitive2 = null;
        if (l2 != 0L) {
            collidingPrimitive = new CollidingPrimitive(ObjectManager.getManagedObjectFor(SoPath.class, l2), sbVec3fArray);
        }
        if (l3 != 0L) {
            collidingPrimitive2 = new CollidingPrimitive(ObjectManager.getManagedObjectFor(SoPath.class, l3), sbVec3fArray2);
        }
        CollisionListener collisionListener = callbackKeys2Listeners.get(l);
        return collisionListener.collide(collidingPrimitive, collidingPrimitive2);
    }

    private native long addCollisionCallbackNative(long var1);

    private native void removeCollisionCallbackNative(long var1, long var3);

    protected void finalize() throws Throwable {
        this.unsetFilterCallbackNative(this.getNativeResourceHandle());
        filtering.remove(this.getNativeResourceHandle());
        this.unsetBBoxCollisionCallbackNative(this.getNativeResourceHandle());
        bboxCollisionListening.remove((long)this.getNativeResourceHandle());
        this.removeAllCollisionListeners();
    }

    private static native boolean isActivatedImpl(long var0);

    private static native void activateImpl(long var0, boolean var2);

    private static native boolean isSceneBBoxOnlyImpl(long var0);

    private static native void setGluingImpl(long var0, boolean var2);

    private static native boolean isGluingImpl(long var0);

    private static native long getSceneImpl(long var0);

    private static native void setSceneImpl(long var0, long var2);

    private static native long getObjectImpl(long var0);

    private static native long ctorImpl(long var0, long var2, long var4);

    private static native void setObjectImpl(long var0, long var2);

    private static native void setTransformImpl(long var0, long var2);

    private static native void setSceneBBoxOnlyImpl(long var0, boolean var2);

    private static native boolean isObjectBBoxOnlyImpl(long var0);

    private static native void setObjectBBoxOnlyImpl(long var0, boolean var2);

    private static native long getTransformImpl(long var0);

    private static native void setGluingLevelImpl(long var0, int var2);

    private static native int getGluingLevelImpl(long var0);

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    protected SoCollisionManager(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public void setObjectBBoxOnly() {
        this.setObjectBBoxOnly(true);
    }

    public void activate() {
        this.activate(true);
    }

    public void setGluing() {
        this.setGluing(true);
    }

    public void setSceneBBoxOnly() {
        this.setSceneBBoxOnly(true);
    }

    public void setScene(SoGroup soGroup) {
        SoCollisionManager.setSceneImpl(this.getNativeResourceHandle(), soGroup != null ? soGroup.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public boolean isActivated() {
        return SoCollisionManager.isActivatedImpl(this.getNativeResourceHandle());
    }

    public SoPath getObject() {
        return ObjectManager.getManagedObjectFor(SoPath.class, SoCollisionManager.getObjectImpl(this.getNativeResourceHandle()));
    }

    public void setObject(SoPath soPath) {
        SoCollisionManager.setObjectImpl(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoCollisionManager(SoPath soPath, SoGroup soGroup, SoTransform soTransform) {
        this(Inventor.ConstructorCommand.CreateInstance, SoCollisionManager.ctorImpl(soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, soGroup != null ? soGroup.getNativeResourceHandle() : Inventor.ZeroHandle, soTransform != null ? soTransform.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public SoGroup getScene() {
        return ObjectManager.getManagedObjectFor(SoGroup.class, SoCollisionManager.getSceneImpl(this.getNativeResourceHandle()));
    }

    public void activate(boolean bl) {
        SoCollisionManager.activateImpl(this.getNativeResourceHandle(), bl);
    }

    public boolean isGluing() {
        return SoCollisionManager.isGluingImpl(this.getNativeResourceHandle());
    }

    public void setGluing(boolean bl) {
        SoCollisionManager.setGluingImpl(this.getNativeResourceHandle(), bl);
    }

    public boolean isSceneBBoxOnly() {
        return SoCollisionManager.isSceneBBoxOnlyImpl(this.getNativeResourceHandle());
    }

    public void setSceneBBoxOnly(boolean bl) {
        SoCollisionManager.setSceneBBoxOnlyImpl(this.getNativeResourceHandle(), bl);
    }

    public boolean isObjectBBoxOnly() {
        return SoCollisionManager.isObjectBBoxOnlyImpl(this.getNativeResourceHandle());
    }

    public void setObjectBBoxOnly(boolean bl) {
        SoCollisionManager.setObjectBBoxOnlyImpl(this.getNativeResourceHandle(), bl);
    }

    public int getGluingLevel() {
        return SoCollisionManager.getGluingLevelImpl(this.getNativeResourceHandle());
    }

    public void setGluingLevel(int n) {
        SoCollisionManager.setGluingLevelImpl(this.getNativeResourceHandle(), n);
    }

    public void setTransform(SoTransform soTransform) {
        SoCollisionManager.setTransformImpl(this.getNativeResourceHandle(), soTransform != null ? soTransform.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoTransform getTransform() {
        return ObjectManager.getManagedObjectFor(SoTransform.class, SoCollisionManager.getTransformImpl(this.getNativeResourceHandle()));
    }

    public static interface Filter {
        public boolean accept(SoPath var1, SoPath var2);
    }

    public static interface BBoxCollisionListener {
        public void bboxCollide(SoPath var1, SoPath var2);
    }

    public static class CollidingPrimitive {
        public SoPath path;
        public SbVec3f[] vertices;

        public CollidingPrimitive(SoPath soPath, SbVec3f[] sbVec3fArray) {
            this.path = soPath;
            this.vertices = sbVec3fArray;
        }
    }

    public static interface CollisionListener {
        public static final int NEXT_PRIMITIVE = 0;
        public static final int NEXT_SHAPE = 1;
        public static final int ABORT = 2;

        public int collide(CollidingPrimitive var1, CollidingPrimitive var2);
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum Positions implements IntegerValuedEnum
    {
        BEGIN(Positions.getBEGIN()),
        END(Positions.getEND());

        private int value;

        private static native int getBEGINNative();

        private static int getBEGIN() {
            JniInitializer.checkInit();
            return Positions.getBEGINNative();
        }

        private static native int getENDNative();

        private static int getEND() {
            JniInitializer.checkInit();
            return Positions.getENDNative();
        }

        private Positions(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static Positions valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Positions.class, n);
        }
    }

    public static enum Axis implements IntegerValuedEnum
    {
        X_AXIS(Axis.getXAXIS()),
        Y_AXIS(Axis.getYAXIS()),
        Z_AXIS(Axis.getZAXIS());

        private int value;

        private static native int getXAXISNative();

        private Axis(int n2) {
            this.value = n2;
        }

        private static int getZAXIS() {
            JniInitializer.checkInit();
            return Axis.getZAXISNative();
        }

        private static native int getZAXISNative();

        private static int getYAXIS() {
            JniInitializer.checkInit();
            return Axis.getYAXISNative();
        }

        private static native int getYAXISNative();

        private static int getXAXIS() {
            JniInitializer.checkInit();
            return Axis.getXAXISNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static Axis valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Axis.class, n);
        }
    }

    public static enum TransformChangeTypes implements IntegerValuedEnum
    {
        NONE(TransformChangeTypes.getNONE()),
        TRANSLATION(TransformChangeTypes.getTRANSLATION()),
        SCALE(TransformChangeTypes.getSCALE()),
        ROTATION(TransformChangeTypes.getROTATION()),
        ORIENTATION(TransformChangeTypes.getORIENTATION()),
        CENTER(TransformChangeTypes.getCENTER());

        private int value;

        private static native int getNONENative();

        private TransformChangeTypes(int n2) {
            this.value = n2;
        }

        private static int getCENTER() {
            JniInitializer.checkInit();
            return TransformChangeTypes.getCENTERNative();
        }

        private static native int getCENTERNative();

        private static int getORIENTATION() {
            JniInitializer.checkInit();
            return TransformChangeTypes.getORIENTATIONNative();
        }

        private static native int getORIENTATIONNative();

        private static int getROTATION() {
            JniInitializer.checkInit();
            return TransformChangeTypes.getROTATIONNative();
        }

        private static int getNONE() {
            JniInitializer.checkInit();
            return TransformChangeTypes.getNONENative();
        }

        private static native int getTRANSLATIONNative();

        private static int getTRANSLATION() {
            JniInitializer.checkInit();
            return TransformChangeTypes.getTRANSLATIONNative();
        }

        private static native int getSCALENative();

        private static int getSCALE() {
            JniInitializer.checkInit();
            return TransformChangeTypes.getSCALENative();
        }

        private static native int getROTATIONNative();

        @Override
        public int getValue() {
            return this.value;
        }

        public static TransformChangeTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(TransformChangeTypes.class, n);
        }
    }

    public static enum Resps implements IntegerValuedEnum
    {
        NEXT_PRIMITIVE(Resps.getNEXTPRIMITIVE()),
        NEXT_SHAPE(Resps.getNEXTSHAPE()),
        ABORT(Resps.getABORT());

        private int value;

        private static native int getNEXTPRIMITIVENative();

        private Resps(int n2) {
            this.value = n2;
        }

        private static int getABORT() {
            JniInitializer.checkInit();
            return Resps.getABORTNative();
        }

        private static native int getABORTNative();

        private static int getNEXTSHAPE() {
            JniInitializer.checkInit();
            return Resps.getNEXTSHAPENative();
        }

        private static native int getNEXTSHAPENative();

        private static int getNEXTPRIMITIVE() {
            JniInitializer.checkInit();
            return Resps.getNEXTPRIMITIVENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static Resps valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(Resps.class, n);
        }
    }
}

