/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.devices;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.devices.SoDeviceContext;
import com.openinventor.inventor.devices.SoGLFormat;
import com.openinventor.inventor.helpers.SbGPUCapabilities;
import com.openinventor.inventor.internal.JniInitializer;

public class SoGLContext
extends SoDeviceContext {
    private static native long getFormatImpl(long var0);

    private static native int getSharedGroupPolicyImpl();

    private static native int getIdImpl(long var0);

    private static native void invalidateImpl(long var0);

    private static native boolean isValidForCurrentImpl(long var0);

    private static native long getContextFromSharedIdImpl(int var0);

    private static native long getGraphicsCapabilitiesImpl();

    private static native long getContextFromIdImpl(int var0);

    private static native long getCurrentImpl(boolean var0);

    private static native long getContextGraphicsCapabilitiesImpl(long var0);

    private static native void setNoGLContextDeleteImpl(long var0);

    private static native boolean swapBuffersImpl(long var0);

    private static native void assertContextImpl(long var0);

    private static native long ctorImpl3(long var0, boolean var2);

    private static native long ctorImpl(boolean var0);

    private static native boolean tryBindImpl(long var0);

    protected SoGLContext(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    public static SoGLContext getCurrent() {
        return SoGLContext.getCurrent(false);
    }

    public boolean tryBind() {
        return SoGLContext.tryBindImpl(this.getNativeResourceHandle());
    }

    public SoGLContext(boolean bl) {
        this(Inventor.ConstructorCommand.CreateInstance, SoGLContext.ctorImpl(bl));
    }

    public static SoGLContext getContextFromSharedId(int n) {
        return ObjectManager.getManagedObjectFor(SoGLContext.class, SoGLContext.getContextFromSharedIdImpl(n));
    }

    public SoGLContext(SoGLContext soGLContext, boolean bl) {
        this(Inventor.ConstructorCommand.CreateInstance, SoGLContext.ctorImpl3(soGLContext != null ? soGLContext.getNativeResourceHandle() : Inventor.ZeroHandle, bl));
    }

    public static SbGPUCapabilities getGraphicsCapabilities() {
        return ObjectManager.getManagedObjectFor(SbGPUCapabilities.class, SoGLContext.getGraphicsCapabilitiesImpl());
    }

    public static SoGLContext getContextFromId(int n) {
        return ObjectManager.getManagedObjectFor(SoGLContext.class, SoGLContext.getContextFromIdImpl(n));
    }

    public boolean isValidForCurrent() {
        return SoGLContext.isValidForCurrentImpl(this.getNativeResourceHandle());
    }

    public SoGLFormat getFormat() {
        return ObjectManager.getManagedObjectFor(SoGLFormat.class, SoGLContext.getFormatImpl(this.getNativeResourceHandle()));
    }

    public boolean swapBuffers() {
        return SoGLContext.swapBuffersImpl(this.getNativeResourceHandle());
    }

    public void setNoGLContextDelete() {
        SoGLContext.setNoGLContextDeleteImpl(this.getNativeResourceHandle());
    }

    public SbGPUCapabilities getContextGraphicsCapabilities() {
        return ObjectManager.getManagedObjectFor(SbGPUCapabilities.class, SoGLContext.getContextGraphicsCapabilitiesImpl(this.getNativeResourceHandle()));
    }

    public static SoGLContext getCurrent(boolean bl) {
        return ObjectManager.getManagedObjectFor(SoGLContext.class, SoGLContext.getCurrentImpl(bl));
    }

    public int getId() {
        return SoGLContext.getIdImpl(this.getNativeResourceHandle());
    }

    public void invalidate() {
        SoGLContext.invalidateImpl(this.getNativeResourceHandle());
    }

    public void assertContext() {
        SoGLContext.assertContextImpl(this.getNativeResourceHandle());
    }

    public static SharedGroupPolicies getSharedGroupPolicy() {
        return IntegerValuedEnumHelper.fromIntValue(SharedGroupPolicies.class, SoGLContext.getSharedGroupPolicyImpl());
    }

    public static enum SharedGroupPolicies implements IntegerValuedEnum
    {
        DISABLED(SharedGroupPolicies.getDISABLED()),
        CONSERVATIVE(SharedGroupPolicies.getCONSERVATIVE()),
        AGGRESSIVE(SharedGroupPolicies.getAGGRESSIVE());

        private int value;

        private static native int getDISABLEDNative();

        private SharedGroupPolicies(int n2) {
            this.value = n2;
        }

        private static int getAGGRESSIVE() {
            JniInitializer.checkInit();
            return SharedGroupPolicies.getAGGRESSIVENative();
        }

        private static native int getAGGRESSIVENative();

        private static int getCONSERVATIVE() {
            JniInitializer.checkInit();
            return SharedGroupPolicies.getCONSERVATIVENative();
        }

        private static native int getCONSERVATIVENative();

        private static int getDISABLED() {
            JniInitializer.checkInit();
            return SharedGroupPolicies.getDISABLEDNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static SharedGroupPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SharedGroupPolicies.class, n);
        }
    }
}

