/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.elements;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.ElementManager;
import com.openinventor.internal.NativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.elements.SoElement;
import com.openinventor.inventor.elements.SoReplacedElement;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoNode;

public class SoEnvironmentElement
extends SoReplacedElement {
    private static native float getAmbientIntensityImpl(long var0);

    private static native boolean matchesImpl(long var0, long var2);

    private static native boolean getAmbientOcclusionImpl(long var0);

    private static native void getAmbientColorImpl(long var0, float[] var2);

    private static native void setEltImpl(long var0, long var2);

    private static native void getLightAttenuationImpl(long var0, float[] var2);

    private static native void getImpl(long var0, long var2);

    private static native long ctorImpl();

    private static native void nativeDerivedClassInit();

    private static native int[] initCustomClass(long var0, Inventor var2, boolean var3, String var4, int var5, int var6);

    private static native int getClassStackIndexImpl();

    private static native void initImpl(long var0, long var2);

    private static native void setImpl(long var0, long var2, long var4);

    private static native void pushImpl(long var0, long var2);

    private static native long copyMatchInfoImpl(long var0);

    protected SoEnvironmentElement(Inventor.ConstructorCommand constructorCommand, String string, Object ... objectArray) {
        super(constructorCommand, string, objectArray);
        this.initializeFields();
    }

    protected SoEnvironmentElement(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    protected void setElt(EnvironmentParameters environmentParameters) {
        SoEnvironmentElement.setEltImpl(this.getNativeResourceHandle(), environmentParameters != null ? environmentParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    @Override
    protected void init(SoState soState) {
        SoEnvironmentElement.initImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    @Override
    protected SoElement copyMatchInfo() {
        return ObjectManager.getManagedObjectFor(SoElement.class, SoEnvironmentElement.copyMatchInfoImpl(this.getNativeResourceHandle()));
    }

    protected SoEnvironmentElement() {
        this(Inventor.ConstructorCommand.CreateFromInstance, SoEnvironmentElement.ctorImpl());
        Class<?> clazz = this.getClass();
        int[] nArray = SoEnvironmentElement.initCustomClass(this.getNativeResourceHandle(), this, NativeTypeMap.processCustomClass(clazz), NativeTypeMap.getNativeTypeName(clazz), ElementManager.getSavedClassStackIndex(clazz), ElementManager.getSavedClassElementKey(clazz));
        ElementManager.saveClassStackIndex(clazz, nArray[0]);
        ElementManager.saveClassElementKey(clazz, nArray[1]);
    }

    @Override
    protected boolean matches(SoElement soElement) {
        return SoEnvironmentElement.matchesImpl(this.getNativeResourceHandle(), soElement != null ? soElement.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    @Deprecated(since="9.3.0.0")
    public static int getClassStackIndex() {
        return SoEnvironmentElement.getClassStackIndexImpl();
    }

    public static void set(SoState soState, SoNode soNode, EnvironmentParameters environmentParameters) {
        SoEnvironmentElement.setImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, environmentParameters != null ? environmentParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static EnvironmentParameters get(SoState soState) {
        EnvironmentParameters environmentParameters = new EnvironmentParameters();
        SoEnvironmentElement.getImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, environmentParameters != null ? environmentParameters.getNativeResourceHandle() : Inventor.ZeroHandle);
        return environmentParameters;
    }

    @Override
    public void push(SoState soState) {
        SoEnvironmentElement.pushImpl(this.getNativeResourceHandle(), soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static float getAmbientIntensity(SoState soState) {
        return SoEnvironmentElement.getAmbientIntensityImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static SbColor getAmbientColor(SoState soState) {
        SbColor sbColor = new SbColor();
        SoEnvironmentElement.getAmbientColorImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbColor.array);
        return sbColor;
    }

    public static SbVec3f getLightAttenuation(SoState soState) {
        SbVec3f sbVec3f = new SbVec3f();
        SoEnvironmentElement.getLightAttenuationImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle, sbVec3f.array);
        return sbVec3f;
    }

    public static boolean getAmbientOcclusion(SoState soState) {
        return SoEnvironmentElement.getAmbientOcclusionImpl(soState != null ? soState.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    static {
        SoEnvironmentElement.nativeDerivedClassInit();
    }

    public static class EnvironmentParameters
    extends Inventor {
        public final SbColor ambientColor;
        public final SbVec3f attenuation;
        public final SbColor fogColor;

        private static native long ctorImpl();

        private static native void setValueImpl(long var0, long var2);

        private static native void toArrayImpl(long var0, long[] var2);

        private static native long getFogColorFieldHandle(long var0);

        private static native long getAmbientColorFieldHandle(long var0);

        private static native long getAttenuationFieldHandle(long var0);

        protected EnvironmentParameters(Inventor.ConstructorCommand constructorCommand, long l) {
            super(constructorCommand, l);
            this.initializeFields();
            this.ambientColor = ObjectManager.getBasicObjectFor(SbColor.class, EnvironmentParameters.getAmbientColorFieldHandle(this.getNativeResourceHandle()));
            this.attenuation = ObjectManager.getBasicObjectFor(SbVec3f.class, EnvironmentParameters.getAttenuationFieldHandle(this.getNativeResourceHandle()));
            this.fogColor = ObjectManager.getBasicObjectFor(SbColor.class, EnvironmentParameters.getFogColorFieldHandle(this.getNativeResourceHandle()));
        }

        @Override
        protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
            if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
                return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
            }
            return new NativeResourceHandle(this, l, constructorCommand);
        }

        public EnvironmentParameters(EnvironmentParameters environmentParameters) {
            this();
            this.setValue(environmentParameters);
        }

        public EnvironmentParameters() {
            this(Inventor.ConstructorCommand.CreateInstance, EnvironmentParameters.ctorImpl());
        }

        public static EnvironmentParameters[] toArray(long l, long l2) {
            EnvironmentParameters[] environmentParametersArray = new EnvironmentParameters[(int)l2];
            long[] lArray = new long[(int)l2];
            int n = 0;
            while ((long)n < l2) {
                environmentParametersArray[n] = new EnvironmentParameters();
                lArray[n] = environmentParametersArray[n].getNativeResourceHandle();
                ++n;
            }
            EnvironmentParameters.toArrayImpl(l, lArray);
            return environmentParametersArray;
        }

        public void setValue(EnvironmentParameters environmentParameters) {
            EnvironmentParameters.setValueImpl(this.getNativeResourceHandle(), environmentParameters.getNativeResourceHandle());
        }

        private static final class NativeResourceHandle
        extends DeletableNativeResourceHandle {
            private static native void deleteNativeHandleImpl(long var0);

            public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
                super(inventor, l, constructorCommand);
            }

            @Override
            protected void deleteNativeHandle(long l) {
                NativeResourceHandle.deleteNativeHandleImpl(l);
            }

            static {
                JniInitializer.checkInit();
            }
        }
    }

    public static enum FogTypes implements IntegerValuedEnum
    {
        NONE(FogTypes.getNONE()),
        HAZE(FogTypes.getHAZE()),
        FOG(FogTypes.getFOG()),
        SMOKE(FogTypes.getSMOKE());

        private int value;

        private static native int getNONENative();

        private FogTypes(int n2) {
            this.value = n2;
        }

        private static int getSMOKE() {
            JniInitializer.checkInit();
            return FogTypes.getSMOKENative();
        }

        private static native int getSMOKENative();

        private static int getFOG() {
            JniInitializer.checkInit();
            return FogTypes.getFOGNative();
        }

        private static native int getFOGNative();

        private static int getHAZE() {
            JniInitializer.checkInit();
            return FogTypes.getHAZENative();
        }

        private static native int getHAZENative();

        private static int getNONE() {
            JniInitializer.checkInit();
            return FogTypes.getNONENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static FogTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(FogTypes.class, n);
        }
    }
}

