/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.internal.EnumFieldContainerHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import com.openinventor.inventor.nodes.SoNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class SoMFEnum<EnumType extends Enum<EnumType>>
extends SoMField {
    protected Class<EnumType> m_enumTypeClass;

    protected SoMFEnum(Inventor.ConstructorCommand constructorCommand, long l, Class<EnumType> clazz) {
        super(constructorCommand, l);
        this.initializeFields();
        this.m_enumTypeClass = clazz;
    }

    private static native int findImpl(long var0, int var2, boolean var3);

    private static native boolean equalsImpl(long var0, long var2);

    private static native int getValueAtImpl(long var0, int var2);

    private static native void setValueImpl(long var0, int var2);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native void set1ValueImpl(long var0, int var2, int var3);

    private static native int[] getValuesImpl(long var0, int var2);

    private static native void setValuesImpl(long var0, int var2, int var3, int[] var4);

    private static native void finishEditingImpl(long var0);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native void setEnumTypeNative(long var0, long var2, String var4);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native long ctorImpl();

    private static native void setValueImpl1(long var0, String var2);

    private static native void set1ValueImpl1(long var0, int var2, String var3);

    private static native Object startEditingImpl(long var0);

    private static native void disableDeleteValuesImpl(long var0);

    protected SoMFEnum(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(int n) {
        return this.find(n, false);
    }

    public IntBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range 0 <= start < " + this.getNum());
        }
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoMFEnum.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asIntBuffer();
    }

    public int getValueAt(int n) {
        return SoMFEnum.getValueAtImpl(this.getNativeResourceHandle(), n);
    }

    public void finishEditing() {
        SoMFEnum.finishEditingImpl(this.getNativeResourceHandle());
    }

    public IntBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoMFEnum.startEditingImpl(this.getNativeResourceHandle());
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asIntBuffer();
    }

    public SoMFEnum(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes, Class<EnumType> clazz) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFEnum.ctorImpl());
        this.m_enumTypeClass = clazz;
        SoMFEnum.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
        String string2 = clazz.getSimpleName();
        if (!EnumFieldContainerHelper.hasEnumValues(soFieldContainer, clazz)) {
            EnumFieldContainerHelper.addEnumValues(soFieldContainer, clazz);
        }
        if (SoNode.class.isAssignableFrom(soFieldContainer.getClass())) {
            SoMFEnum.setEnumTypeNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string2);
        }
    }

    public int[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range 0 <= start < " + this.getNum());
        }
        return SoMFEnum.getValuesImpl(this.getNativeResourceHandle(), n);
    }

    public void setValue(String string) {
        this.onSetValue();
        SoMFEnum.setValueImpl1(this.getNativeResourceHandle(), string);
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        SoMFEnum.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
    }

    public void set1Value(int n, String string) {
        this.onSet1Value(n);
        SoMFEnum.set1ValueImpl1(this.getNativeResourceHandle(), n, string);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFEnum) {
            SoMFEnum soMFEnum = (SoMFEnum)object;
            return SoMFEnum.equalsImpl(this.getNativeResourceHandle(), soMFEnum.getNativeResourceHandle());
        }
        return false;
    }

    public void setValue(int n) {
        this.onSetValue();
        SoMFEnum.setValueImpl(this.getNativeResourceHandle(), n);
    }

    public void set1Value(int n, int n2) {
        this.onSet1Value(n);
        SoMFEnum.set1ValueImpl(this.getNativeResourceHandle(), n, n2);
    }

    public void setValues(int n, int[] nArray) {
        int n2 = nArray != null ? nArray.length : 0;
        this.onSetValues(n, n2);
        SoMFEnum.setValuesImpl(this.getNativeResourceHandle(), n, n2, nArray);
    }

    public int find(int n, boolean bl) {
        return SoMFEnum.findImpl(this.getNativeResourceHandle(), n, bl);
    }

    public void disableDeleteValues() {
        SoMFEnum.disableDeleteValuesImpl(this.getNativeResourceHandle());
    }
}

