/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec2d;
import com.openinventor.inventor.SbVec2f;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoMFVec2f
extends SoMField {
    public void setValues(int n, float[][] fArray) {
        this.onSetValues(n, fArray.length);
        SoMFVec2f.setValuesNativ2(this.getNativeResourceHandle(), n, fArray);
    }

    private static native void setValuesNativ2(long var0, int var2, float[][] var3);

    @Deprecated(since="9.3.1")
    public void setValues(int n, int n2, float[] fArray) {
        this.onSetValues(n, n2);
        if (fArray.length % 2 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 2");
        }
        if (2 * n2 > fArray.length) {
            throw new IllegalArgumentException("num is greater than num of elements provided by array");
        }
        SoMFVec2f.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
    }

    @Deprecated(since="9.3.1")
    public void setValues(int n, int n2, SbVec2d[] sbVec2dArray) {
        this.onSetValues(n, n2);
        SoMFVec2f.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec2dArray);
    }

    private static native void set1ValueImpl(long var0, int var2, float[] var3);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native void disableDeleteValuesImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    private static native void setValueImpl(long var0, float[] var2);

    private static native void set1ValueImpl2(long var0, int var2, float[] var3);

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static native int findImpl(long var0, float[] var2, boolean var3);

    private static native void setValuesImpl2(long var0, int var2, int var3, Object[] var4);

    private static native void set1ValueImpl1(long var0, int var2, float var3, float var4);

    private static native void setValueImpl1(long var0, float var2, float var3);

    private static native void setValuesImpl1(long var0, int var2, int var3, float[] var4);

    private static native void setValueImpl2(long var0, float[] var2);

    private static native void set1ValueImpl3(long var0, int var2, double[] var3);

    private static native void setValueImpl3(long var0, double[] var2);

    private static native void finishEditingImpl(long var0);

    private static native Object startEditingImpl(long var0);

    private static native void getValueAtImpl(long var0, int var2, float[] var3);

    private static native long ctorImpl();

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native long getValuesImpl(long var0, int var2);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    protected SoMFVec2f(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(SbVec2f sbVec2f) {
        return this.find(sbVec2f, false);
    }

    public int find(SbVec2f sbVec2f, boolean bl) {
        return SoMFVec2f.findImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null, bl);
    }

    public SbVec2f[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range 0 <= start < " + this.getNum());
        }
        long l = Inventor.ZeroHandle;
        l = SoMFVec2f.getValuesImpl(this.getNativeResourceHandle(), n);
        return SbVec2f.toArray(l, this.getNum() - n);
    }

    public FloatBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range 0 <= start < " + this.getNum());
        }
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoMFVec2f.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public SbVec2f getValueAt(int n) {
        SbVec2f sbVec2f = new SbVec2f();
        SoMFVec2f.getValueAtImpl(this.getNativeResourceHandle(), n, sbVec2f.array);
        return sbVec2f;
    }

    public void finishEditing() {
        SoMFVec2f.finishEditingImpl(this.getNativeResourceHandle());
    }

    public FloatBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoMFVec2f.startEditingImpl(this.getNativeResourceHandle());
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asFloatBuffer();
    }

    public void set1Value(int n, float f, float f2) {
        this.onSet1Value(n);
        SoMFVec2f.set1ValueImpl1(this.getNativeResourceHandle(), n, f, f2);
    }

    public SoMFVec2f(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFVec2f.ctorImpl());
        SoMFVec2f.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public void setValue(float f, float f2) {
        this.onSetValue();
        SoMFVec2f.setValueImpl1(this.getNativeResourceHandle(), f, f2);
    }

    public void set1Value(int n, float[] fArray) {
        this.onSet1Value(n);
        if (fArray.length != 2) {
            throw new IllegalArgumentException("Expected size is 2");
        }
        SoMFVec2f.set1ValueImpl2(this.getNativeResourceHandle(), n, fArray);
    }

    public void setValues(int n, SbVec2f[] sbVec2fArray) {
        int n2 = sbVec2fArray != null ? sbVec2fArray.length : 0;
        this.onSetValues(n, n2);
        SoMFVec2f.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbVec2fArray);
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        SoMFVec2f.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
    }

    public void setValue(SbVec2d sbVec2d) {
        this.onSetValue();
        SoMFVec2f.setValueImpl3(this.getNativeResourceHandle(), sbVec2d != null ? sbVec2d.array : null);
    }

    public void disableDeleteValues() {
        SoMFVec2f.disableDeleteValuesImpl(this.getNativeResourceHandle());
    }

    public void set1Value(int n, SbVec2d sbVec2d) {
        this.onSet1Value(n);
        SoMFVec2f.set1ValueImpl3(this.getNativeResourceHandle(), n, sbVec2d != null ? sbVec2d.array : null);
    }

    public void setValues(int n, float[] fArray) {
        int n2 = fArray != null ? fArray.length / 2 : 0;
        this.onSetValues(n, n2);
        if (fArray != null && fArray.length % 2 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 2");
        }
        SoMFVec2f.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFVec2f) {
            SoMFVec2f soMFVec2f = (SoMFVec2f)object;
            return SoMFVec2f.equalsImpl(this.getNativeResourceHandle(), soMFVec2f.getNativeResourceHandle());
        }
        return false;
    }

    public void setValue(float[] fArray) {
        this.onSetValue();
        if (fArray.length != 2) {
            throw new IllegalArgumentException("Expected size is 2");
        }
        SoMFVec2f.setValueImpl2(this.getNativeResourceHandle(), fArray);
    }

    public void setValue(SbVec2f sbVec2f) {
        this.onSetValue();
        SoMFVec2f.setValueImpl(this.getNativeResourceHandle(), sbVec2f != null ? sbVec2f.array : null);
    }

    public void setValues(int n, SbVec2d[] sbVec2dArray) {
        int n2 = sbVec2dArray != null ? sbVec2dArray.length : 0;
        this.onSetValues(n, n2);
        SoMFVec2f.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec2dArray);
    }

    public void set1Value(int n, SbVec2f sbVec2f) {
        this.onSet1Value(n);
        SoMFVec2f.set1ValueImpl(this.getNativeResourceHandle(), n, sbVec2f != null ? sbVec2f.array : null);
    }
}

