/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbVec3d;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoMField;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class SoMFVec3f
extends SoMField {
    public void setValues(int n, float[][] fArray) {
        this.onSetValues(n, fArray.length);
        SoMFVec3f.setValuesNativ2(this.getNativeResourceHandle(), n, fArray);
    }

    private static native void setValuesNativ2(long var0, int var2, float[][] var3);

    @Deprecated(since="9.3.1")
    public void setValues(int n, int n2, float[] fArray) {
        this.onSetValues(n, n2);
        if (fArray.length % 3 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 3");
        }
        if (3 * n2 > fArray.length) {
            throw new IllegalArgumentException("num is greater than num of elements provided by array");
        }
        SoMFVec3f.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
    }

    @Deprecated(since="9.3.1")
    public void setValues(int n, int n2, SbVec3d[] sbVec3dArray) {
        this.onSetValues(n, n2);
        SoMFVec3f.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec3dArray);
    }

    private static native long getValuesImpl(long var0, int var2);

    private static native int findImpl(long var0, float[] var2, boolean var3);

    private static native void set1ValueImpl2(long var0, int var2, float[] var3);

    private static native void setValuesImpl(long var0, int var2, int var3, Object[] var4);

    private static native void set1ValueImpl3(long var0, int var2, double[] var3);

    private static native void setValueImpl2(long var0, float[] var2);

    private static native void setValueImpl(long var0, float[] var2);

    private static native void setValuesImpl1(long var0, int var2, int var3, float[] var4);

    private static native void set1ValueImpl(long var0, int var2, float[] var3);

    private static native void setValueImpl1(long var0, float var2, float var3, float var4);

    private static native Object getDirectValuesImpl(long var0, int var2);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    private static native void set1ValueImpl1(long var0, int var2, float var3, float var4, float var5);

    private static native void setValuesBufferImpl(long var0, int var2, Object var3);

    private static native long ctorImpl();

    private static native void disableDeleteValuesImpl(long var0);

    private static native void setValuesImpl2(long var0, int var2, int var3, Object[] var4);

    private static native void getValueAtImpl(long var0, int var2, float[] var3);

    private static native void finishEditingImpl(long var0);

    private static native void setValueImpl3(long var0, double[] var2);

    private static native Object startEditingImpl(long var0);

    private static native boolean equalsImpl(long var0, long var2);

    protected SoMFVec3f(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public int find(SbVec3f sbVec3f) {
        return this.find(sbVec3f, false);
    }

    public void setValues(int n, SbVec3d[] sbVec3dArray) {
        int n2 = sbVec3dArray != null ? sbVec3dArray.length : 0;
        this.onSetValues(n, n2);
        SoMFVec3f.setValuesImpl2(this.getNativeResourceHandle(), n, n2, sbVec3dArray);
    }

    public SbVec3f getValueAt(int n) {
        SbVec3f sbVec3f = new SbVec3f();
        SoMFVec3f.getValueAtImpl(this.getNativeResourceHandle(), n, sbVec3f.array);
        return sbVec3f;
    }

    public FloatBuffer getDirectValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range 0 <= start < " + this.getNum());
        }
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoMFVec3f.getDirectValuesImpl(this.getNativeResourceHandle(), n);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        return byteBuffer.asFloatBuffer();
    }

    public SbVec3f[] getValues(int n) {
        if (this.getNum() == 0) {
            return null;
        }
        if (n < 0 || n >= this.getNum()) {
            throw new IndexOutOfBoundsException("Index " + n + " is out of range 0 <= start < " + this.getNum());
        }
        long l = Inventor.ZeroHandle;
        l = SoMFVec3f.getValuesImpl(this.getNativeResourceHandle(), n);
        return SbVec3f.toArray(l, this.getNum() - n);
    }

    public int find(SbVec3f sbVec3f, boolean bl) {
        return SoMFVec3f.findImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null, bl);
    }

    public void finishEditing() {
        SoMFVec3f.finishEditingImpl(this.getNativeResourceHandle());
    }

    public FloatBuffer startEditing() {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoMFVec3f.startEditingImpl(this.getNativeResourceHandle());
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer.asFloatBuffer();
    }

    public SoMFVec3f(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoMFVec3f.ctorImpl());
        SoMFVec3f.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public void setValue(float f, float f2, float f3) {
        this.onSetValue();
        SoMFVec3f.setValueImpl1(this.getNativeResourceHandle(), f, f2, f3);
    }

    public void set1Value(int n, float f, float f2, float f3) {
        this.onSet1Value(n);
        SoMFVec3f.set1ValueImpl1(this.getNativeResourceHandle(), n, f, f2, f3);
    }

    public void setValues(int n, SbVec3f[] sbVec3fArray) {
        int n2 = sbVec3fArray != null ? sbVec3fArray.length : 0;
        this.onSetValues(n, n2);
        SoMFVec3f.setValuesImpl(this.getNativeResourceHandle(), n, n2, sbVec3fArray);
    }

    public void setValuesBuffer(ByteBuffer byteBuffer) {
        int n = this.onSetValuesBuffer(byteBuffer);
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        SoMFVec3f.setValuesBufferImpl(this.getNativeResourceHandle(), n, byteBuffer);
    }

    public void setValue(SbVec3d sbVec3d) {
        this.onSetValue();
        SoMFVec3f.setValueImpl3(this.getNativeResourceHandle(), sbVec3d != null ? sbVec3d.array : null);
    }

    public void disableDeleteValues() {
        SoMFVec3f.disableDeleteValuesImpl(this.getNativeResourceHandle());
    }

    public void set1Value(int n, SbVec3d sbVec3d) {
        this.onSet1Value(n);
        SoMFVec3f.set1ValueImpl3(this.getNativeResourceHandle(), n, sbVec3d != null ? sbVec3d.array : null);
    }

    public void setValues(int n, float[] fArray) {
        int n2 = fArray != null ? fArray.length / 3 : 0;
        this.onSetValues(n, n2);
        if (fArray != null && fArray.length % 3 != 0) {
            throw new IllegalArgumentException("Size must be a multiple of 3");
        }
        SoMFVec3f.setValuesImpl1(this.getNativeResourceHandle(), n, n2, fArray);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoMFVec3f) {
            SoMFVec3f soMFVec3f = (SoMFVec3f)object;
            return SoMFVec3f.equalsImpl(this.getNativeResourceHandle(), soMFVec3f.getNativeResourceHandle());
        }
        return false;
    }

    public void setValue(float[] fArray) {
        this.onSetValue();
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3");
        }
        SoMFVec3f.setValueImpl2(this.getNativeResourceHandle(), fArray);
    }

    public void setValue(SbVec3f sbVec3f) {
        this.onSetValue();
        SoMFVec3f.setValueImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
    }

    public void set1Value(int n, SbVec3f sbVec3f) {
        this.onSet1Value(n);
        SoMFVec3f.set1ValueImpl(this.getNativeResourceHandle(), n, sbVec3f != null ? sbVec3f.array : null);
    }

    public void set1Value(int n, float[] fArray) {
        this.onSet1Value(n);
        if (fArray.length != 3) {
            throw new IllegalArgumentException("Expected size is 3");
        }
        SoMFVec3f.set1ValueImpl2(this.getNativeResourceHandle(), n, fArray);
    }
}

