/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.fields;

import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbDataType;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSField;
import com.openinventor.inventor.internal.JniInitializer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SoSFArray
extends SoSField {
    private ByteBuffer m_data_setValue;

    private static native boolean equalsImpl(long var0, long var2);

    private static native void setValueImpl(long var0, int[] var2, long var3, Object var5, int var6);

    private static native void setNeverWriteImpl(long var0, boolean var2);

    private static native boolean isNeverWriteImpl(long var0);

    private static native void getSizeImpl(long var0, int[] var2);

    private static native boolean isEmptyImpl(long var0);

    private static native Object getValueImpl(long var0, int[] var2, long var3);

    private static native int getDataTypeImpl(long var0);

    private static native long ctorImpl();

    private static native Object getDataImpl(long var0);

    private static native void addFieldToContainerNative(long var0, long var2, String var4, int var5);

    protected SoSFArray(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public void setValue(SbVec3i32 sbVec3i32, SbDataType sbDataType, ByteBuffer byteBuffer) {
        this.setValue(sbVec3i32, sbDataType, byteBuffer, CopyPolicies.valueOf(CopyPolicies.COPY.getValue()));
    }

    public void setNeverWrite(boolean bl) {
        SoSFArray.setNeverWriteImpl(this.getNativeResourceHandle(), bl);
    }

    public void setValue(SbVec3i32 sbVec3i32, SbDataType sbDataType, ByteBuffer byteBuffer, CopyPolicies copyPolicies) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Not a direct buffer.");
        }
        if (!byteBuffer.order().equals(ByteOrder.nativeOrder())) {
            throw new IllegalArgumentException("Buffer endian different from native endian.");
        }
        this.m_data_setValue = byteBuffer;
        if (copyPolicies == CopyPolicies.NO_COPY) {
            this.m_data_setValue = byteBuffer;
        }
        SoSFArray.setValueImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbDataType != null ? sbDataType.getNativeResourceHandle() : Inventor.ZeroHandle, byteBuffer, copyPolicies.getValue());
    }

    public boolean isEmpty() {
        return SoSFArray.isEmptyImpl(this.getNativeResourceHandle());
    }

    public SoSFArray(SoFieldContainer soFieldContainer, String string, SoField.FieldTypes fieldTypes) {
        this(Inventor.ConstructorCommand.CreateInstance, SoSFArray.ctorImpl());
        SoSFArray.addFieldToContainerNative(this.getNativeResourceHandle(), soFieldContainer == null ? 0L : soFieldContainer.getNativeResourceHandle(), string, fieldTypes.getValue());
    }

    public Array3D getValue() {
        Array3D array3D = new Array3D();
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        SbDataType sbDataType = new SbDataType();
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoSFArray.getValueImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbDataType != null ? sbDataType.getNativeResourceHandle() : Inventor.ZeroHandle);
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        array3D.buffer = byteBuffer.asReadOnlyBuffer();
        array3D.size = sbVec3i32;
        array3D.dataType = sbDataType;
        return array3D;
    }

    public ByteBuffer getData() {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoSFArray.getDataImpl(this.getNativeResourceHandle());
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public DataTypes getDataType() {
        return IntegerValuedEnumHelper.fromIntValue(DataTypes.class, SoSFArray.getDataTypeImpl(this.getNativeResourceHandle()));
    }

    public SbVec3i32 getSize() {
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        SoSFArray.getSizeImpl(this.getNativeResourceHandle(), sbVec3i32.array);
        return sbVec3i32;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SoSFArray) {
            SoSFArray soSFArray = (SoSFArray)object;
            return SoSFArray.equalsImpl(this.getNativeResourceHandle(), soSFArray.getNativeResourceHandle());
        }
        return false;
    }

    public boolean isNeverWrite() {
        return SoSFArray.isNeverWriteImpl(this.getNativeResourceHandle());
    }

    public static enum CopyPolicies implements IntegerValuedEnum
    {
        COPY(CopyPolicies.getCOPY()),
        NO_COPY(CopyPolicies.getNOCOPY());

        private int value;

        private static native int getCOPYNative();

        private static int getCOPY() {
            JniInitializer.checkInit();
            return CopyPolicies.getCOPYNative();
        }

        private static native int getNOCOPYNative();

        private static int getNOCOPY() {
            JniInitializer.checkInit();
            return CopyPolicies.getNOCOPYNative();
        }

        private CopyPolicies(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static CopyPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CopyPolicies.class, n);
        }
    }

    public static class Array3D {
        public SbVec3i32 size;
        public SbDataType dataType;
        public ByteBuffer buffer;

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum DataTypes implements IntegerValuedEnum
    {
        UNSIGNED_BYTE(DataTypes.getUNSIGNEDBYTE()),
        UNSIGNED_SHORT(DataTypes.getUNSIGNEDSHORT()),
        UNSIGNED_INT32(DataTypes.getUNSIGNEDINT32()),
        SIGNED_BYTE(DataTypes.getSIGNEDBYTE()),
        SIGNED_SHORT(DataTypes.getSIGNEDSHORT()),
        SIGNED_INT32(DataTypes.getSIGNEDINT32()),
        FLOAT(DataTypes.getFLOAT());

        private int value;

        private static native int getUNSIGNEDBYTENative();

        private static int getSIGNEDSHORT() {
            JniInitializer.checkInit();
            return DataTypes.getSIGNEDSHORTNative();
        }

        private static native int getSIGNEDINT32Native();

        private static int getSIGNEDINT32() {
            JniInitializer.checkInit();
            return DataTypes.getSIGNEDINT32Native();
        }

        private static native int getFLOATNative();

        private static int getFLOAT() {
            JniInitializer.checkInit();
            return DataTypes.getFLOATNative();
        }

        private DataTypes(int n2) {
            this.value = n2;
        }

        private static native int getSIGNEDSHORTNative();

        private static int getUNSIGNEDBYTE() {
            JniInitializer.checkInit();
            return DataTypes.getUNSIGNEDBYTENative();
        }

        private static native int getUNSIGNEDSHORTNative();

        private static int getUNSIGNEDSHORT() {
            JniInitializer.checkInit();
            return DataTypes.getUNSIGNEDSHORTNative();
        }

        private static native int getUNSIGNEDINT32Native();

        private static int getUNSIGNEDINT32() {
            JniInitializer.checkInit();
            return DataTypes.getUNSIGNEDINT32Native();
        }

        private static native int getSIGNEDBYTENative();

        private static int getSIGNEDBYTE() {
            JniInitializer.checkInit();
            return DataTypes.getSIGNEDBYTENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static DataTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(DataTypes.class, n);
        }
    }
}

