/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.image;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.image.SoRasterImageIO;
import com.openinventor.inventor.image.SoRasterImageRW;
import com.openinventor.inventor.internal.JniInitializer;

public class SoRasterReaderSet
extends Inventor {
    private static native int getNumReadersImpl();

    private static native String getReaderAtImpl(int var0);

    private static native void deleteReadersImpl(int var0, int var1);

    private static native void addReaderImpl(long var0);

    private static native long getReaderImpl(long var0);

    protected SoRasterReaderSet(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public static void deleteReaders(int n) {
        SoRasterReaderSet.deleteReaders(n, -1);
    }

    public static SoRasterImageRW getReader(SoRasterImageIO soRasterImageIO) {
        return ObjectManager.getManagedObjectFor(SoRasterImageRW.class, SoRasterReaderSet.getReaderImpl(soRasterImageIO != null ? soRasterImageIO.getNativeResourceHandle() : Inventor.ZeroHandle));
    }

    public static void addReader(SoRasterImageRW soRasterImageRW) {
        SoRasterReaderSet.addReaderImpl(soRasterImageRW != null ? soRasterImageRW.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public static void deleteReaders(int n, int n2) {
        SoRasterReaderSet.deleteReadersImpl(n, n2);
    }

    public static int getNumReaders() {
        return SoRasterReaderSet.getNumReadersImpl();
    }

    public static Class<? extends Inventor> getReaderAt(int n) {
        return NativeTypeMap.getJavaClass(SoRasterReaderSet.getReaderAtImpl(n));
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

