/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.internal;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.lock.SoLockManager;
import java.lang.reflect.Method;

public class JniInitializer {
    private static final void loadLibrairies() {
        if (!SoLockManager.isNativeLoaded()) {
            throw new IllegalStateException("Native Open Inventor Java library not yet loaded.");
        }
        int n = SoPreferences.getInteger("OIV_JAVA_VERBOSE_LEVEL", 0);
        try {
            if (n > 0) {
                System.out.println("Set up native environment");
            }
            Method method = SoPreferences.class.getDeclaredMethod("initNativeEnvironment", new Class[0]);
            ObjectManager.helperFor(SoPreferences.class).invokeMethod(method, null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JniInitializer.setNativeDebug(n > 0);
    }

    protected static native void setNativeDebug(boolean var0);

    public static void checkInit() {
    }

    static {
        JniInitializer.loadLibrairies();
    }
}

