/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.lock;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.RefCountedNativeResourceHandle;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SafeDisposable;
import com.openinventor.inventor.internal.JniInitializer;

public class SoLicenseProperty
extends Inventor
implements SafeDisposable {
    private static native String getProductNameImpl(long var0);

    private static native String getProductVersionImpl(long var0);

    private static native boolean isExpiredImpl(long var0);

    private static native String getExpirationDateImpl(long var0);

    private static native int getLicenseTypeImpl(long var0);

    private static native String getNumUsersImpl(long var0);

    private static native String getHostIDImpl(long var0);

    private static native String getCheckSumImpl(long var0);

    private static native int getDaysToExpireImpl(long var0);

    private static native long ctorImpl();

    private static native boolean isMasterPasswordImpl(long var0);

    private static native String getInfoImpl(long var0);

    protected SoLicenseProperty(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        return new RefCountedNativeResourceHandle(this, l, constructorCommand);
    }

    @Override
    public boolean isDisposable() {
        if (this.hasDispose()) {
            throw new IllegalStateException("Object already disposed.");
        }
        return this.getRefCount() == 1;
    }

    @Override
    public boolean dispose() {
        if (!this.isDisposable()) {
            throw new IllegalStateException("Object still referenced.");
        }
        this.internalDispose();
        return true;
    }

    public SoLicenseProperty() {
        this(Inventor.ConstructorCommand.CreateInstance, SoLicenseProperty.ctorImpl());
    }

    public String getProductName() {
        return SoLicenseProperty.getProductNameImpl(this.getNativeResourceHandle());
    }

    public boolean isMasterPassword() {
        return SoLicenseProperty.isMasterPasswordImpl(this.getNativeResourceHandle());
    }

    public String getProductVersion() {
        return SoLicenseProperty.getProductVersionImpl(this.getNativeResourceHandle());
    }

    public int getDaysToExpire() {
        return SoLicenseProperty.getDaysToExpireImpl(this.getNativeResourceHandle());
    }

    public String getInfo() {
        return SoLicenseProperty.getInfoImpl(this.getNativeResourceHandle());
    }

    public String getHostID() {
        return SoLicenseProperty.getHostIDImpl(this.getNativeResourceHandle());
    }

    public SbLicenseTypes getLicenseType() {
        return IntegerValuedEnumHelper.fromIntValue(SbLicenseTypes.class, SoLicenseProperty.getLicenseTypeImpl(this.getNativeResourceHandle()));
    }

    public String getNumUsers() {
        return SoLicenseProperty.getNumUsersImpl(this.getNativeResourceHandle());
    }

    public boolean isExpired() {
        return SoLicenseProperty.isExpiredImpl(this.getNativeResourceHandle());
    }

    public String getExpirationDate() {
        return SoLicenseProperty.getExpirationDateImpl(this.getNativeResourceHandle());
    }

    public String getCheckSum() {
        return SoLicenseProperty.getCheckSumImpl(this.getNativeResourceHandle());
    }

    public static enum SbLicenseTypes implements IntegerValuedEnum
    {
        SDK(SbLicenseTypes.getSDK()),
        RT(SbLicenseTypes.getRT());

        private int value;

        private static native int getSDKNative();

        private static int getSDK() {
            JniInitializer.checkInit();
            return SbLicenseTypes.getSDKNative();
        }

        private static native int getRTNative();

        private static int getRT() {
            JniInitializer.checkInit();
            return SbLicenseTypes.getRTNative();
        }

        private SbLicenseTypes(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static SbLicenseTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(SbLicenseTypes.class, n);
        }
    }
}

