/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.lock;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.errors.SoLibraryError;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SoLockManager {
    static String[] s_OivLibPath = null;
    private static final int VERBOSE_LEVEL;
    private static final boolean NATIVE_DEBUG;
    private static boolean s_loaded;
    private static final OivLibraryLoader s_libraryLoader;

    public static boolean isNativeLoaded() {
        return s_loaded;
    }

    public static void loadLibrary(String string) {
        try {
            s_libraryLoader.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string2 = System.getProperty("line.separator");
            throw new SoLibraryError(unsatisfiedLinkError.getMessage() + string2 + "Native library of \"Open Inventor Java\" cannot be loaded." + string2 + "java.library.path = " + SoPreferences.getValue("java.library.path", "<not defined>"));
        }
    }

    public static void setUnlockString(String string) {
        SoLockManager.setUnlockStringNativ(string);
    }

    private static native void setUnlockStringNativ(String var0);

    @Deprecated(since="10.8")
    public static String getUnlockString() {
        return null;
    }

    public static void appendUnlockString(String string) {
        SoLockManager.appendUnlockStringNativ(string);
    }

    private static native void appendUnlockStringNativ(String var0);

    static {
        s_loaded = false;
        VERBOSE_LEVEL = SoPreferences.getInteger("OIV_JAVA_VERBOSE_LEVEL", 0);
        NATIVE_DEBUG = SoPreferences.getBoolean("OIV_JAVA_LOAD_DEBUG_NATIVE_LIBRARIES", false);
        final String string = System.getProperty("os.name");
        s_libraryLoader = string.startsWith("Windows") ? new Win32OivLibraryLoader() : new UnixOivLibraryLoader();
        String string2 = SoPreferences.getValue("OIV_LIBRARY_PATH");
        if (string2 != null && string2.length() != 0) {
            s_OivLibPath = string2.split(File.pathSeparator);
        }
        if (VERBOSE_LEVEL > 0) {
            System.out.println("Loading Open Inventor Java Native Interface library...");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    if (string.startsWith("Mac")) {
                        s_libraryLoader.loadLibrary("com.openinventor.inventor");
                    } else if (string.startsWith("Windows")) {
                        if (NATIVE_DEBUG) {
                            s_libraryLoader.loadLibrary("fei_boost_system-mt-gd");
                            s_libraryLoader.loadLibrary("fei_boost_chrono-mt-gd");
                            s_libraryLoader.loadLibrary("fei_boost_thread-mt-gd");
                            s_libraryLoader.loadLibrary("fei_boost_regex-mt-gd");
                            s_libraryLoader.loadLibrary("fei_inventor_baseD");
                            s_libraryLoader.loadLibrary("fei_boost_date_time-mt-gd");
                            s_libraryLoader.loadLibrary("fei_boost_filesystem-mt-gd");
                            s_libraryLoader.loadLibrary("fei_boost_log-mt-gd");
                            s_libraryLoader.loadLibrary("fei_boost_iostreams-mt-gd");
                            s_libraryLoader.loadLibrary("fei_glewD");
                            s_libraryLoader.loadLibrary("fei_inventor_renderengineD");
                            s_libraryLoader.loadLibrary("fei_inventor_glD");
                            s_libraryLoader.loadLibrary("fei_inventor_imageD");
                            s_libraryLoader.loadLibrary("iolinkd");
                            s_libraryLoader.loadLibrary("ioformatd");
                            s_libraryLoader.loadLibrary("fei_tbbD");
                            s_libraryLoader.loadLibrary("fei_inventorD");
                            s_libraryLoader.loadLibrary("fei_inventor_computing_algorithmsD");
                            s_libraryLoader.loadLibrary("fei_scalevizD");
                            s_libraryLoader.loadLibrary("fei_inventor_uiD");
                            s_libraryLoader.loadLibrary("com.openinventor.inventorD");
                        } else {
                            s_libraryLoader.loadLibrary("fei_boost_system-mt");
                            s_libraryLoader.loadLibrary("fei_boost_chrono-mt");
                            s_libraryLoader.loadLibrary("fei_boost_thread-mt");
                            s_libraryLoader.loadLibrary("fei_boost_regex-mt");
                            s_libraryLoader.loadLibrary("fei_inventor_base");
                            s_libraryLoader.loadLibrary("fei_boost_date_time-mt");
                            s_libraryLoader.loadLibrary("fei_boost_filesystem-mt");
                            s_libraryLoader.loadLibrary("fei_boost_log-mt");
                            s_libraryLoader.loadLibrary("fei_boost_iostreams-mt");
                            s_libraryLoader.loadLibrary("fei_glew");
                            s_libraryLoader.loadLibrary("fei_inventor_renderengine");
                            s_libraryLoader.loadLibrary("fei_inventor_gl");
                            s_libraryLoader.loadLibrary("fei_inventor_image");
                            s_libraryLoader.loadLibrary("iolink");
                            s_libraryLoader.loadLibrary("ioformat");
                            s_libraryLoader.loadLibrary("fei_tbb");
                            s_libraryLoader.loadLibrary("fei_inventor");
                            s_libraryLoader.loadLibrary("fei_inventor_computing_algorithms");
                            s_libraryLoader.loadLibrary("fei_scaleviz");
                            s_libraryLoader.loadLibrary("fei_inventor_ui");
                            s_libraryLoader.loadLibrary("com.openinventor.inventor");
                        }
                    } else {
                        if (NATIVE_DEBUG) {
                            s_libraryLoader.loadLibrary("fei_boost_system-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_chrono-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_thread-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_date_time-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_filesystem-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_atomic-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_regex-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_log-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_iostreams-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_random-mt-d");
                            s_libraryLoader.loadLibrary("fei_boost_serialization-mt-d");
                        } else {
                            s_libraryLoader.loadLibrary("fei_boost_system-mt");
                            s_libraryLoader.loadLibrary("fei_boost_chrono-mt");
                            s_libraryLoader.loadLibrary("fei_boost_thread-mt");
                            s_libraryLoader.loadLibrary("fei_boost_date_time-mt");
                            s_libraryLoader.loadLibrary("fei_boost_filesystem-mt");
                            s_libraryLoader.loadLibrary("fei_boost_atomic-mt");
                            s_libraryLoader.loadLibrary("fei_boost_regex-mt");
                            s_libraryLoader.loadLibrary("fei_boost_log-mt");
                            s_libraryLoader.loadLibrary("fei_boost_iostreams-mt");
                            s_libraryLoader.loadLibrary("fei_boost_random-mt");
                            s_libraryLoader.loadLibrary("fei_boost_serialization-mt");
                        }
                        s_libraryLoader.loadLibrary("fei_inventor_base");
                        s_libraryLoader.loadLibrary("fei_glew");
                        s_libraryLoader.loadLibrary("fei_inventor_renderEngine");
                        s_libraryLoader.loadLibrary("fei_inventor_gl");
                        s_libraryLoader.loadLibrary("fei_inventor_image");
                        s_libraryLoader.loadLibrary("iolink");
                        s_libraryLoader.loadLibrary("ioformat");
                        s_libraryLoader.loadLibrary("fei_tbb");
                        s_libraryLoader.loadLibrary("fei_tbbmalloc");
                        s_libraryLoader.loadLibrary("fei_tbbmalloc_proxy");
                        s_libraryLoader.loadLibrary("fei_inventor");
                        s_libraryLoader.loadLibrary("fei_inventor_computing_algorithms");
                        s_libraryLoader.loadLibrary("fei_scaleViz");
                        s_libraryLoader.loadLibrary("fei_inventor_ui");
                        s_libraryLoader.loadLibrary("com.openinventor.inventor");
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    String string2 = System.getProperty("line.separator");
                    throw new SoLibraryError(unsatisfiedLinkError.getMessage() + string2 + "Native library of \"Open Inventor Java\" cannot be loaded." + string2 + "java.library.path = " + SoPreferences.getValue("java.library.path", "<not defined>"));
                }
                return null;
            }
        });
        s_loaded = true;
    }

    static abstract class OivLibraryLoader {
        protected OivLibraryLoader() {
        }

        void loadLibrary(String string) throws UnsatisfiedLinkError {
            if (VERBOSE_LEVEL > 0) {
                System.out.println("Loading " + string + "...");
            }
            System.loadLibrary(string);
        }
    }

    static class Win32OivLibraryLoader
    extends OivLibraryLoader {
        private final String m_extension;

        Win32OivLibraryLoader() {
            this.m_extension = ".dll";
        }

        @Override
        void loadLibrary(String string) throws UnsatisfiedLinkError {
            block7: {
                try {
                    super.loadLibrary(string);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    Object object = unsatisfiedLinkError.getMessage();
                    boolean bl = false;
                    if (s_OivLibPath != null) {
                        String string2 = string + this.m_extension;
                        for (int i = 0; i < s_OivLibPath.length; ++i) {
                            String string3 = s_OivLibPath[i] + File.separator + string2;
                            if (VERBOSE_LEVEL > 0) {
                                System.out.println("Loading " + string3 + "...");
                            }
                            try {
                                System.load(string3);
                                bl = true;
                                break;
                            }
                            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                                object = (String)object + System.getProperty("line.separator") + unsatisfiedLinkError2.getMessage();
                                if (VERBOSE_LEVEL <= 0) continue;
                                System.out.println("Fail to load " + string3 + ".");
                                continue;
                            }
                        }
                    }
                    if (bl) break block7;
                    throw new UnsatisfiedLinkError((String)object);
                }
            }
        }
    }

    static class UnixOivLibraryLoader
    extends OivLibraryLoader {
        UnixOivLibraryLoader() {
        }
    }
}

