/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.misc;

import com.openinventor.internal.AbstractNativeResourceHandle;
import com.openinventor.internal.DeletableNativeResourceHandle;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class SoByteStream
extends Inventor {
    private static native Object getDataImpl(long var0);

    private static native long[] unconvertImpl(long var0);

    private static native long ctorImpl();

    private static native long getNumBytesImpl(long var0);

    private static native void convertImpl(long var0, long var2, boolean var4);

    private static native void convertImpl1(long var0, long var2, boolean var4);

    protected SoByteStream(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    @Override
    protected AbstractNativeResourceHandle createHandleForNativeResource(Inventor.ConstructorCommand constructorCommand, long l) {
        if (constructorCommand != Inventor.ConstructorCommand.CreateInstance) {
            return new com.openinventor.internal.NativeResourceHandle(this, l, constructorCommand);
        }
        return new NativeResourceHandle(this, l, constructorCommand);
    }

    public void convert(SoPath soPath) {
        this.convert(soPath, true);
    }

    public void convert(SoNode soNode) {
        this.convert(soNode, true);
    }

    public SoByteStream() {
        this(Inventor.ConstructorCommand.CreateInstance, SoByteStream.ctorImpl());
    }

    public void convert(SoPath soPath, boolean bl) {
        SoByteStream.convertImpl1(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
    }

    public long getNumBytes() {
        return SoByteStream.getNumBytesImpl(this.getNativeResourceHandle());
    }

    public void convert(SoNode soNode, boolean bl) {
        SoByteStream.convertImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, bl);
    }

    public ByteBuffer getData() {
        ByteBuffer byteBuffer = null;
        byteBuffer = (ByteBuffer)SoByteStream.getDataImpl(this.getNativeResourceHandle());
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            byteBuffer.order(ByteOrder.nativeOrder());
        }
        return byteBuffer;
    }

    public static Vector<SoPath> unconvert(SoByteStream soByteStream) {
        Vector<SoPath> vector = null;
        vector = SoByteStream.toVector(SoPath.class, SoByteStream.unconvertImpl(soByteStream != null ? soByteStream.getNativeResourceHandle() : Inventor.ZeroHandle));
        return vector;
    }

    private static final class NativeResourceHandle
    extends DeletableNativeResourceHandle {
        private static native void deleteNativeHandleImpl(long var0);

        public NativeResourceHandle(Inventor inventor, long l, Inventor.ConstructorCommand constructorCommand) {
            super(inventor, l, constructorCommand);
        }

        @Override
        protected void deleteNativeHandle(long l) {
            NativeResourceHandle.deleteNativeHandleImpl(l);
        }

        static {
            JniInitializer.checkInit();
        }
    }
}

