/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoMFNode;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFNode;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoShape;

public abstract class SoAlgebraicShape
extends SoShape {
    public final SoSFNode rayIntersection;
    public final SoSFEnum<ASWorkSpaces> workspace;
    public final SoMFNode shaderSlots;
    public final SoSFBool generateTransparency;

    protected SoAlgebraicShape(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.rayIntersection = ObjectManager.getManagedObjectFor(SoSFNode.class, SoAlgebraicShape.getFieldHandle(this.getNativeResourceHandle(), "rayIntersection"));
        this.workspace = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoAlgebraicShape.getFieldHandle(this.getNativeResourceHandle(), "workspace"), ASWorkSpaces.class);
        this.shaderSlots = ObjectManager.getManagedObjectFor(SoMFNode.class, SoAlgebraicShape.getFieldHandle(this.getNativeResourceHandle(), "shaderSlots"));
        this.generateTransparency = ObjectManager.getManagedObjectFor(SoSFBool.class, SoAlgebraicShape.getFieldHandle(this.getNativeResourceHandle(), "generateTransparency"));
    }

    static native String getClassTypeId();

    public static enum ASWorkSpaces implements IntegerValuedEnum
    {
        BOX(ASWorkSpaces.getBOX()),
        CAMERA(ASWorkSpaces.getCAMERA()),
        WORLD(ASWorkSpaces.getWORLD()),
        MAX_WORK_SPACE(ASWorkSpaces.getMAXWORKSPACE());

        private int value;

        private static native int getBOXNative();

        private ASWorkSpaces(int n2) {
            this.value = n2;
        }

        private static int getMAXWORKSPACE() {
            JniInitializer.checkInit();
            return ASWorkSpaces.getMAXWORKSPACENative();
        }

        private static native int getMAXWORKSPACENative();

        private static int getWORLD() {
            JniInitializer.checkInit();
            return ASWorkSpaces.getWORLDNative();
        }

        private static native int getWORLDNative();

        private static int getCAMERA() {
            JniInitializer.checkInit();
            return ASWorkSpaces.getCAMERANative();
        }

        private static native int getCAMERANative();

        private static int getBOX() {
            JniInitializer.checkInit();
            return ASWorkSpaces.getBOXNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ASWorkSpaces valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ASWorkSpaces.class, n);
        }
    }

    public static enum ASClippingPolicies implements IntegerValuedEnum
    {
        STANDARD(ASClippingPolicies.getSTANDARD()),
        FULL_SHAPE(ASClippingPolicies.getFULLSHAPE());

        private int value;

        private static native int getSTANDARDNative();

        private static int getSTANDARD() {
            JniInitializer.checkInit();
            return ASClippingPolicies.getSTANDARDNative();
        }

        private static native int getFULLSHAPENative();

        private static int getFULLSHAPE() {
            JniInitializer.checkInit();
            return ASClippingPolicies.getFULLSHAPENative();
        }

        private ASClippingPolicies(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ASClippingPolicies valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ASClippingPolicies.class, n);
        }
    }

    public static enum ASShaderSlots implements IntegerValuedEnum
    {
        COMPUTE_COLOR(ASShaderSlots.getCOMPUTECOLOR()),
        VERTEX_SHADER_ENTRY(ASShaderSlots.getVERTEXSHADERENTRY()),
        MAX_SHADER_SLOT(ASShaderSlots.getMAXSHADERSLOT());

        private int value;

        private static native int getCOMPUTECOLORNative();

        private ASShaderSlots(int n2) {
            this.value = n2;
        }

        private static int getMAXSHADERSLOT() {
            JniInitializer.checkInit();
            return ASShaderSlots.getMAXSHADERSLOTNative();
        }

        private static native int getMAXSHADERSLOTNative();

        private static int getVERTEXSHADERENTRY() {
            JniInitializer.checkInit();
            return ASShaderSlots.getVERTEXSHADERENTRYNative();
        }

        private static native int getVERTEXSHADERENTRYNative();

        private static int getCOMPUTECOLOR() {
            JniInitializer.checkInit();
            return ASShaderSlots.getCOMPUTECOLORNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ASShaderSlots valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ASShaderSlots.class, n);
        }
    }
}

