/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFNode;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoShape;

public class SoCSGShape
extends SoShape {
    public final SoSFNode leftOperand;
    public final SoSFNode rightOperand;
    public final SoSFEnum<CsgOperationTypes> csgOperation;

    private static native long ctorImpl();

    private static native void setMaxAttemptImpl(long var0, int var2);

    private static native int getStatusImpl(long var0);

    private static native void setRescueOperationImpl(int var0);

    protected SoCSGShape(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.leftOperand = ObjectManager.getManagedObjectFor(SoSFNode.class, SoCSGShape.getFieldHandle(this.getNativeResourceHandle(), "leftOperand"));
        this.rightOperand = ObjectManager.getManagedObjectFor(SoSFNode.class, SoCSGShape.getFieldHandle(this.getNativeResourceHandle(), "rightOperand"));
        this.csgOperation = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoCSGShape.getFieldHandle(this.getNativeResourceHandle(), "csgOperation"), CsgOperationTypes.class);
    }

    static native String getClassTypeId();

    public static void setRescueOperation(CsgOperationTypes csgOperationTypes) {
        SoCSGShape.setRescueOperationImpl(csgOperationTypes.getValue());
    }

    public SoCSGShape() {
        this(Inventor.ConstructorCommand.CreateInstance, SoCSGShape.ctorImpl());
    }

    public void setMaxAttempt(int n) {
        SoCSGShape.setMaxAttemptImpl(this.getNativeResourceHandle(), n);
    }

    public CsgStatus getStatus() {
        return IntegerValuedEnumHelper.fromIntValue(CsgStatus.class, SoCSGShape.getStatusImpl(this.getNativeResourceHandle()));
    }

    public static enum CsgOperationTypes implements IntegerValuedEnum
    {
        ADD(CsgOperationTypes.getADD()),
        SUB(CsgOperationTypes.getSUB()),
        INTERSECTION(CsgOperationTypes.getINTERSECTION()),
        LEFT_ONLY(CsgOperationTypes.getLEFTONLY()),
        RIGHT_ONLY(CsgOperationTypes.getRIGHTONLY()),
        NOTHING(CsgOperationTypes.getNOTHING()),
        ALL(CsgOperationTypes.getALL());

        private int value;

        private static native int getADDNative();

        private static int getRIGHTONLY() {
            JniInitializer.checkInit();
            return CsgOperationTypes.getRIGHTONLYNative();
        }

        private static native int getNOTHINGNative();

        private static int getNOTHING() {
            JniInitializer.checkInit();
            return CsgOperationTypes.getNOTHINGNative();
        }

        private static native int getALLNative();

        private static int getALL() {
            JniInitializer.checkInit();
            return CsgOperationTypes.getALLNative();
        }

        private CsgOperationTypes(int n2) {
            this.value = n2;
        }

        private static native int getRIGHTONLYNative();

        private static int getADD() {
            JniInitializer.checkInit();
            return CsgOperationTypes.getADDNative();
        }

        private static native int getSUBNative();

        private static int getSUB() {
            JniInitializer.checkInit();
            return CsgOperationTypes.getSUBNative();
        }

        private static native int getINTERSECTIONNative();

        private static int getINTERSECTION() {
            JniInitializer.checkInit();
            return CsgOperationTypes.getINTERSECTIONNative();
        }

        private static native int getLEFTONLYNative();

        private static int getLEFTONLY() {
            JniInitializer.checkInit();
            return CsgOperationTypes.getLEFTONLYNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static CsgOperationTypes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CsgOperationTypes.class, n);
        }
    }

    public static enum CsgStatus implements IntegerValuedEnum
    {
        CSG_NO_ERROR(CsgStatus.getCSGNOERROR()),
        CSG_LIB_NOT_AVAILABLE(CsgStatus.getCSGLIBNOTAVAILABLE()),
        CSG_ERROR(CsgStatus.getCSGERROR());

        private int value;

        private static native int getCSGNOERRORNative();

        private CsgStatus(int n2) {
            this.value = n2;
        }

        private static int getCSGERROR() {
            JniInitializer.checkInit();
            return CsgStatus.getCSGERRORNative();
        }

        private static native int getCSGERRORNative();

        private static int getCSGLIBNOTAVAILABLE() {
            JniInitializer.checkInit();
            return CsgStatus.getCSGLIBNOTAVAILABLENative();
        }

        private static native int getCSGLIBNOTAVAILABLENative();

        private static int getCSGNOERROR() {
            JniInitializer.checkInit();
            return CsgStatus.getCSGNOERRORNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static CsgStatus valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(CsgStatus.class, n);
        }
    }
}

