/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbRotation;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewVolume;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFRotation;
import com.openinventor.inventor.fields.SoSFVec3f;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public abstract class SoCamera
extends SoNode {
    public final SoSFEnum<ViewportMappings> viewportMapping;
    public final SoSFVec3f position;
    public final SoSFRotation orientation;
    public final SoSFFloat aspectRatio;
    public final SoSFFloat nearDistance;
    public final SoSFFloat farDistance;
    public final SoSFFloat focalDistance;
    public final SoSFFloat blur;
    public final SoSFEnum<ExposureModes> exposureMode;
    public final SoSFFloat exposureCompensation;

    private static native void allowStereoImpl(long var0, boolean var2);

    private static native void viewAllImpl(long var0, long var2, long var4, float var6);

    private static native void setStereoModeImpl(long var0, int var2);

    private static native void viewAllImpl1(long var0, long var2, long var4, float var6);

    private static native void viewAllImpl2(long var0, float[] var2, long var3);

    private static native boolean isBalanceAdjustmentNearFracImpl(long var0);

    private static native void getViewportBoundsImpl(long var0, long var2, long var4);

    private static native void setStereoAbsoluteAdjustmentsImpl(long var0, boolean var2);

    private static native boolean getStereoAbsoluteAdjustmentImpl(long var0);

    private static native float getStereoAdjustmentImpl(long var0);

    private static native void setBalanceAdjustmentImpl(long var0, float var2, boolean var3);

    private static native void setStereoAdjustmentImpl(long var0, float var2);

    private static native float getBalanceAdjustmentImpl(long var0);

    private static native int getStereoModeImpl(long var0);

    private static native void getViewVolumeImpl1(long var0, float var2, float var3, float var4, float[] var5, float[] var6, long var7);

    private static native void getViewVolumeImpl(long var0, float var2, long var3);

    private static native void pointAtImpl(long var0, float[] var2);

    private static native void scaleHeightImpl(long var0, float var2);

    protected SoCamera(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.viewportMapping = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "viewportMapping"), ViewportMappings.class);
        this.position = ObjectManager.getManagedObjectFor(SoSFVec3f.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "position"));
        this.orientation = ObjectManager.getManagedObjectFor(SoSFRotation.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "orientation"));
        this.aspectRatio = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "aspectRatio"));
        this.nearDistance = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "nearDistance"));
        this.farDistance = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "farDistance"));
        this.focalDistance = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "focalDistance"));
        this.blur = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "blur"));
        this.exposureMode = ObjectManager.getManagedObjectFor(SoSFEnum.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "exposureMode"), ExposureModes.class);
        this.exposureCompensation = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCamera.getFieldHandle(this.getNativeResourceHandle(), "exposureCompensation"));
    }

    static native String getClassTypeId();

    public void viewAll(SoPath soPath, SbViewportRegion sbViewportRegion) {
        this.viewAll(soPath, sbViewportRegion, 1.0f);
    }

    public void viewAll(SoNode soNode, SbViewportRegion sbViewportRegion) {
        this.viewAll(soNode, sbViewportRegion, 1.0f);
    }

    public SbViewVolume getViewVolume() {
        return this.getViewVolume(0.0f);
    }

    @Deprecated(since="9.7.0.0")
    public void setBalanceAdjustment(float f) {
        this.setBalanceAdjustment(f, false);
    }

    public void pointAt(SbVec3f sbVec3f) {
        SoCamera.pointAtImpl(this.getNativeResourceHandle(), sbVec3f != null ? sbVec3f.array : null);
    }

    public void scaleHeight(float f) {
        SoCamera.scaleHeightImpl(this.getNativeResourceHandle(), f);
    }

    public SbViewVolume getViewVolume(float f) {
        SbViewVolume sbViewVolume = new SbViewVolume();
        SoCamera.getViewVolumeImpl(this.getNativeResourceHandle(), f, sbViewVolume.getNativeResourceHandle());
        return sbViewVolume;
    }

    @Deprecated(since="9.7.0.0")
    public boolean isBalanceAdjustmentNearFrac() {
        return SoCamera.isBalanceAdjustmentNearFracImpl(this.getNativeResourceHandle());
    }

    @Deprecated(since="9.7.0.0")
    public void setStereoAdjustment(float f) {
        SoCamera.setStereoAdjustmentImpl(this.getNativeResourceHandle(), f);
    }

    @Deprecated(since="9.7.0.0")
    public float getBalanceAdjustment() {
        return SoCamera.getBalanceAdjustmentImpl(this.getNativeResourceHandle());
    }

    @Deprecated(since="9.7.0.0")
    public float getStereoAdjustment() {
        return SoCamera.getStereoAdjustmentImpl(this.getNativeResourceHandle());
    }

    @Deprecated(since="9.7.0.0")
    public void setBalanceAdjustment(float f, boolean bl) {
        SoCamera.setBalanceAdjustmentImpl(this.getNativeResourceHandle(), f, bl);
    }

    @Deprecated(since="9.7.0.0")
    public void setStereoAbsoluteAdjustments(boolean bl) {
        SoCamera.setStereoAbsoluteAdjustmentsImpl(this.getNativeResourceHandle(), bl);
    }

    public SbViewportRegion getViewportBounds(SbViewportRegion sbViewportRegion) {
        SbViewportRegion sbViewportRegion2 = new SbViewportRegion();
        SoCamera.getViewportBoundsImpl(this.getNativeResourceHandle(), sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewportRegion2.getNativeResourceHandle());
        return sbViewportRegion2;
    }

    @Deprecated(since="9.7.0.0")
    public boolean getStereoAbsoluteAdjustment() {
        return SoCamera.getStereoAbsoluteAdjustmentImpl(this.getNativeResourceHandle());
    }

    public void viewAll(SoNode soNode, SbViewportRegion sbViewportRegion, float f) {
        SoCamera.viewAllImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle, f);
    }

    public StereoModes getStereoMode() {
        return IntegerValuedEnumHelper.fromIntValue(StereoModes.class, SoCamera.getStereoModeImpl(this.getNativeResourceHandle()));
    }

    public void viewAll(SoPath soPath, SbViewportRegion sbViewportRegion, float f) {
        SoCamera.viewAllImpl1(this.getNativeResourceHandle(), soPath != null ? soPath.getNativeResourceHandle() : Inventor.ZeroHandle, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle, f);
    }

    public void setStereoMode(StereoModes stereoModes) {
        SoCamera.setStereoModeImpl(this.getNativeResourceHandle(), stereoModes.getValue());
    }

    public void viewAll(SbBox3f sbBox3f, SbViewportRegion sbViewportRegion) {
        SoCamera.viewAllImpl2(this.getNativeResourceHandle(), sbBox3f != null ? sbBox3f.array : null, sbViewportRegion != null ? sbViewportRegion.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    @Deprecated(since="9.7.0.0")
    public void allowStereo(boolean bl) {
        SoCamera.allowStereoImpl(this.getNativeResourceHandle(), bl);
    }

    public SbViewVolume getViewVolume(float f, float f2, float f3, SbVec3f sbVec3f, SbRotation sbRotation) {
        SbViewVolume sbViewVolume = new SbViewVolume();
        SoCamera.getViewVolumeImpl1(this.getNativeResourceHandle(), f, f2, f3, sbVec3f != null ? sbVec3f.array : null, sbRotation != null ? sbRotation.array : null, sbViewVolume.getNativeResourceHandle());
        return sbViewVolume;
    }

    public static enum ViewportMappings implements IntegerValuedEnum
    {
        CROP_VIEWPORT_FILL_FRAME(ViewportMappings.getCROPVIEWPORTFILLFRAME()),
        CROP_VIEWPORT_LINE_FRAME(ViewportMappings.getCROPVIEWPORTLINEFRAME()),
        CROP_VIEWPORT_NO_FRAME(ViewportMappings.getCROPVIEWPORTNOFRAME()),
        ADJUST_CAMERA(ViewportMappings.getADJUSTCAMERA()),
        LEAVE_ALONE(ViewportMappings.getLEAVEALONE());

        private int value;

        private static native int getCROPVIEWPORTFILLFRAMENative();

        private ViewportMappings(int n2) {
            this.value = n2;
        }

        private static int getLEAVEALONE() {
            JniInitializer.checkInit();
            return ViewportMappings.getLEAVEALONENative();
        }

        private static native int getLEAVEALONENative();

        private static int getADJUSTCAMERA() {
            JniInitializer.checkInit();
            return ViewportMappings.getADJUSTCAMERANative();
        }

        private static native int getADJUSTCAMERANative();

        private static int getCROPVIEWPORTFILLFRAME() {
            JniInitializer.checkInit();
            return ViewportMappings.getCROPVIEWPORTFILLFRAMENative();
        }

        private static native int getCROPVIEWPORTLINEFRAMENative();

        private static int getCROPVIEWPORTLINEFRAME() {
            JniInitializer.checkInit();
            return ViewportMappings.getCROPVIEWPORTLINEFRAMENative();
        }

        private static native int getCROPVIEWPORTNOFRAMENative();

        private static int getCROPVIEWPORTNOFRAME() {
            JniInitializer.checkInit();
            return ViewportMappings.getCROPVIEWPORTNOFRAMENative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ViewportMappings valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ViewportMappings.class, n);
        }
    }

    public static enum ExposureModes implements IntegerValuedEnum
    {
        LDR_LINEAR(ExposureModes.getLDRLINEAR()),
        HDR_NEUTRAL(ExposureModes.getHDRNEUTRAL());

        private int value;

        private static native int getLDRLINEARNative();

        private static int getLDRLINEAR() {
            JniInitializer.checkInit();
            return ExposureModes.getLDRLINEARNative();
        }

        private static native int getHDRNEUTRALNative();

        private static int getHDRNEUTRAL() {
            JniInitializer.checkInit();
            return ExposureModes.getHDRNEUTRALNative();
        }

        private ExposureModes(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static ExposureModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(ExposureModes.class, n);
        }
    }

    public static enum StereoModes implements IntegerValuedEnum
    {
        MONOSCOPIC(StereoModes.getMONOSCOPIC()),
        LEFT_VIEW(StereoModes.getLEFTVIEW()),
        RIGHT_VIEW(StereoModes.getRIGHTVIEW());

        private int value;

        private static native int getMONOSCOPICNative();

        private StereoModes(int n2) {
            this.value = n2;
        }

        private static int getRIGHTVIEW() {
            JniInitializer.checkInit();
            return StereoModes.getRIGHTVIEWNative();
        }

        private static native int getRIGHTVIEWNative();

        private static int getLEFTVIEW() {
            JniInitializer.checkInit();
            return StereoModes.getLEFTVIEWNative();
        }

        private static native int getLEFTVIEWNative();

        private static int getMONOSCOPIC() {
            JniInitializer.checkInit();
            return StereoModes.getMONOSCOPICNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static StereoModes valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(StereoModes.class, n);
        }
    }
}

