/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBitMask;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoShape;

public class SoCone
extends SoShape {
    public final SoSFBitMask<PartType> parts;
    public final SoSFFloat bottomRadius;
    public final SoSFFloat height;

    private static native boolean hasPartImpl(long var0, int var2);

    private static native void removePartImpl(long var0, int var2);

    private static native void addPartImpl(long var0, int var2);

    private static native long ctorImpl();

    protected SoCone(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.parts = ObjectManager.getManagedObjectFor(SoSFBitMask.class, SoCone.getFieldHandle(this.getNativeResourceHandle(), "parts"), PartType.class);
        this.bottomRadius = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCone.getFieldHandle(this.getNativeResourceHandle(), "bottomRadius"));
        this.height = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoCone.getFieldHandle(this.getNativeResourceHandle(), "height"));
    }

    static native String getClassTypeId();

    public void removePart(PartType partType) {
        SoCone.removePartImpl(this.getNativeResourceHandle(), partType.getValue());
    }

    public void addPart(PartType partType) {
        SoCone.addPartImpl(this.getNativeResourceHandle(), partType.getValue());
    }

    public SoCone() {
        this(Inventor.ConstructorCommand.CreateInstance, SoCone.ctorImpl());
    }

    public boolean hasPart(PartType partType) {
        return SoCone.hasPartImpl(this.getNativeResourceHandle(), partType.getValue());
    }

    public static enum PartType implements IntegerValuedEnum
    {
        SIDES(PartType.getSIDES()),
        BOTTOM(PartType.getBOTTOM()),
        ALL(PartType.getALL());

        private int value;

        private static native int getSIDESNative();

        private PartType(int n2) {
            this.value = n2;
        }

        private static int getALL() {
            JniInitializer.checkInit();
            return PartType.getALLNative();
        }

        private static native int getALLNative();

        private static int getBOTTOM() {
            JniInitializer.checkInit();
            return PartType.getBOTTOMNative();
        }

        private static native int getBOTTOMNative();

        private static int getSIDES() {
            JniInitializer.checkInit();
            return PartType.getSIDESNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static PartType valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(PartType.class, n);
        }
    }
}

