/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.nodes.SoNode;
import java.util.ArrayList;

public class SoGroup
extends SoNode {
    public final SoSFBool boundingBoxIgnoring;
    protected ArrayList<SoNode> childList = new ArrayList();

    private int getLocalChildIndex(SoNode soNode) {
        if (soNode == null) {
            return -1;
        }
        long l = soNode.getNativeResourceHandle();
        int n = 0;
        for (SoNode soNode2 : this.childList) {
            if (soNode2.getNativeResourceHandle() == l) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void onRemoveAllChildren() {
        this.childList.clear();
    }

    private void onRemoveChild(int n) {
        SoNode soNode = this.getChild(n);
        this.onRemoveChild(soNode);
    }

    private void onRemoveChild(SoNode soNode) {
        int n = this.getLocalChildIndex(soNode);
        if (n >= 0) {
            this.childList.remove(n);
        }
    }

    private void onReplaceChild(int n, SoNode soNode) {
        SoNode soNode2 = this.getChild(n);
        this.onReplaceChild(soNode2, soNode);
    }

    private void onReplaceChild(SoNode soNode, SoNode soNode2) {
        int n = this.getLocalChildIndex(soNode);
        if (n >= 0) {
            this.childList.set(n, soNode2);
        }
    }

    private void onAddChild(SoNode soNode) {
        this.childList.add(soNode);
    }

    private void onInsertChild(SoNode soNode, int n) {
        this.childList.add(soNode);
    }

    @Override
    protected void preMortenClean() {
        int n = this.getNumChildren();
        for (int i = n - 1; i >= 0; --i) {
            SoNode soNode = this.getChild(i);
            this.removeChild(i);
            if (!soNode.isDisposable()) continue;
            soNode.dispose();
        }
        super.preMortenClean();
    }

    private static native int findChildImpl(long var0, long var2);

    private static native void removeChildImpl(long var0, int var2);

    private static native void addChildImpl(long var0, long var2);

    private static native void insertChildImpl(long var0, long var2, int var4);

    private static native int getNumChildrenImpl(long var0);

    private static native long getChildImpl(long var0, int var2);

    private static native long ctorImpl1(int var0);

    private static native void replaceChildImpl1(long var0, long var2, long var4);

    private static native void replaceChildImpl(long var0, int var2, long var3);

    private static native void removeAllChildrenImpl(long var0);

    private static native long ctorImpl();

    private static native void removeChildImpl1(long var0, long var2);

    protected SoGroup(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.boundingBoxIgnoring = ObjectManager.getManagedObjectFor(SoSFBool.class, SoGroup.getFieldHandle(this.getNativeResourceHandle(), "boundingBoxIgnoring"));
    }

    static native String getClassTypeId();

    public SoGroup(int n) {
        this(Inventor.ConstructorCommand.CreateInstance, SoGroup.ctorImpl1(n));
    }

    public SoGroup() {
        this(Inventor.ConstructorCommand.CreateInstance, SoGroup.ctorImpl());
    }

    public void insertChild(SoNode soNode, int n) {
        this.onInsertChild(soNode, n);
        SoGroup.insertChildImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, n);
    }

    public void addChild(SoNode soNode) {
        this.onAddChild(soNode);
        SoGroup.addChildImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SoNode getChild(int n) {
        return ObjectManager.getManagedObjectFor(SoNode.class, SoGroup.getChildImpl(this.getNativeResourceHandle(), n));
    }

    public int findChild(SoNode soNode) {
        return SoGroup.findChildImpl(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public int getNumChildren() {
        return SoGroup.getNumChildrenImpl(this.getNativeResourceHandle());
    }

    public void removeChild(int n) {
        this.onRemoveChild(n);
        SoGroup.removeChildImpl(this.getNativeResourceHandle(), n);
    }

    public void removeChild(SoNode soNode) {
        this.onRemoveChild(soNode);
        SoGroup.removeChildImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void removeAllChildren() {
        this.onRemoveAllChildren();
        SoGroup.removeAllChildrenImpl(this.getNativeResourceHandle());
    }

    public void replaceChild(SoNode soNode, SoNode soNode2) {
        this.onReplaceChild(soNode, soNode2);
        SoGroup.replaceChildImpl1(this.getNativeResourceHandle(), soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle, soNode2 != null ? soNode2.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public void replaceChild(int n, SoNode soNode) {
        this.onReplaceChild(n, soNode);
        SoGroup.replaceChildImpl(this.getNativeResourceHandle(), n, soNode != null ? soNode.getNativeResourceHandle() : Inventor.ZeroHandle);
    }
}

