/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.nodes;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.fields.SoSFBitMask;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.internal.JniInitializer;
import com.openinventor.inventor.nodes.SoNode;

public class SoPolygonOffset
extends SoNode {
    public final SoSFFloat factor;
    public final SoSFFloat units;
    public final SoSFBitMask<StyleType> styles;
    public final SoSFBool on;

    private static native long ctorImpl();

    protected SoPolygonOffset(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
        this.factor = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoPolygonOffset.getFieldHandle(this.getNativeResourceHandle(), "factor"));
        this.units = ObjectManager.getManagedObjectFor(SoSFFloat.class, SoPolygonOffset.getFieldHandle(this.getNativeResourceHandle(), "units"));
        this.styles = ObjectManager.getManagedObjectFor(SoSFBitMask.class, SoPolygonOffset.getFieldHandle(this.getNativeResourceHandle(), "styles"), StyleType.class);
        this.on = ObjectManager.getManagedObjectFor(SoSFBool.class, SoPolygonOffset.getFieldHandle(this.getNativeResourceHandle(), "on"));
    }

    static native String getClassTypeId();

    public SoPolygonOffset() {
        this(Inventor.ConstructorCommand.CreateInstance, SoPolygonOffset.ctorImpl());
    }

    public static enum StyleType implements IntegerValuedEnum
    {
        FILLED(StyleType.getFILLED()),
        LINES(StyleType.getLINES()),
        POINTS(StyleType.getPOINTS());

        private int value;

        private static native int getFILLEDNative();

        private StyleType(int n2) {
            this.value = n2;
        }

        private static int getPOINTS() {
            JniInitializer.checkInit();
            return StyleType.getPOINTSNative();
        }

        private static native int getPOINTSNative();

        private static int getLINES() {
            JniInitializer.checkInit();
            return StyleType.getLINESNative();
        }

        private static native int getLINESNative();

        private static int getFILLED() {
            JniInitializer.checkInit();
            return StyleType.getFILLEDNative();
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static StyleType valueOf(int n) {
            return IntegerValuedEnumHelper.fromIntValue(StyleType.class, n);
        }
    }
}

